/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states;

import com.jme.system.GameSettings;
import com.turborilla.gameobject.GameObject;
import com.turborilla.gameobject.IGameObjectHandler;
import com.turborilla.msm.states.StandardState;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public abstract class GameObjectState
extends StandardState
implements IGameObjectHandler {
    private static Logger logger = Logger.getLogger(GameObjectState.class.getCanonicalName());
    private List<GameObject> gameObjectList;
    private List<GameObject> pausedGameObjects;
    LinkedList<GameObject> destructionQueue = new LinkedList();

    public GameObjectState(String string, GameSettings gameSettings, URL uRL) {
        super(string, gameSettings, uRL);
        this.gameObjectList = new LinkedList<GameObject>();
        this.pausedGameObjects = new ArrayList<GameObject>();
    }

    protected void stateUpdate(float f) {
        super.stateUpdate(f);
        this.updateGameObjects(f);
    }

    public void addGameObject(GameObject gameObject) {
        if (this.gameObjectList.contains(gameObject)) {
            logger.warning("gameObject " + gameObject + " already exists in the gameObjectList");
            return;
        }
        this.gameObjectList.add(gameObject);
        gameObject.setParentGameState(this);
        if (this.isPaused()) {
            this.pausedGameObjects.add(gameObject);
            gameObject.setPaused(true);
        }
    }

    public GameObject hasGameObject(String string) {
        GameObject gameObject = null;
        for (GameObject gameObject2 : this.gameObjectList) {
            if (!gameObject2.getName().equals(string)) continue;
            gameObject = gameObject2;
            break;
        }
        return gameObject;
    }

    public boolean removeGameObject(GameObject gameObject) {
        if (gameObject == null) {
            return false;
        }
        this.pausedGameObjects.remove(gameObject);
        if (this.gameObjectList.remove(gameObject)) {
            gameObject.onDetach();
            gameObject.setParentGameState(null);
            logger.info("Detached GameObject \"" + gameObject.getName() + "\" from state \"" + this.getName() + "\"");
            return true;
        }
        return false;
    }

    public boolean removeGameObject(String string) {
        return this.removeGameObject(this.hasGameObject(string));
    }

    public void removeAllGameObjects() {
        for (int i = 0; i < this.gameObjectList.size(); ++i) {
            GameObject gameObject = this.gameObjectList.get(i);
            gameObject.onDetach();
            logger.info("Detached GameObject \"" + gameObject.getName() + "\" from state \"" + this.getName() + "\"");
        }
        this.gameObjectList.clear();
        this.pausedGameObjects.clear();
    }

    private void updateGameObjects(float f) {
        for (GameObject gameObject : this.gameObjectList) {
            if (gameObject.isToBeDetached()) {
                this.destructionQueue.add(gameObject);
                continue;
            }
            gameObject.update(f);
        }
        this.removeThoseQueuedForDestruction();
    }

    public void cleanup() {
        String string = "[";
        for (GameObject gameObject : this.gameObjectList) {
            string = string + gameObject.getName() + ",";
        }
        string = string + "]";
        logger.info("Cleaning up all gameobjects " + string + " of state \"" + this.getName() + "\"");
        this.removeAllGameObjects();
        logger.info("All gameobjects of state \"" + this.getName() + "\" have been detached");
        super.cleanup();
        this.getEventManager().cleanUp();
    }

    protected void removeThoseQueuedForDestruction() {
        GameObject gameObject;
        while ((gameObject = this.destructionQueue.poll()) != null) {
            this.removeGameObject(gameObject);
        }
    }

    public void setPaused(boolean bl) {
        if (!this.isPaused() && bl) {
            for (GameObject gameObject : this.gameObjectList) {
                if (gameObject == null || gameObject.isPaused()) continue;
                this.pausedGameObjects.add(gameObject);
                gameObject.setPaused(true);
            }
        } else if (this.isPaused() && !bl) {
            for (int i = 0; i < this.pausedGameObjects.size(); ++i) {
                GameObject gameObject = this.pausedGameObjects.get(i);
                if (gameObject == null || !gameObject.isPaused()) continue;
                gameObject.setPaused(false);
            }
            this.pausedGameObjects.clear();
        }
        super.setPaused(bl);
    }
}

