/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.states;

import com.jme.image.Texture;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.SceneElement;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.system.GameSettings;
import com.jme.util.export.Savable;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.gui.Label;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.states.BaseGameStateRootNode;
import com.turborilla.utils.Font;
import java.io.IOException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class CreditsGameState
extends BaseGameStateRootNode {
    private boolean inited = false;
    private String font1Name = "normal_small_white";
    private String font2Name = "normal_large_white";
    protected String[] texts = new String[]{"Design & Code#Tobias Andersson", "Sound & Music#Stefan Bj\u00f6rklund", "Graphics#David Ferriz", "Used Technologies#Java#LWJGL#Pauls Sound System#jMonkeyEngine#JZipUpdate#Java Open Particle System#WinFolders", "www.turborilla.com"};
    private Node textNode;
    private float textYpos = 0.0f;
    private float finalYpos = 0.0f;
    protected EventManager eventManager = null;
    private boolean wasKeyDown;
    private int width = -1;
    private int height = -1;

    public CreditsGameState(String string, EventManager eventManager, GameSettings gameSettings) {
        super(string);
        this.eventManager = eventManager;
        if (gameSettings == null || !Boolean.parseBoolean(gameSettings.get("showTurborillaLinks", "false"))) {
            for (int i = 0; i < this.texts.length; ++i) {
                String string2 = this.texts[i];
                if (string2.indexOf("www.") < 0) continue;
                this.texts[i] = null;
            }
        }
    }

    protected void onActivate() throws IOException {
        if (this.width != DisplaySystem.getDisplaySystem().getWidth() || this.height != DisplaySystem.getDisplaySystem().getHeight()) {
            this.init();
        }
        if (this.inited) {
            this.textNode.getLocalTranslation().y = 0.0f;
        }
        this.textYpos = 0.0f;
        this.wasKeyDown = false;
    }

    protected void stateRender(float f) {
        if (!this.inited) {
            this.init();
        }
    }

    private void init() {
        Texture texture;
        Savable savable;
        Object object;
        this.inited = true;
        this.rootNode.detachAllChildren();
        this.rootNode.setRenderQueueMode(4);
        this.rootNode.setCullMode(3);
        ZBufferState zBufferState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(7);
        this.rootNode.setRenderState(zBufferState);
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.width = displaySystem.getWidth();
        this.height = displaySystem.getHeight();
        Quad quad = new Quad("screenQuad", this.width, this.height);
        this.rootNode.attachChild(quad);
        quad.setLocalTranslation(this.width / 2, this.height / 2, 0.0f);
        quad.setDefaultColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        this.textNode = new Node("textNode");
        this.rootNode.attachChild(this.textNode);
        this.textNode.setLightCombineMode(0);
        AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        this.textNode.setRenderState(alphaState);
        Font font = null;
        Font font2 = null;
        try {
            font = (Font)ResourceManager.getInstance().load("font", this.font1Name, null);
            font2 = (Font)ResourceManager.getInstance().load("font", this.font2Name, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        float f = -40.0f;
        float f2 = -40.0f;
        float f3 = -80.0f;
        float f4 = (float)this.width / 2.0f;
        for (int i = 0; i < this.texts.length; ++i) {
            int n;
            if (this.texts[i] == null) continue;
            object = this.texts[i].split("#");
            if (((String[])object).length == 1) {
                savable = new Label(font2, object[0].length());
                ((Label)savable).setText(object[0]);
                ((Label)savable).center();
                this.textNode.attachChild((Spatial)savable);
                ((Spatial)savable).setLocalTranslation((int)f4, (int)f, 0.0f);
                f += f3;
                continue;
            }
            if (((String[])object).length < 4) {
                savable = new Label(font, object[0].length());
                ((Label)savable).setText((String)object[0]);
                ((Label)savable).center();
                this.textNode.attachChild((Spatial)savable);
                ((Spatial)savable).setLocalTranslation((int)f4, (int)f, 0.0f);
                f += f2;
                for (n = 1; n < ((Object)object).length; ++n) {
                    savable = new Label(font2, ((String)object[n]).length());
                    ((Label)savable).setText((String)object[n]);
                    ((Label)savable).center();
                    this.textNode.attachChild((Spatial)savable);
                    ((Spatial)savable).setLocalTranslation((int)f4, (int)f, 0.0f);
                    f += f2 - 10.0f;
                }
                f += f3;
                continue;
            }
            savable = new Label(font2, object[0].length());
            ((Label)savable).setText((String)object[0]);
            ((Label)savable).center();
            this.textNode.attachChild((Spatial)savable);
            ((Spatial)savable).setLocalTranslation((int)f4, (int)f, 0.0f);
            f += f3;
            for (n = 1; n < ((Object)object).length; ++n) {
                savable = new Label(font, ((String)object[n]).length());
                ((Label)savable).setText((String)object[n]);
                ((Label)savable).center();
                this.textNode.attachChild((Spatial)savable);
                ((Spatial)savable).setLocalTranslation((int)f4, (int)f, 0.0f);
                f += f3 - 10.0f;
            }
            f += f2;
        }
        try {
            texture = (Texture)ResourceManager.getInstance().load("texture", "logomenu", null);
            object = new Quad("msmlogo", texture.getImage().getWidth(), texture.getImage().getHeight());
            savable = displaySystem.getRenderer().createTextureState();
            ((TextureState)savable).setTexture(texture);
            ((SceneElement)object).setRenderState((RenderState)savable);
            this.textNode.attachChild((Spatial)object);
            ((Spatial)object).setLocalTranslation(this.width / 2, (float)texture.getImage().getHeight() * 0.6f, 0.0f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            texture = (Texture)ResourceManager.getInstance().load("texture", "turborilla_on_black", null);
            object = new Quad("turborillalogo", texture.getImage().getWidth(), texture.getImage().getHeight());
            savable = displaySystem.getRenderer().createTextureState();
            ((TextureState)savable).setTexture(texture);
            ((SceneElement)object).setRenderState((RenderState)savable);
            this.textNode.attachChild((Spatial)object);
            ((Spatial)object).setLocalTranslation(this.width / 2, (int)(f - (float)texture.getImage().getHeight() * 0.5f), 0.0f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.finalYpos = -f + (float)this.height;
        this.rootNode.updateRenderState();
    }

    protected void stateUpdate(float f) {
        if (f > 0.02f) {
            f = 0.02f;
        }
        if (this.inited && this.textYpos < this.finalYpos) {
            this.textYpos += f / 0.03f * ((float)DisplaySystem.getDisplaySystem().getHeight() / 768.0f);
            this.textNode.getLocalTranslation().y = this.textYpos;
        } else if (this.inited) {
            this.textNode.getLocalTranslation().y = (int)Math.floor(this.textNode.getLocalTranslation().y);
        }
        if (this.textYpos > 20.0f) {
            if (Mouse.isButtonDown(0) && !this.wasKeyDown) {
                this.wasKeyDown = true;
                this.anyKeyPressed();
            } else if (!this.wasKeyDown) {
                for (int i = 0; i < Keyboard.getKeyCount(); ++i) {
                    if (!Keyboard.isKeyDown(i)) continue;
                    this.wasKeyDown = true;
                    this.anyKeyPressed();
                    break;
                }
            }
        }
    }

    protected void anyKeyPressed() {
        this.eventManager.fireEvent("AnyKeyPressed");
    }
}

