/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.statemachine;

import com.jme.system.GameSettings;
import com.turborilla.event.typesafe.Event;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.msm.statemachine.Countdown;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.msm.states.menus.special.BetweenRacesGUIState;
import com.turborilla.statemachine.StateMachine;
import com.turborilla.statemachine.TransitionWork;

public class ReplayCountdown
extends Countdown {
    private TransitionWork fromManageReplayToReplayCountdown = new TransitionWork(){

        public void before() {
            ReplayCountdown.this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {"Empty", "true"}});
        }

        public boolean during(float f) {
            ReplayCountdown.this.getStateMachine().getEventManager().fireEvent(new Event("DeactivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
            ReplayCountdown.this.prepareReplayRace();
            return true;
        }

        public void after() {
            ReplayCountdown.this.gameState.setNNEnabled(false);
            ReplayCountdown.this.gameState.resetBikePositions();
            ReplayCountdown.this.startCountdown();
        }
    };

    public ReplayCountdown(GameState gameState, GameSettings gameSettings, BetweenRacesGUIState betweenRacesGUIState) {
        super(gameState, gameSettings, betweenRacesGUIState);
        this.setName("ReplayCountdown");
    }

    protected void registerEvents(StateMachine stateMachine) {
        stateMachine.registerForEvent("FinishedCountdown", this);
        stateMachine.registerForEvent("PassedStartline", this);
        stateMachine.registerForEvent("EscapePressed", this);
        this.getStateMachine().addTransition("ManageReplay", this.getName(), this.fromManageReplayToReplayCountdown);
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (receivedEvent.is("FinishedCountdown")) {
            this.finishedCountdown();
        } else if (receivedEvent.is("PassedStartline")) {
            this.passedStartline();
        } else if (receivedEvent.is("EscapePressed")) {
            this.pressedEscape();
        }
    }

    protected void pressedEscape() {
        this.getStateMachine().activateState("Results");
    }

    protected void startCountdown() {
        this.gameState.startMonitoringChallenges();
        this.gameState.setControlEnabled(true, true);
        this.gameState.startCountdown();
        this.gameState.startReplayComponent();
        this.gameState.waitForStabilizedFrameRate(true);
        if (this.gameState.getLapDisplayer() != null) {
            this.gameState.getLapDisplayer().setPaused(false);
        }
    }

    protected void finishedCountdown() {
        this.getStateMachine().activateState("ReplayRace");
    }

    protected void passedStartline() {
        this.finishedCountdown();
    }

    protected void prepareReplayRace() {
    }
}

