/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.statemachine;

import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.profile.ProgressData;
import com.turborilla.msm.statemachine.AbstractState;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.statemachine.StateMachine;
import java.io.IOException;

public class Race
extends AbstractState {
    private GameState gameState;

    public Race(GameState gameState) {
        this.setName("Race");
        this.gameState = gameState;
    }

    protected void registerEvents(StateMachine stateMachine) {
        stateMachine.registerForEvent("AllHumansPassedFinishline", this);
        stateMachine.registerForEvent("EscapePressed", this);
    }

    public void onEnter(String string) {
        if (!"IngameMenu".equals(string)) {
            try {
                this.gameState.getFrameRateManager().startRecordingStats();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            ProgressData.Division[] divisionArray = Profile.getCurrentProfile(this.getStateMachine().getSettings()).getData().getProgressData().getDivisions();
            ProgressData.Division division = divisionArray[this.gameState.getRaceResults().getDivisionIndex()];
            ProgressData.Division.Track[] trackArray = division.getTracks();
            ProgressData.Division.Track track = trackArray[this.gameState.getRaceResults().getTrackIndex()];
            track.increaseNumberOfRaces();
        }
        this.getStateMachine().getEventManager().fireEvent("TemporaryVolumeChanged", new String[][]{{"category", "volume", "time"}, {"GameMusicVolume", "1", "1"}});
    }

    public void onLeave() {
        this.getStateMachine().getEventManager().fireEvent("TemporaryVolumeChanged", new String[][]{{"category", "volume", "time"}, {"GameMusicVolume", "0.4", "3"}});
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (receivedEvent.is("AllHumansPassedFinishline")) {
            this.gameState.getFrameRateManager().stopRecordingStatsAsynch();
            this.getStateMachine().activateState("Finish");
        } else if (receivedEvent.is("EscapePressed")) {
            this.getStateMachine().activateState("IngameMenu");
        }
    }
}

