/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.statemachine;

import com.jme.system.GameSettings;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.statemachine.AbstractState;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.statemachine.StateMachine;
import com.turborilla.statemachine.TransitionWork;

public class Menu
extends AbstractState {
    private GameState gameState;
    private GameSettings settings;
    public TransitionWork menuToEditor = new TransitionWork(){

        public void before() {
        }

        public boolean during(float f) {
            Menu.this.getStateMachine().getEventManager().fireEvent("SwitchState", new String[][]{{"switchTo", "switchFrom"}, {"EditorState", "MenuState"}});
            return true;
        }

        public void after() {
        }
    };

    public Menu(GameState gameState, GameSettings gameSettings) {
        this.setName("Menu");
        this.gameState = gameState;
        this.settings = gameSettings;
    }

    protected void registerEvents(StateMachine stateMachine) {
        stateMachine.registerForEvent("ButtonPressed", this);
        stateMachine.registerForEvent("EscapePressed", this);
        this.getStateMachine().addTransition(this.getName(), "Editor", this.menuToEditor);
    }

    public void onEnter(String string) {
        this.getStateMachine().getEventManager().fireEvent("UnpauseState", new String[][]{{"stateName"}, {"Game"}});
        this.getStateMachine().getEventManager().fireEvent("PlayMusic", new String[][]{{"track", "fadeTime"}, {"menu", "2.3"}});
        this.getStateMachine().getEventManager().fireEvent("ActivateState", new String[][]{{"stateName"}, {"MenuState"}});
        this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {"Main", "true"}});
        this.getStateMachine().getEventManager().fireEvent("StartNewBackgroundRace");
        this.getStateMachine().getEventManager().fireEvent("DeactivateState", new String[][]{{"stateName"}, {"startupState"}});
    }

    public void onLeave() {
        this.getStateMachine().getEventManager().fireEvent("DeactivateState", new String[][]{{"stateName"}, {"MenuState"}});
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (receivedEvent.is("ButtonPressed") && receivedEvent.argumentIs("name", "arcadePlayButton")) {
            this.play(Difficulty.Arcade);
        } else if (receivedEvent.is("ButtonPressed") && receivedEvent.argumentIs("name", "simulationPlayButton")) {
            this.play(Difficulty.Simulation);
        } else if (receivedEvent.is("ButtonPressed") && receivedEvent.argumentIs("name", "editorButton")) {
            this.getStateMachine().transitionToState("Editor");
        } else if (receivedEvent.is("ButtonPressed") && receivedEvent.argumentIs("name", "playTimeAttackButton")) {
            this.getStateMachine().activateState("TimeAttackMenu");
        } else if (receivedEvent.is("ButtonPressed") && receivedEvent.argumentIs("name", "creditsButton")) {
            this.getStateMachine().transitionToState("Credits");
        } else if (receivedEvent.is("ButtonPressed") && receivedEvent.argumentIs("name", "profileStatsButton")) {
            this.getStateMachine().transitionToState("ViewProfileStats");
        } else if (receivedEvent.is("ButtonPressed") && receivedEvent.argumentIs("name", "exitButton")) {
            if ("Demo".equals(this.settings.get("version", "Demo"))) {
                this.getStateMachine().transitionToState("QuitUpsell");
            } else {
                this.getStateMachine().getEventManager().fireEvent("Quit");
            }
        } else if (receivedEvent.is("EscapePressed")) {
            this.getStateMachine().getEventManager().fireEvent("EscapePressedInMenu");
        }
    }

    private void play(Difficulty difficulty) {
        int n;
        Profile.getCurrentProfile(this.settings).setDifficulty(difficulty);
        int n2 = Profile.getCurrentProfile(this.settings).getData().getProgressData().getCurrentDivision().getIndex();
        if (n2 == 0 && (n = Profile.getCurrentProfile(this.settings).getData().getProgressData().getCurrentDivision().getCurrentTrack().getIndex()) == 0) {
            this.getStateMachine().transitionToState("Countdown");
            return;
        }
        this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {"Empty", "true"}});
        this.getStateMachine().transitionToState("ChooseTrack");
    }
}

