/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.statemachine;

import com.jme.math.Vector3f;
import com.jme.system.GameSettings;
import com.turborilla.event.typesafe.Event;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.msm.division.DivisionDescriptor;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.profile.ProgressData;
import com.turborilla.msm.statemachine.AbstractState;
import com.turborilla.msm.statemachine.MsmStateMachineException;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.msm.states.menus.special.BetweenRacesGUIState;
import com.turborilla.statemachine.StateMachine;
import com.turborilla.statemachine.TransitionWork;
import com.turborilla.utils.Utils;
import java.io.IOException;
import java.util.Properties;

public class Countdown
extends AbstractState {
    protected GameState gameState;
    protected GameSettings settings;
    protected BetweenRacesGUIState guiState;
    protected static String music = "track2";
    protected static String[] availableMusic = new String[]{"track2", "track4", "control", "sidious2", "stiffrock", "theblockrocker", "tobbe"};
    private TransitionWork fromMenuToCountdown = new TransitionWork(){

        public void before() {
            Countdown.this.getStateMachine().getEventManager().fireEvent("StopMusic", new String[][]{{"fadeTime"}, {"0.2"}});
        }

        public boolean during(float f) {
            Countdown.this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {"Empty", "true"}});
            Countdown.this.prepareNextRace();
            Countdown.this.getStateMachine().getEventManager().fireEvent("PlayMusic", new String[][]{{"track", "fadeTime"}, {music, "0.5"}});
            return true;
        }

        public void after() {
            Countdown.this.getStateMachine().getTaskManager().add(new Runnable(){

                public void run() {
                    Countdown.this.startCountdown();
                }
            }, 1.0f);
        }
    };
    private TransitionWork fromResultsToCountdown = new TransitionWork(){

        public void before() {
        }

        public boolean during(float f) {
            Countdown.this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {"Empty", "true"}});
            Countdown.this.getStateMachine().getEventManager().fireEvent(new Event("DeactivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
            Countdown.this.prepareRetryRace();
            Countdown.this.getStateMachine().getEventManager().fireEvent("PlayMusic", new String[][]{{"track", "fadeTime"}, {music, "0.5"}});
            return true;
        }

        public void after() {
            Countdown.this.gameState.setNNEnabled(false);
            Countdown.this.gameState.resetBikePositions();
            Countdown.this.startCountdown();
        }
    };
    private TransitionWork fromIngameMenuCountdown = new TransitionWork(){

        public void before() {
        }

        public boolean during(float f) {
            Countdown.this.prepareRetryRace();
            Countdown.this.getStateMachine().getEventManager().fireEvent("PlayMusic", new String[][]{{"track", "fadeTime"}, {music, "0.5"}});
            Countdown.this.gameState.setNNEnabled(false);
            Countdown.this.gameState.resetBikePositions();
            return true;
        }

        public void after() {
            Countdown.this.startCountdown();
        }
    };
    private TransitionWork fromChooseTrackToCountdown = new TransitionWork(){

        public void before() {
        }

        public boolean during(float f) {
            int n = (int)Math.floor(Math.random() * (double)availableMusic.length);
            music = availableMusic[n];
            Countdown.this.getStateMachine().getEventManager().fireEvent("PlayMusic", new String[][]{{"track", "fadeTime"}, {music, "1.5"}});
            return true;
        }

        public void after() {
            Countdown.this.startCountdown();
        }
    };
    private Properties raceProperties;
    private int currentDivision;
    private int currentTrack;

    public Countdown(GameState gameState, GameSettings gameSettings, BetweenRacesGUIState betweenRacesGUIState) {
        this.setName("Countdown");
        this.gameState = gameState;
        this.settings = gameSettings;
        this.guiState = betweenRacesGUIState;
    }

    protected void registerEvents(StateMachine stateMachine) {
        stateMachine.registerForEvent("FinishedCountdown", this);
        stateMachine.registerForEvent("PassedStartline", this);
        stateMachine.registerForEvent("EscapePressed", this);
        this.getStateMachine().addTransition("Menu", this.getName(), this.fromMenuToCountdown);
        this.getStateMachine().addTransition("IngameMenu", this.getName(), this.fromIngameMenuCountdown);
        this.getStateMachine().addTransition("Results", this.getName(), this.fromResultsToCountdown);
        this.getStateMachine().addTransition("ChooseTrack", this.getName(), this.fromChooseTrackToCountdown);
    }

    public void onEnter(String string) {
        if (this.getName().equals(string)) {
            this.startCountdown();
        }
    }

    public void onLeave() {
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (receivedEvent.is("FinishedCountdown")) {
            this.finishedCountdown();
        } else if (receivedEvent.is("PassedStartline")) {
            this.passedStartline();
        } else if (receivedEvent.is("EscapePressed")) {
            this.getStateMachine().activateState("IngameMenu");
        }
    }

    protected void startCountdown() {
        if (this.gameState.getBeforeRaceText() != null) {
            this.showMessage();
        } else {
            this.startCountDownNoMessage();
        }
    }

    private void startCountDownNoMessage() {
        this.gameState.startMonitoringChallenges();
        this.gameState.setControlEnabled(true, true);
        this.gameState.startCountdown();
        this.gameState.startAIRecording();
        this.gameState.startReplayComponent();
        this.gameState.waitForStabilizedFrameRate(true);
        if (this.gameState.getLapDisplayer() != null) {
            this.gameState.getLapDisplayer().setPaused(false);
        }
    }

    protected void finishedCountdown() {
        this.gameState.setNNEnabled(true);
        this.gameState.startAIRaceRecording();
        this.gameState.startCollectingStats();
        this.getStateMachine().activateState("Race");
    }

    protected void passedStartline() {
        this.gameState.stopReplayComponent();
        this.gameState.stopAIRecording();
        this.gameState.setControlEnabled(true, false);
        this.gameState.stopMonitoringChallenges();
        Runnable runnable = new Runnable(){

            public void run() {
                Countdown.this.gameState.resetBikePositions();
                Countdown.this.getStateMachine().transitionToState("Countdown");
            }
        };
        this.getStateMachine().getTaskManager().add(runnable, 2.0f);
    }

    private void showMessage() {
        this.guiState.getMessagePanel().setText(this.gameState.getBeforeRaceText());
        this.guiState.getMessagePanel().setImage(this.gameState.getBeforeRaceImage());
        this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"Message"}});
        this.getStateMachine().getEventManager().fireEvent(new Event("ActivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
        this.guiState.getMessagePanel().getOkButton().addListener(new IButtonClickedListener(){

            public void onClick(MenuButton menuButton, Vector3f vector3f) {
                Countdown.this.getStateMachine().getEventManager().fireEvent("SwitchMenu", new String[][]{{"menu"}, {"Empty"}});
                Countdown.this.getStateMachine().getTaskManager().add(new Runnable(){

                    public void run() {
                        Countdown.this.getStateMachine().getEventManager().fireEvent(new Event("DeactivateState", new String[][]{{"stateName"}, {"BetweenRacesGUIState"}}));
                        Countdown.this.startCountDownNoMessage();
                    }
                }, 1.0f);
            }
        });
    }

    protected void prepareRetryRace() {
        try {
            DivisionDescriptor divisionDescriptor = Profile.getCurrentProfile(this.getStateMachine().getSettings()).getDifficulty() == Difficulty.Arcade ? (DivisionDescriptor)ResourceManager.getInstance().load("divisiondescriptor", "arcade_divisions", null) : (DivisionDescriptor)ResourceManager.getInstance().load("divisiondescriptor", "simulation_divisions", null);
            this.gameState.prepareBeforeRaceMessage(divisionDescriptor, this.gameState.getRaceResults().getDivisionIndex(), this.gameState.getRaceResults().getTrackIndex());
            this.gameState.prepareNewRace(null, divisionDescriptor, -1, -1);
        }
        catch (IOException iOException) {
            throw new MsmStateMachineException(iOException);
        }
    }

    private void prepareNextRace() {
        String string = this.prepareNextTrack();
    }

    private String prepareNextTrack() {
        String string = null;
        try {
            this.currentDivision = -1;
            this.currentTrack = -1;
            ProgressData progressData = Profile.getCurrentProfile(this.settings).getData().getProgressData();
            ProgressData.Division division = progressData.getCurrentDivision();
            this.currentDivision = division.getIndex();
            this.currentTrack = division.getCurrentTrack().getIndex();
            DivisionDescriptor divisionDescriptor = Profile.getCurrentProfile(this.getStateMachine().getSettings()).getDifficulty() == Difficulty.Arcade ? (DivisionDescriptor)ResourceManager.getInstance().load("divisiondescriptor", "arcade_divisions", null) : (DivisionDescriptor)ResourceManager.getInstance().load("divisiondescriptor", "simulation_divisions", null);
            string = divisionDescriptor.getTrack(this.currentDivision, this.currentTrack);
            boolean bl = Boolean.parseBoolean(divisionDescriptor.getTrackProperty(this.currentDivision, this.currentTrack, "challenge", "false"));
            if (!bl) {
                this.raceProperties = Utils.getProperties(new String[][]{{"environment", "track", "numberOfLaps", "numberOfBikes", "bike0", "bike1", "cameraFollowBikeNumber", "startsequence", "finishline", "controlMode", "specialAbility"}, {divisionDescriptor.getEnvironment(this.currentDivision, null), string, divisionDescriptor.getLaps(this.currentDivision, this.currentTrack) + "", "2", "human", "computer", "0", "true", "true", Profile.getCurrentProfile(this.getStateMachine().getSettings()).getDifficulty().getName(), divisionDescriptor.getTrackProperty(this.currentDivision, this.currentTrack, "special", null)}});
                this.gameState.prepareNewRace(this.raceProperties, divisionDescriptor, this.currentDivision, this.currentTrack);
            } else {
                this.raceProperties = Utils.getProperties(new String[][]{{"environment", "track", "numberOfLaps", "numberOfBikes", "bike0", "cameraFollowBikeNumber", "startsequence", "finishline", "controlMode", "specialAbility"}, {divisionDescriptor.getEnvironment(this.currentDivision, null), string, divisionDescriptor.getLaps(this.currentDivision, this.currentTrack) + "", "1", "human", "0", "true", "true", Profile.getCurrentProfile(this.getStateMachine().getSettings()).getDifficulty().getName(), divisionDescriptor.getTrackProperty(this.currentDivision, this.currentTrack, "special", null)}});
                this.gameState.prepareNewRace(this.raceProperties, divisionDescriptor, this.currentDivision, this.currentTrack);
            }
            this.gameState.getRaceResults().setDivisionIndex(this.currentDivision);
            this.gameState.getRaceResults().setTrackIndex(this.currentTrack);
        }
        catch (IOException iOException) {
            throw new MsmStateMachineException(iOException);
        }
        return string;
    }
}

