/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.rewards.stats;

import com.turborilla.msm.rewards.listeners.IStatChangedListener;
import com.turborilla.msm.rewards.listeners.IStatFinalizedListener;
import com.turborilla.msm.rewards.listeners.IStatUndoListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatWatcher<StatType extends Comparable<StatType>, ClassToWatch> {
    private StatType stat;
    private StatType previousStat;
    protected ClassToWatch object;
    private float timeToUndo;
    private float timeSinceChanged;
    private boolean undo;
    private boolean pendingChange;
    private IStatChangedListener<StatType> changedListener;
    private IStatUndoListener<StatType> undoListener;
    private IStatFinalizedListener<StatType> finalizedListener;

    public StatWatcher(ClassToWatch ClassToWatch) {
        this(-1.0f, ClassToWatch);
    }

    public StatWatcher(float f, ClassToWatch ClassToWatch) {
        this.timeToUndo = f;
        this.object = ClassToWatch;
        this.changedListener = null;
        this.undoListener = null;
        this.reset();
    }

    public final StatType getStat() {
        return this.stat;
    }

    protected final void setStat(StatType StatType) {
        this.previousStat = this.stat;
        this.stat = StatType;
        this.timeSinceChanged = 0.0f;
        if (this.timeToUndo >= 0.0f) {
            this.pendingChange = true;
        }
        this.fireChangeEvent(this.previousStat, this.stat);
    }

    public final void undo() {
        this.undo = true;
    }

    public final void update(float f) {
        if (this.pendingChange) {
            if (this.undo) {
                this.fireUndoEvent(this.stat, this.previousStat);
                this.stat = this.previousStat;
                this.pendingChange = false;
            } else {
                this.timeSinceChanged += f;
                if (this.timeSinceChanged > this.timeToUndo) {
                    this.pendingChange = false;
                    this.fireFinalizedEvent(this.previousStat, this.stat);
                }
            }
        }
        if (this.undo) {
            this.undo = false;
        }
        this.doUpdate(f);
    }

    public final void reset() {
        this.undo = false;
        this.pendingChange = false;
        this.stat = null;
        this.previousStat = null;
        this.timeSinceChanged = 0.0f;
        if (this.changedListener != null) {
            this.changedListener.reset();
        }
        this.doReset();
    }

    public final void forceApplyPendingChange() {
        this.checkAndRecord();
        this.pendingChange = false;
    }

    public final void forceFinalize() {
        this.fireFinalizedEvent(this.previousStat, this.stat);
    }

    protected abstract void doUpdate(float var1);

    protected abstract void doReset();

    protected abstract void checkAndRecord();

    public StatWatcher<StatType, ClassToWatch> setChangedListener(IStatChangedListener<StatType> iStatChangedListener) {
        this.changedListener = iStatChangedListener;
        return this;
    }

    public StatWatcher<StatType, ClassToWatch> setUndoListener(IStatUndoListener<StatType> iStatUndoListener) {
        this.undoListener = iStatUndoListener;
        return this;
    }

    public StatWatcher<StatType, ClassToWatch> setFinalizedListener(IStatFinalizedListener<StatType> iStatFinalizedListener) {
        this.finalizedListener = iStatFinalizedListener;
        return this;
    }

    private final void fireChangeEvent(StatType StatType, StatType StatType2) {
        if (this.changedListener != null) {
            this.changedListener.onChange((Comparable<StatType>)StatType, (Comparable<StatType>)StatType2);
        }
    }

    private final void fireUndoEvent(StatType StatType, StatType StatType2) {
        if (this.undoListener != null) {
            this.undoListener.onUndo((Comparable<StatType>)StatType, (Comparable<StatType>)StatType2);
        }
    }

    private final void fireFinalizedEvent(StatType StatType, StatType StatType2) {
        if (this.finalizedListener != null) {
            this.finalizedListener.onFinalize((Comparable<StatType>)StatType, (Comparable<StatType>)StatType2);
        }
    }

    public IStatFinalizedListener<StatType> getFinalizedListener() {
        return this.finalizedListener;
    }
}

