/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.rewards.listeners;

import com.turborilla.event.typesafe.EventManager;
import com.turborilla.msm.rewards.listeners.IStatChangedListener;
import com.turborilla.msm.rewards.listeners.IStatFinalizedListener;
import com.turborilla.msm.rewards.listeners.IStatUndoListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RewardIntervalListener<E extends Comparable<E>>
implements IStatChangedListener<E>,
IStatUndoListener<E>,
IStatFinalizedListener<E> {
    protected EventManager eventManager;
    private String reward;
    protected E[] intervals;
    private int intervalIndex = 0;
    protected String textBeforeNumber;
    private int finalizedIntervalIndex = 0;

    public RewardIntervalListener(EventManager eventManager, String string, E[] EArray, String string2) {
        this.eventManager = eventManager;
        this.reward = string;
        this.intervals = EArray;
        this.textBeforeNumber = string2;
    }

    @Override
    public void onFinalize(Comparable<E> comparable, Comparable<E> comparable2) {
        this.eventManager.fireEvent("CollectReward", new String[][]{{"reward"}, {this.reward}});
        this.finalizedIntervalIndex = this.intervalIndex;
    }

    @Override
    public void onUndo(Comparable<E> comparable, Comparable<E> comparable2) {
        if (this.intervalIndex > 0 && (comparable2 == null || comparable2.compareTo(this.intervals[this.intervalIndex - 1]) < 0)) {
            this.eventManager.fireEvent("UndoReward", new String[][]{{"reward"}, {this.reward}});
            if (comparable2 == null) {
                this.intervalIndex = 0;
            } else {
                for (int i = 0; i < this.intervals.length; ++i) {
                    if (comparable2.compareTo(this.intervals[i]) >= 0) continue;
                    this.intervalIndex = i;
                    break;
                }
            }
        }
    }

    @Override
    public void onChange(Comparable<E> comparable, Comparable<E> comparable2) {
        if (this.intervalIndex >= this.intervals.length) {
            return;
        }
        int n = this.intervalIndex;
        if (comparable2.compareTo(this.intervals[this.intervalIndex]) >= 0) {
            ++this.intervalIndex;
            boolean bl = false;
            if (this.intervalIndex < this.intervals.length) {
                for (int i = this.intervalIndex; i < this.intervals.length; ++i) {
                    if (comparable2.compareTo(this.intervals[i]) >= 0) continue;
                    this.intervalIndex = i;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.intervalIndex = this.intervals.length;
                }
            }
            String string = this.getRewardText(this.intervalIndex - 1);
            this.eventManager.fireEvent("ShowReward", new String[][]{{"reward", "text", "previous", "accomplished"}, {this.reward, string, "" + n, "" + this.intervalIndex}});
        }
    }

    protected String getRewardText(int n) {
        return this.textBeforeNumber;
    }

    public void setText(String string) {
        this.textBeforeNumber = string;
    }

    @Override
    public void reset() {
        this.intervalIndex = 0;
        this.finalizedIntervalIndex = 0;
    }

    @Override
    public String getRewardIdentifier() {
        return this.reward;
    }

    @Override
    public int getFinalizedInterval() {
        return this.finalizedIntervalIndex;
    }

    @Override
    public void setFinalizedInterval(int n) {
        this.intervalIndex = n;
        this.finalizedIntervalIndex = n;
    }
}

