/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.rewards;

import com.jme.image.Texture;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.LightState;
import com.jme.system.DisplaySystem;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.gameobject.GameObject;
import com.turborilla.gui.VerticalAlignment;
import com.turborilla.gui.VerticalLabelList;
import com.turborilla.msm.gameobjects.ParticleFXGameObject;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.profile.RewardData;
import com.turborilla.msm.rewards.LabelAndStarsEntry;
import com.turborilla.msm.states.GameObjectState;
import com.turborilla.sound.SFX;
import com.turborilla.utils.Font;
import com.turborilla.utils.Scheduling;
import com.turborilla.utils.controllers.AbstractSpatialController;
import com.turborilla.utils.controllers.IControllerListener;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class RewardDisplayer
extends GameObject {
    private Node node;
    private Font font;
    private VerticalLabelList labelList;
    private static final ColorRGBA noAlphaColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 0.0f);
    private static final ColorRGBA pendingColor1 = new ColorRGBA(1.0f, 0.3f, 0.3f, 0.5f);
    private static final ColorRGBA pendingColor2 = new ColorRGBA(1.0f, 1.0f, 1.0f, 0.5f);
    private static final ColorRGBA collectedColor1 = new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
    private static final ColorRGBA collectedColor2 = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private static final ColorRGBA lostColor1 = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.4f);
    private static final ColorRGBA lostColor2 = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    private static final float collectedAnimTime = 3.0f;
    private static Vector3f collectedAnimScale;
    private static Vector3f collectedAnimPos;
    private static Vector3f labelPos;
    private LabelRemover labelRemover;
    private Scheduling taskManager;
    private SFX showSFX;
    private SFX showNewSFX;
    private SFX lostSFX;
    private SFX collectedSFX;
    private boolean showIsPlaying = false;
    private boolean showNewIsPlaying = false;
    private boolean lostIsPlaying = false;
    private boolean collectedIsPlaying = false;
    private Vector3f tempVec = new Vector3f();
    private Texture starOffTexture;
    private Texture starOnTexture;
    private static final String EVENT_SHOWREWARD = "ShowReward";
    private static final String EVENT_UNDOREWARD = "UndoReward";
    private static final String EVENT_COLLECTREWARD = "CollectReward";
    private ParticleFXGameObject fxGameObject;

    public RewardDisplayer(Font font) {
        super("RewardDisplayer");
        this.node = new Node(this.getName() + ":node");
        this.font = font;
        this.taskManager = new Scheduling();
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.labelList = new VerticalLabelList(new Vector3f(), new Vector3f(), (float)displaySystem.getHeight() * 0.15f / 3.0f);
        this.labelList.setMoveDamping(0.09f);
        this.labelList.setVerticalAlignment(VerticalAlignment.TOP);
        this.updatePositions();
        this.node.attachChild(this.labelList.getNode());
        this.labelRemover = new LabelRemover(this.node);
        AlphaState alphaState = displaySystem.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setTestEnabled(false);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        this.node.setRenderState(alphaState);
        this.node.setLightCombineMode(5);
        LightState lightState = displaySystem.getRenderer().createLightState();
        lightState.setEnabled(true);
        this.node.setRenderState(lightState);
        try {
            Properties properties = new Properties();
            properties.setProperty("textureMinFilter", "5");
            properties.setProperty("textureMagFilter", "1");
            this.starOnTexture = (Texture)ResourceManager.getInstance().load("texture", "star_on", properties);
            this.starOffTexture = (Texture)ResourceManager.getInstance().load("texture", "star_off", properties);
        }
        catch (IOException iOException) {
            Logger.getLogger(RewardDisplayer.class.getCanonicalName()).severe("Could not load \"star\" texture. Exception: " + iOException);
        }
        this.fxGameObject = new ParticleFXGameObject("starFX", 10);
        try {
            this.fxGameObject.load("light_star");
            this.fxGameObject.setRepeat(false);
            this.fxGameObject.setOrtho();
        }
        catch (Exception exception) {
            this.fxGameObject = null;
        }
        try {
            this.showSFX = (SFX)ResourceManager.getInstance().load("sfx", "show_reward", null);
            this.showNewSFX = (SFX)ResourceManager.getInstance().load("sfx", "show_new_reward", null);
            this.lostSFX = (SFX)ResourceManager.getInstance().load("sfx", "lost_reward", null);
            this.collectedSFX = (SFX)ResourceManager.getInstance().load("sfx", "collect_reward", null);
            this.showSFX.setVolumeCategory("GameSFXVolume");
            this.showNewSFX.setVolumeCategory("GameSFXVolume");
            this.lostSFX.setVolumeCategory("GameSFXVolume");
            this.collectedSFX.setVolumeCategory("GameSFXVolume");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updatePositions() {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        collectedAnimScale = new Vector3f(0.2f, 0.2f, 1.0f);
        collectedAnimPos = new Vector3f((float)displaySystem.getWidth() * 1.1f, (float)displaySystem.getHeight() * 1.3f, 0.0f);
        labelPos = new Vector3f((float)displaySystem.getWidth() * 0.3f, (float)displaySystem.getHeight() * 0.8f, 0.0f);
        this.labelList.setMin(new Vector3f((float)displaySystem.getWidth() * 0.7f, (float)displaySystem.getHeight() * 0.6f, 0.0f));
        this.labelList.setMax(new Vector3f((float)displaySystem.getWidth() * 0.9f, (float)displaySystem.getHeight() * 1.0f, 0.0f));
        this.labelList.setNewLinesEnterPosition(new Vector3f((float)displaySystem.getWidth() * 0.72f, (float)displaySystem.getHeight() * 0.78f, 0.0f));
        this.labelList.setMoveDamping(0.09f);
        this.labelList.setVerticalAlignment(VerticalAlignment.TOP);
    }

    public void setParentGameState(GameObjectState gameObjectState) {
        super.setParentGameState(gameObjectState);
        if (this.fxGameObject != null && this.getParentGameState() != null) {
            this.getParentGameState().addGameObject(this.fxGameObject);
        }
        this.node.updateRenderState();
    }

    public void onDetach() {
        if (this.fxGameObject != null) {
            this.fxGameObject.detachFromParent();
            if (this.getParentGameState() != null) {
                this.getParentGameState().removeGameObject(this.fxGameObject);
            }
        }
        this.reset();
        super.onDetach();
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        String string;
        LabelAndStarsEntry labelAndStarsEntry;
        this.updatePositions();
        final RewardData rewardData = Profile.getCurrentProfile(this.getParentGameState().getSettings()).getData().getRewardData();
        if (receivedEvent.getName().equals(EVENT_SHOWREWARD)) {
            String string2 = receivedEvent.getArgumentValue("reward");
            String string3 = receivedEvent.getArgumentValue("text");
            int n = Integer.parseInt(receivedEvent.getArgumentValue("previous"));
            final int n2 = Integer.parseInt(receivedEvent.getArgumentValue("accomplished"));
            int n3 = rewardData.getNumberOfStars(string2);
            final LabelAndStarsEntry labelAndStarsEntry2 = LabelAndStarsEntry.getOrCreateLabel(string2, string3, this.labelList, this.font, this.starOnTexture, this.starOffTexture);
            if (!this.showIsPlaying) {
                this.showSFX.play();
                this.showIsPlaying = true;
                this.taskManager.add(new Runnable(){

                    public void run() {
                        RewardDisplayer.this.showIsPlaying = false;
                    }
                }, 1.0f);
            }
            if (n2 > n3) {
                int n4 = n3;
                if (n > n4) {
                    n4 = n;
                }
                labelAndStarsEntry2.getStars().setNumberOfLit(n4);
                this.taskManager.add(new Runnable(){

                    public void run() {
                        int[] nArray = labelAndStarsEntry2.getStars().setNumberOfLit(n2, RewardDisplayer.this.fxGameObject);
                        for (int i = 0; i < nArray.length; ++i) {
                            int n = nArray[i];
                            if (n < 0) continue;
                            Node node = RewardDisplayer.this.fxGameObject.getNode(n);
                            node.setLocalScale(new Vector3f(45.0f, 45.0f, 0.1f));
                        }
                        if (!RewardDisplayer.this.showNewIsPlaying && !RewardDisplayer.this.lostIsPlaying) {
                            RewardDisplayer.this.showNewSFX.play();
                            RewardDisplayer.this.showNewIsPlaying = true;
                            RewardDisplayer.this.taskManager.add(new Runnable(){

                                public void run() {
                                    RewardDisplayer.this.showNewIsPlaying = false;
                                }
                            }, 1.0f);
                        }
                    }
                }, 0.7f);
            } else {
                labelAndStarsEntry2.getStars().setNumberOfLit(n2);
            }
        } else if (receivedEvent.getName().equals(EVENT_UNDOREWARD)) {
            String string4 = receivedEvent.getArgumentValue("reward");
            LabelAndStarsEntry labelAndStarsEntry3 = (LabelAndStarsEntry)this.labelList.findLabel(string4);
            if (labelAndStarsEntry3 != null) {
                this.labelList.fadeOutAndRemoveLabel((VerticalLabelList.LabelEntry)labelAndStarsEntry3, 0.8f, null, lostColor1, lostColor2);
            }
            if (this.showSFX.isPlaying()) {
                this.showSFX.stop();
            }
            if (this.showNewSFX.isPlaying()) {
                this.showNewSFX.stop();
            }
            if (!this.lostIsPlaying) {
                this.lostSFX.play();
                this.lostIsPlaying = true;
                this.taskManager.add(new Runnable(){

                    public void run() {
                        RewardDisplayer.this.lostIsPlaying = false;
                    }
                }, 1.0f);
            }
        } else if (receivedEvent.getName().equals(EVENT_COLLECTREWARD) && (labelAndStarsEntry = (LabelAndStarsEntry)this.labelList.findLabel(string = receivedEvent.getArgumentValue("reward"))) != null) {
            this.taskManager.add(new Runnable(){

                public void run() {
                    RewardDisplayer.this.labelList.removeLabel(labelAndStarsEntry);
                    RewardDisplayer.this.node.attachChild(labelAndStarsEntry.getLabel());
                    labelAndStarsEntry.getMover().clearListeners();
                    labelAndStarsEntry.getMover().clearTranslationQueue();
                    labelAndStarsEntry.getMover().translateTo(collectedAnimPos, 3.0f, 3.0f);
                    labelAndStarsEntry.getMover().add(RewardDisplayer.this.labelRemover);
                    if (labelAndStarsEntry.getStars().getNumberOfLit() > rewardData.getNumberOfStars(string) && !RewardDisplayer.this.collectedIsPlaying) {
                        RewardDisplayer.this.collectedSFX.play();
                        RewardDisplayer.this.collectedIsPlaying = true;
                        RewardDisplayer.this.taskManager.add(new Runnable(){

                            public void run() {
                                RewardDisplayer.this.collectedIsPlaying = false;
                            }
                        }, 0.2f);
                    }
                }
            }, 1.0f);
        }
    }

    public void registerForEvents(EventManager eventManager) {
        eventManager.registerListener(EVENT_SHOWREWARD, this);
        eventManager.registerListener(EVENT_UNDOREWARD, this);
        eventManager.registerListener(EVENT_COLLECTREWARD, this);
    }

    public Node getNode() {
        return this.node;
    }

    public void reset() {
        this.labelList.clear();
        this.taskManager.clearSchedule();
        this.showIsPlaying = false;
        this.showNewIsPlaying = false;
        this.lostIsPlaying = false;
        this.collectedIsPlaying = false;
    }

    public void update(float f) {
        super.update(f);
        if (this.taskManager != null) {
            this.taskManager.update(f);
        }
    }

    private class LabelRemover
    implements IControllerListener {
        Node node;

        public LabelRemover(Node node) {
            this.node = node;
        }

        public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
            this.node.detachChild(abstractSpatialController.getSpatial());
        }
    }
}

