/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.replay;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.replay.ReplayParticipant;
import com.turborilla.msm.states.game.BikeResult;
import com.turborilla.msm.track.Track1D;
import com.turborilla.replay.nioreplay.NioReplay;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class ReplayMetaData
implements Savable {
    private static final Logger logger = Logger.getLogger(ReplayMetaData.class.getCanonicalName());
    private Track1D track;
    private Properties raceProperties;
    private ArrayList<ReplayParticipant> participants;
    private String trackHash;
    private int version = 1;

    public ReplayMetaData(Track1D track1D, Properties properties) {
        this.track = track1D;
        this.raceProperties = properties;
        if (track1D != null) {
            this.trackHash = track1D.getHash();
        }
    }

    public ReplayMetaData() {
    }

    public void addParticipant(String string, BikeResult bikeResult, NioReplay nioReplay) {
        if (this.participants == null) {
            this.participants = new ArrayList();
        }
        this.participants.add(new ReplayParticipant(string, bikeResult, nioReplay));
    }

    public ReplayParticipant[] getParticipants() {
        if (this.participants == null) {
            return new ReplayParticipant[0];
        }
        return this.participants.toArray(new ReplayParticipant[0]);
    }

    public Track1D getTrack() {
        String string = this.getTrackName();
        if (string != null) {
            try {
                this.track = (Track1D)ResourceManager.getInstance().load("track", string, null);
            }
            catch (IOException iOException) {
                logger.severe("Could not load track \"" + string + "\" due to " + iOException);
                return null;
            }
            if (this.trackHash != null && !this.trackHash.equals(this.track.getHash())) {
                logger.severe("Track hash is not the same, track name: " + string);
            }
        }
        return this.track;
    }

    public String getTrackName() {
        String string = null;
        if (this.raceProperties != null) {
            string = this.raceProperties.getProperty("track", null);
        }
        return string;
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 1);
        if (n != this.version) {
            Logger.getLogger(this.getClassTag().getName()).warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
        }
        this.read(n, inputCapsule);
    }

    protected void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                this.participants = inputCapsule.readSavableArrayList("participants", null);
                String[][] stringArray = inputCapsule.readStringArray2D("propertyArray", null);
                if (stringArray != null) {
                    this.raceProperties = new Properties();
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.raceProperties.setProperty(stringArray[i][0], stringArray[i][1]);
                    }
                }
                this.trackHash = inputCapsule.readString("trackHash", null);
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.version, "version", 1);
        outputCapsule.writeSavableArrayList(this.participants, "participants", null);
        String[][] stringArray = null;
        if (this.raceProperties != null) {
            Set<Object> set = this.raceProperties.keySet();
            stringArray = new String[set.size()][2];
            Iterator<Object> iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof String)) continue;
                stringArray[n][0] = (String)object;
                stringArray[n][1] = this.raceProperties.getProperty((String)object);
                ++n;
            }
        }
        outputCapsule.write(stringArray, "propertyArray", (String[][])null);
        outputCapsule.write(this.trackHash, "trackHash", null);
    }

    public void setTrack(Track1D track1D) {
        this.track = track1D;
        if (track1D != null) {
            this.trackHash = track1D.getHash();
        }
    }

    public Properties getRaceProperties() {
        return this.raceProperties;
    }

    public void setRaceProperties(Properties properties) {
        this.raceProperties = properties;
    }

    public String getTrackHash() {
        return this.trackHash;
    }
}

