/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.replay;

import com.turborilla.physics.particle.Particle;
import com.turborilla.physics.particle.ParticleObject;
import com.turborilla.replay.nioreplay.BaseReplayData;
import com.turborilla.utils.math.Vector3d;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public class ReplayDataParticleObject
extends BaseReplayData {
    private static final Logger logger = Logger.getLogger(ReplayDataParticleObject.class.getName());
    private ParticleObject particleObject;
    private Particle[] particles;
    protected int baseSize = 8;
    protected int elementSize = 2;
    private double objectSize = 10.0;
    protected double zPos = 0.0;

    public ReplayDataParticleObject() {
    }

    public ReplayDataParticleObject(ParticleObject particleObject) {
        this.setParticleObject(particleObject);
    }

    public void setParticleObject(ParticleObject particleObject) {
        this.particleObject = particleObject;
        this.initForParticleObject();
    }

    private void initForParticleObject() {
        ArrayList<Particle> arrayList = this.particleObject.getParticles();
        this.particles = new Particle[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        for (int i = 0; iterator.hasNext() && i < this.particles.length; ++i) {
            Particle particle;
            this.particles[i] = particle = (Particle)iterator.next();
        }
        this.setSize(this.baseSize + this.particles.length * this.elementSize);
        double d = 0.0;
        Vector3d vector3d = new Vector3d();
        for (Particle particle : this.particles) {
            for (Particle particle2 : this.particles) {
                particle.position.subtract(particle2.position, vector3d);
                double d2 = vector3d.length();
                if (!(d2 > d)) continue;
                d = d2;
            }
        }
        this.objectSize = d * 1.8;
    }

    public ByteBuffer getCurrentState() {
        if (!this.isLocked()) {
            logger.warning("Cannot get current state for replay when not locked for recording");
            return null;
        }
        this.tempBuffer.clear();
        double d = 0.0;
        double d2 = 0.0;
        if (this.particles.length > 0) {
            d = this.particles[0].position.x;
            d2 = this.particles[0].position.y;
        }
        this.tempBuffer.putFloat((float)d);
        this.tempBuffer.putFloat((float)d2);
        for (int i = 0; i < this.particles.length; ++i) {
            Particle particle = this.particles[i];
            double d3 = particle.position.x - d;
            double d4 = particle.position.y - d2;
            if (d3 > 0.0 && d3 > this.objectSize) {
                d3 = this.objectSize;
            }
            if (d4 > 0.0 && d4 > this.objectSize) {
                d4 = this.objectSize;
            }
            if (d3 < 0.0 && d3 < -this.objectSize) {
                d3 = -this.objectSize;
            }
            if (d4 < 0.0 && d4 < -this.objectSize) {
                d4 = -this.objectSize;
            }
            byte by = (byte)(d3 / this.objectSize * 127.0);
            byte by2 = (byte)(d4 / this.objectSize * 127.0);
            this.tempBuffer.put(by);
            this.tempBuffer.put(by2);
        }
        this.tempBuffer.flip();
        return this.tempBuffer;
    }

    public void setCurrentState(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = byteBuffer.getFloat();
        double d5 = byteBuffer2.getFloat();
        d2 = d4 + (d5 - d4) * d;
        d4 = byteBuffer.getFloat();
        d5 = byteBuffer2.getFloat();
        d3 = d4 + (d5 - d4) * d;
        for (int i = 0; i < this.particles.length; ++i) {
            Vector3d vector3d = this.particles[i].position;
            this.particles[i].oldPosition.x = vector3d.x;
            this.particles[i].oldPosition.y = vector3d.y;
            byte by = byteBuffer.get();
            byte by2 = byteBuffer2.get();
            double d6 = (double)by / 127.0 * this.objectSize;
            double d7 = (double)by2 / 127.0 * this.objectSize;
            vector3d.x = d6 + (d7 - d6) * d + d2;
            by = byteBuffer.get();
            by2 = byteBuffer2.get();
            d6 = (double)by / 127.0 * this.objectSize;
            d7 = (double)by2 / 127.0 * this.objectSize;
            vector3d.y = d6 + (d7 - d6) * d + d3;
            vector3d.z = this.zPos;
        }
    }

    public double getZPos() {
        return this.zPos;
    }

    public void setZPos(double d) {
        this.zPos = d;
    }
}

