/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.replay;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.turborilla.msm.physics.collision.ParticleObjectEffectCollisionSpray;
import com.turborilla.replay.nioreplay.BaseReplayData;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ReplayDataCollisionSpray
extends BaseReplayData {
    private static final Logger logger = Logger.getLogger(ReplayDataCollisionSpray.class.getName());
    private ArrayList<ParticleObjectEffectCollisionSpray> sprays = new ArrayList();
    private int elementSize = 20;
    private double defaultZ;
    private int version = 1;

    public ReplayDataCollisionSpray() {
    }

    public ReplayDataCollisionSpray(double d) {
        this();
        this.defaultZ = d;
    }

    public void addCollisionSpray(ParticleObjectEffectCollisionSpray particleObjectEffectCollisionSpray) {
        if (this.isLocked()) {
            logger.warning("Cannot add another collision spray while ReplayData is locked");
            return;
        }
        this.sprays.add(particleObjectEffectCollisionSpray);
        this.setSize(this.getSize() + 1 + this.elementSize * particleObjectEffectCollisionSpray.getMaxSavedCollisions());
    }

    public ByteBuffer getCurrentState() {
        if (!this.isLocked()) {
            logger.warning("Cannot get current state for replay when not locked for recording");
            return null;
        }
        this.tempBuffer.clear();
        for (int i = 0; i < this.sprays.size(); ++i) {
            ParticleObjectEffectCollisionSpray particleObjectEffectCollisionSpray = this.sprays.get(i);
            this.tempBuffer.put((byte)particleObjectEffectCollisionSpray.getSavedThisFrame());
            ParticleObjectEffectCollisionSpray.Collision[] collisionArray = particleObjectEffectCollisionSpray.getSavedCollisions();
            for (int j = 0; j < particleObjectEffectCollisionSpray.getMaxSavedCollisions(); ++j) {
                ParticleObjectEffectCollisionSpray.Collision collision = collisionArray[j];
                this.tempBuffer.putFloat((float)collision.base.x);
                this.tempBuffer.putFloat((float)collision.base.y);
                this.tempBuffer.putFloat((float)collision.towards.x);
                this.tempBuffer.putFloat((float)collision.towards.y);
                this.tempBuffer.putFloat((float)collision.speed);
            }
        }
        this.tempBuffer.flip();
        return this.tempBuffer;
    }

    public void setCurrentState(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, double d) {
        for (int i = 0; i < this.sprays.size(); ++i) {
            ParticleObjectEffectCollisionSpray particleObjectEffectCollisionSpray = this.sprays.get(i);
            double d2 = byteBuffer.get();
            double d3 = byteBuffer2.get();
            particleObjectEffectCollisionSpray.setSavedThisFrame((int)(d2 + (d3 - d2) * d));
            ParticleObjectEffectCollisionSpray.Collision[] collisionArray = particleObjectEffectCollisionSpray.getSavedCollisions();
            for (int j = 0; j < particleObjectEffectCollisionSpray.getMaxSavedCollisions(); ++j) {
                ParticleObjectEffectCollisionSpray.Collision collision = collisionArray[j];
                d2 = byteBuffer.getFloat();
                d3 = byteBuffer2.getFloat();
                collision.base.x = d2 + (d3 - d2) * d;
                d2 = byteBuffer.getFloat();
                d3 = byteBuffer2.getFloat();
                collision.base.y = d2 + (d3 - d2) * d;
                collision.base.z = this.defaultZ;
                d2 = byteBuffer.getFloat();
                d3 = byteBuffer2.getFloat();
                collision.towards.x = d2 + (d3 - d2) * d;
                d2 = byteBuffer.getFloat();
                d3 = byteBuffer2.getFloat();
                collision.towards.y = d2 + (d3 - d2) * d;
                collision.towards.z = this.defaultZ;
                d2 = byteBuffer.getFloat();
                d3 = byteBuffer2.getFloat();
                collision.speed = d2 + (d3 - d2) * d;
            }
        }
    }

    public Class getClassTag() {
        return this.getClass();
    }

    protected void read(int n, InputCapsule inputCapsule) throws IOException {
        super.read(n, inputCapsule);
        switch (n) {
            case 1: {
                this.setSize(0);
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
    }
}

