/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.profile;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.export.binary.BinaryImporter;
import com.turborilla.msm.replay.ReplayMetaData;
import com.turborilla.msm.utils.TimeFunctions;
import com.turborilla.utils.folders.SystemFolder;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.logging.Logger;

public class RaceData
implements Savable {
    private int divisionIndex;
    private int trackIndex;
    private float passedStartlineAtTime;
    private float passedFinishlineAtTime;
    private boolean finishedRace;
    private int finishingPlace;
    private int numberOfCrashes;
    private String replayFilename;
    private Date timeOfRace;
    private WeakReference<ReplayMetaData> replayData;
    private int version = 1;
    private static final Logger logger = Logger.getLogger(RaceData.class.getCanonicalName());

    public ReplayMetaData loadReplay() throws IOException {
        if (this.replayFilename == null) {
            return null;
        }
        File file = new File(SystemFolder.getReplayFolder(null));
        File file2 = new File(file, this.replayFilename + ".msmreplay");
        ReplayMetaData replayMetaData = (ReplayMetaData)BinaryImporter.getInstance().load(file2);
        return replayMetaData;
    }

    public void saveReplay(ReplayMetaData replayMetaData) throws IOException {
        this.saveReplay(replayMetaData, false);
    }

    public void saveReplay(ReplayMetaData replayMetaData, boolean bl) throws IOException {
        String string;
        this.replayData = new WeakReference<ReplayMetaData>(replayMetaData);
        if (!bl) {
            return;
        }
        File file = new File(SystemFolder.getReplayFolder(null));
        File file2 = null;
        if (this.timeOfRace == null) {
            this.timeOfRace = new Date();
        }
        if ((file2 = new File(file, (string = this.timeOfRace.toString().replace(':', '-').replace(' ', '-')) + ".msmreplay")).exists()) {
            file2.delete();
        }
        BinaryExporter binaryExporter = BinaryExporter.getInstance();
        binaryExporter.save((Savable)replayMetaData, file2);
        this.replayFilename = string;
    }

    public float getPassedStartlineAtTime() {
        return this.passedStartlineAtTime;
    }

    public void setPassedStartlineAtTime(float f) {
        this.passedStartlineAtTime = f;
    }

    public float getPassedFinishlineAtTime() {
        return this.passedFinishlineAtTime;
    }

    public void setPassedFinishlineAtTime(float f) {
        this.passedFinishlineAtTime = f;
    }

    public boolean isFinishedRace() {
        return this.finishedRace;
    }

    public void setFinishedRace(boolean bl) {
        this.finishedRace = bl;
    }

    public int getFinishingPlace() {
        return this.finishingPlace;
    }

    public void setFinishingPlace(int n) {
        this.finishingPlace = n;
    }

    public int getNumberOfCrashes() {
        return this.numberOfCrashes;
    }

    public void setNumberOfCrashes(int n) {
        this.numberOfCrashes = n;
    }

    public int getDivisionIndex() {
        return this.divisionIndex;
    }

    public void setDivisionIndex(int n) {
        this.divisionIndex = n;
    }

    public int getTrackIndex() {
        return this.trackIndex;
    }

    public void setTrackIndex(int n) {
        this.trackIndex = n;
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 0);
        if (n != this.version) {
            logger.warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
        }
        this.read(n, inputCapsule);
    }

    private void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                this.divisionIndex = inputCapsule.readInt("divisionIndex", 0);
                this.trackIndex = inputCapsule.readInt("trackIndex", 0);
                this.passedStartlineAtTime = inputCapsule.readFloat("passedStartlineAtTime", 0.0f);
                this.passedFinishlineAtTime = inputCapsule.readFloat("passedFinishlineAtTime", 0.0f);
                this.finishedRace = inputCapsule.readBoolean("finishedRace", false);
                this.finishingPlace = inputCapsule.readInt("finishingPlace", 0);
                this.numberOfCrashes = inputCapsule.readInt("numberOfCrashes", 0);
                this.replayFilename = inputCapsule.readString("replayFilename", null);
                long l = inputCapsule.readLong("timeOfRace", 0L);
                if (l > 0L) {
                    this.timeOfRace = new Date(l);
                    break;
                }
                this.timeOfRace = null;
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        Object object;
        if (this.replayData != null && (object = (ReplayMetaData)this.replayData.get()) != null) {
            this.saveReplay((ReplayMetaData)object, true);
        }
        object = jMEExporter.getCapsule(this);
        object.write(this.version, "version", 0);
        object.write(this.divisionIndex, "divisionIndex", 0);
        object.write(this.trackIndex, "trackIndex", 0);
        object.write(this.passedStartlineAtTime, "passedStartlineAtTime", 0.0f);
        object.write(this.passedFinishlineAtTime, "passedFinishlineAtTime", 0.0f);
        object.write(this.finishedRace, "finishedRace", false);
        object.write(this.finishingPlace, "finishingPlace", Integer.MAX_VALUE);
        object.write(this.numberOfCrashes, "numberOfCrashes", 0);
        object.write(this.replayFilename, "replayFilename", null);
        if (this.timeOfRace == null) {
            this.timeOfRace = new Date();
        }
        object.write(this.timeOfRace.getTime(), "timeOfRace", 0L);
    }

    public String toString() {
        String string = "Racetime: " + TimeFunctions.getSecHundreths(this.passedFinishlineAtTime) + " Crashes: " + this.numberOfCrashes + " When: " + this.timeOfRace;
        return string;
    }

    public void setTimeOfRace(Date date) {
        this.timeOfRace = date;
    }

    public Date getTimeOfRace() {
        return this.timeOfRace;
    }
}

