/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.profile;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.turborilla.msm.division.DivisionDescriptor;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.MsmProfileException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class ProgressData
implements Serializable,
Savable {
    private static final long serialVersionUID = 9206193439259319063L;
    private ArrayList<Division> divisions;
    public static boolean cheatAllUnlocked = false;
    private Difficulty difficulty = Difficulty.Arcade;
    private boolean finishedGame = false;
    private static final Logger logger = Logger.getLogger(ProgressData.class.getCanonicalName());
    private int version = 1;

    public boolean isFinishedGame() {
        return this.finishedGame;
    }

    public void setFinishedGame(boolean bl) {
        this.finishedGame = bl;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public Division getCurrentDivision() {
        Object[] objectArray;
        if (this.divisions == null || this.divisions.size() == 0) {
            objectArray = this.getDivisionDescriptor();
            this.divisions = new ArrayList();
            for (int i = 0; i < objectArray.getNumberOfDivisions(); ++i) {
                Division division = new Division(i);
                for (int j = 0; j < objectArray.getNumberOfTracks(i); ++j) {
                    Division.Track track = new Division.Track(j);
                    division.add(track);
                }
                this.divisions.add(division);
            }
        }
        objectArray = this.divisions.toArray(new Division[0]);
        Arrays.sort(objectArray);
        Object object = objectArray[0];
        if (!((Division)objectArray[0]).isUnlocked()) {
            ((Division)objectArray[0]).setUnlocked(true);
        }
        for (int i = objectArray.length - 1; i >= 0; --i) {
            object = objectArray[i];
            if (!((Division)object).isUnlocked() && i != 0) continue;
            if (((Division)object).isUnlocked()) break;
            ((Division)object).setUnlocked(true);
            break;
        }
        return object;
    }

    DivisionDescriptor getDivisionDescriptor() {
        DivisionDescriptor divisionDescriptor = null;
        String string = null;
        string = this.difficulty == Difficulty.Arcade ? "arcade_divisions" : "simulation_divisions";
        try {
            divisionDescriptor = (DivisionDescriptor)ResourceManager.getInstance().load("divisiondescriptor", string, null);
        }
        catch (IOException iOException) {
            throw new MsmProfileException(iOException);
        }
        if (divisionDescriptor.getNumberOfDivisions() <= 0) {
            throw new MsmProfileException("Bad DivisionDescriptor: divisions.size = " + divisionDescriptor.getNumberOfDivisions());
        }
        return divisionDescriptor;
    }

    public Division[] getDivisions() {
        if (this.divisions == null) {
            this.getCurrentDivision();
        }
        Object[] objectArray = this.divisions.toArray(new Division[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public String toString() {
        String string = "Currentdivision: " + this.getCurrentDivision() + "\n";
        if (this.getCurrentDivision() != null) {
            string = string + "Currenttrack: " + this.getCurrentDivision().getCurrentTrack() + "\n";
        }
        string = string + "Divisions and tracks: \n" + this.divisions;
        return string;
    }

    public void reset() {
        this.divisions = null;
        this.getCurrentDivision();
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 0);
        if (n != this.version) {
            logger.warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
        }
        this.read(n, inputCapsule);
    }

    private void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                this.divisions = inputCapsule.readSavableArrayList("divisions", null);
                this.finishedGame = inputCapsule.readBoolean("finishedGame", false);
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.version, "version", 0);
        if (this.divisions != null) {
            outputCapsule.writeSavableArrayList(this.divisions, "divisions", null);
        }
        outputCapsule.write(this.finishedGame, "finishedGame", false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Division
    implements Serializable,
    Comparable<Division>,
    Savable {
        private static final long serialVersionUID = 711057013720058242L;
        private int index;
        private boolean unlocked = false;
        private boolean accomplished = false;
        private ArrayList<Track> tracks;
        private int version = 1;

        public Division() {
        }

        public Division(int n) {
            this.tracks = new ArrayList();
            this.index = n;
        }

        public Track getCurrentTrack() {
            int n;
            Track[] trackArray = this.getTracks();
            Track track = trackArray[0];
            if (this.isUnlocked() && !trackArray[0].isUnlocked()) {
                trackArray[0].setUnlocked(true);
            }
            boolean bl = true;
            for (n = 0; n < trackArray.length; ++n) {
                if (!trackArray[n].isUnlocked() || trackArray[n].isAccomplished()) continue;
                track = trackArray[n];
                bl = false;
                break;
            }
            if (bl) {
                for (n = trackArray.length - 1; n >= 1; --n) {
                    if (!trackArray[n - 1].isAccomplished()) continue;
                    track = trackArray[n];
                    track.setUnlocked(true);
                    bl = false;
                    break;
                }
            }
            if (bl) {
                track = trackArray[0];
                track.setUnlocked(true);
                bl = false;
            }
            return track;
        }

        public Track[] getTracks() {
            Object[] objectArray = this.tracks.toArray(new Track[0]);
            Arrays.sort(objectArray);
            return objectArray;
        }

        public String toString() {
            String string = "----------------------\n";
            string = string + "Division index: " + this.getIndex() + "\n";
            string = string + "unlocked: " + this.isUnlocked() + "\n";
            string = string + "accomplished: " + this.isAccomplished() + "\n";
            string = string + "tracks:\n" + this.tracks;
            return string;
        }

        public boolean isUnlocked() {
            return this.unlocked || cheatAllUnlocked;
        }

        public void setUnlocked(boolean bl) {
            this.unlocked = bl;
        }

        public boolean isAccomplished() {
            return this.accomplished;
        }

        public void setAccomplished(boolean bl) {
            this.accomplished = bl;
        }

        public boolean add(Track track) {
            return this.tracks.add(track);
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int n) {
            this.index = n;
        }

        @Override
        public int compareTo(Division division) {
            if (this.index < division.index) {
                return -1;
            }
            if (this.index > division.index) {
                return 1;
            }
            return 0;
        }

        @Override
        public Class getClassTag() {
            return this.getClass();
        }

        @Override
        public void read(JMEImporter jMEImporter) throws IOException {
            InputCapsule inputCapsule = jMEImporter.getCapsule(this);
            int n = inputCapsule.readInt("version", 0);
            if (n != this.version) {
                logger.warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
            }
            this.read(n, inputCapsule);
        }

        private void read(int n, InputCapsule inputCapsule) throws IOException {
            switch (n) {
                case 1: {
                    this.index = inputCapsule.readInt("index", 0);
                    this.unlocked = inputCapsule.readBoolean("unlocked", false);
                    this.accomplished = inputCapsule.readBoolean("accomplished", false);
                    this.tracks = inputCapsule.readSavableArrayList("tracks", null);
                    break;
                }
                default: {
                    throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
                }
            }
        }

        @Override
        public void write(JMEExporter jMEExporter) throws IOException {
            OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
            outputCapsule.write(this.version, "version", 0);
            outputCapsule.write(this.index, "index", 0);
            outputCapsule.write(this.unlocked, "unlocked", false);
            outputCapsule.write(this.accomplished, "accomplished", false);
            if (this.tracks != null) {
                outputCapsule.writeSavableArrayList(this.tracks, "tracks", null);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Track
        implements Serializable,
        Comparable<Track>,
        Savable {
            private static final long serialVersionUID = -73221454469891319L;
            private int index;
            private boolean unlocked = false;
            private boolean accomplished = false;
            private int numberOfRaces = 0;
            private int numberOfRacesBeforeAccomplished = 0;
            private int version = 1;

            public Track() {
            }

            public Track(int n) {
                this.index = n;
            }

            public void increaseNumberOfRaces() {
                ++this.numberOfRaces;
                if (!this.accomplished) {
                    ++this.numberOfRacesBeforeAccomplished;
                }
            }

            public int getNumberOfRaces() {
                return this.numberOfRaces;
            }

            public String toString() {
                String string = "----------------------\n";
                string = string + "Track index: " + this.getIndex() + "\n";
                string = string + "unlocked: " + this.isUnlocked() + "\n";
                string = string + "accomplished: " + this.isAccomplished() + "\n";
                return string;
            }

            public boolean isUnlocked() {
                return this.unlocked || cheatAllUnlocked;
            }

            public void setUnlocked(boolean bl) {
                this.unlocked = bl;
            }

            public boolean isAccomplished() {
                return this.accomplished;
            }

            public void setAccomplished(boolean bl) {
                this.accomplished = bl;
            }

            public int getIndex() {
                return this.index;
            }

            public void setIndex(int n) {
                this.index = n;
            }

            @Override
            public int compareTo(Track track) {
                if (this.index < track.index) {
                    return -1;
                }
                if (this.index > track.index) {
                    return 1;
                }
                return 0;
            }

            @Override
            public Class getClassTag() {
                return this.getClass();
            }

            @Override
            public void read(JMEImporter jMEImporter) throws IOException {
                InputCapsule inputCapsule = jMEImporter.getCapsule(this);
                int n = inputCapsule.readInt("version", 0);
                if (n != this.version) {
                    logger.warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
                }
                this.read(n, inputCapsule);
            }

            private void read(int n, InputCapsule inputCapsule) throws IOException {
                switch (n) {
                    case 1: {
                        this.index = inputCapsule.readInt("index", 0);
                        this.unlocked = inputCapsule.readBoolean("unlocked", false);
                        this.accomplished = inputCapsule.readBoolean("accomplished", false);
                        this.numberOfRaces = inputCapsule.readInt("numberOfRaces", 0);
                        this.numberOfRacesBeforeAccomplished = inputCapsule.readInt("numberOfRacesBeforeAccomplished", 0);
                        break;
                    }
                    default: {
                        throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
                    }
                }
            }

            @Override
            public void write(JMEExporter jMEExporter) throws IOException {
                OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
                outputCapsule.write(this.version, "version", 0);
                outputCapsule.write(this.index, "index", 0);
                outputCapsule.write(this.unlocked, "unlocked", false);
                outputCapsule.write(this.accomplished, "accomplished", false);
                outputCapsule.write(this.numberOfRaces, "numberOfRaces", 0);
                outputCapsule.write(this.numberOfRacesBeforeAccomplished, "numberOfRacesBeforeAccomplished", 0);
            }
        }
    }
}

