/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.profile;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.turborilla.msm.division.DivisionDescriptor;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.InputData;
import com.turborilla.msm.profile.ProgressData;
import com.turborilla.msm.profile.RaceData;
import com.turborilla.msm.profile.RewardData;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileData
implements Serializable,
Savable {
    private static final long serialVersionUID = 6191752917151037170L;
    private ProgressData progressData;
    private RewardData rewardData;
    private InputData inputData;
    private ArrayList<RaceData> races;
    private Difficulty difficulty;
    private HashMap<Integer, ArrayList<RaceData>> raceDataMap = new HashMap();
    private HashMap<Integer, RaceData> bestRaceMap = new HashMap();
    private static final Logger logger = Logger.getLogger(ProgressData.class.getCanonicalName());
    private int version = 2;

    public ProfileData() {
        this.races = new ArrayList();
    }

    public void addRaceData(RaceData raceData) {
        this.races.add(raceData);
        this.putInOptimizeMap(raceData);
    }

    public RaceData[] getRaces() {
        return this.races.toArray(new RaceData[0]);
    }

    public RaceData[] getRaces(int n, int n2) {
        ArrayList<RaceData> arrayList = this.getFromOptimizeMap(n, n2);
        if (arrayList.size() <= 0) {
            return null;
        }
        RaceData[] raceDataArray = arrayList.toArray(new RaceData[0]);
        Arrays.sort(raceDataArray, new Comparator<RaceData>(){

            @Override
            public int compare(RaceData raceData, RaceData raceData2) {
                if (raceData.getPassedFinishlineAtTime() < raceData2.getPassedFinishlineAtTime()) {
                    return -1;
                }
                if (raceData.getPassedFinishlineAtTime() > raceData2.getPassedFinishlineAtTime()) {
                    return 1;
                }
                return 0;
            }
        });
        return raceDataArray;
    }

    public RaceData getBestRace(int n, int n2) {
        Integer n3 = n * 100 + n2;
        return this.bestRaceMap.get(n3);
    }

    private void optimizeGetRaces() {
        this.raceDataMap.clear();
        for (int i = 0; i < this.races.size(); ++i) {
            RaceData raceData = this.races.get(i);
            this.putInOptimizeMap(raceData);
        }
    }

    private void putInOptimizeMap(RaceData raceData) {
        if (!raceData.isFinishedRace()) {
            return;
        }
        Integer n = raceData.getDivisionIndex() * 100 + raceData.getTrackIndex();
        ArrayList<RaceData> arrayList = this.raceDataMap.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.raceDataMap.put(n, arrayList);
        }
        arrayList.add(raceData);
        RaceData raceData2 = this.bestRaceMap.get(n);
        if (raceData2 == null || raceData2.getPassedFinishlineAtTime() > raceData.getPassedFinishlineAtTime()) {
            this.bestRaceMap.put(n, raceData);
        }
    }

    private ArrayList<RaceData> getFromOptimizeMap(int n, int n2) {
        Integer n3 = n * 100 + n2;
        ArrayList<RaceData> arrayList = this.raceDataMap.get(n3);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.raceDataMap.put(n3, arrayList);
        }
        return arrayList;
    }

    public String toString() {
        return "Progress:\n" + this.getProgressData();
    }

    public void reset() {
        this.getProgressData().reset();
        this.getRewardData().reset();
        this.races = new ArrayList();
        this.optimizeGetRaces();
    }

    public RewardData getRewardData() {
        if (this.rewardData == null) {
            this.rewardData = new RewardData();
        }
        return this.rewardData;
    }

    public ProgressData getProgressData() {
        if (this.progressData == null) {
            this.progressData = new ProgressData();
        }
        this.progressData.setDifficulty(this.difficulty);
        return this.progressData;
    }

    @Override
    public Class getClassTag() {
        return this.getClass();
    }

    @Override
    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 0);
        if (n != this.version) {
            logger.warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
        }
        this.read(n, inputCapsule);
    }

    private void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                this.progressData = (ProgressData)inputCapsule.readSavable("progressData", null);
                this.rewardData = (RewardData)inputCapsule.readSavable("rewardData", null);
                this.difficulty = Difficulty.valueOf(inputCapsule.readString("difficulty", Difficulty.Arcade.name()));
                this.races = inputCapsule.readSavableArrayList("races", null);
                break;
            }
            case 2: {
                this.read(1, inputCapsule);
                this.inputData = (InputData)inputCapsule.readSavable("inputData", null);
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
        this.optimizeGetRaces();
    }

    @Override
    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.version, "version", 0);
        outputCapsule.write(this.progressData, "progressData", null);
        outputCapsule.write(this.rewardData, "rewardData", null);
        outputCapsule.write(this.difficulty.name(), "difficulty", Difficulty.Arcade.name());
        if (this.races != null) {
            outputCapsule.writeSavableArrayList(this.races, "races", null);
        }
        outputCapsule.write(this.inputData, "inputData", null);
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public InputData getInputData() {
        if (this.inputData == null) {
            this.inputData = new InputData();
            if (this.difficulty == Difficulty.Simulation) {
                this.inputData.setDevice(InputData.Device.Mouse);
            } else {
                this.inputData.setDevice(InputData.Device.Keyboard);
            }
        }
        return this.inputData;
    }

    public void setInputData(InputData inputData) {
        this.inputData = inputData;
    }

    public float getPercentageDone() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        DivisionDescriptor divisionDescriptor = this.getProgressData().getDivisionDescriptor();
        ProgressData.Division[] divisionArray = this.getProgressData().getDivisions();
        int n5 = divisionDescriptor.getNumberOfDivisions();
        for (int i = 0; i < n5; ++i) {
            n2 = divisionDescriptor.getNumberOfTracks(i);
            n3 += n2;
            if (i >= divisionArray.length) continue;
            ProgressData.Division.Track[] trackArray = divisionArray[i].getTracks();
            for (n = 0; n < n2; ++n) {
                if (n >= trackArray.length || !trackArray[n].isAccomplished()) continue;
                ++n4;
            }
        }
        String[] stringArray = this.getRewardData().getAvailableRewardsIdentifiers();
        n2 = stringArray.length * 5;
        int n6 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            n6 += this.getRewardData().getNumberOfStars(stringArray[n]);
        }
        n = this.rewardData.getMostStarsInOneRace();
        int n7 = stringArray.length;
        int n8 = (int)Math.floor((float)n / 5.0f);
        return ((float)n6 + (float)n4 + (float)n8) / ((float)n2 + (float)n3 + (float)n7);
    }
}

