/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.profile;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.util.logging.Logger;
import org.lwjgl.input.Keyboard;

public class MouseData
implements Savable,
Cloneable {
    private static final Logger logger = Logger.getLogger(MouseData.class.getCanonicalName());
    private int throttleMouse = 0;
    private int brakeMouse = 1;
    private int specialMouse = 2;
    private int throttleKey = 29;
    private int brakeKey = 56;
    private int specialKey = 57;
    private float sensitivity = 0.5f;
    private boolean configured = false;
    private int version = 1;

    protected Object clone() throws CloneNotSupportedException {
        MouseData mouseData = (MouseData)super.clone();
        mouseData.setBrakeKey(this.brakeKey);
        mouseData.setThrottleKey(this.throttleKey);
        mouseData.setSpecialKey(this.specialKey);
        mouseData.setBrakeMouse(this.brakeMouse);
        mouseData.setThrottleMouse(this.throttleMouse);
        mouseData.setSpecialMouse(this.specialMouse);
        mouseData.setSensitivity(this.sensitivity);
        return mouseData;
    }

    public String toString() {
        String string = "";
        string = string + ":" + Keyboard.getKeyName(this.throttleKey);
        string = string + ":" + Keyboard.getKeyName(this.brakeKey);
        string = string + ":" + Keyboard.getKeyName(this.specialKey);
        string = string + ":" + this.throttleMouse;
        string = string + ":" + this.brakeMouse;
        string = string + ":" + this.specialMouse;
        string = string + ":" + this.sensitivity;
        return string;
    }

    public int getThrottleKey() {
        return this.throttleKey;
    }

    public int getBrakeKey() {
        return this.brakeKey;
    }

    public int getSpecialKey() {
        return this.specialKey;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public void setConfigured(boolean bl) {
        this.configured = bl;
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 0);
        if (n != this.version) {
            logger.warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
        }
        this.read(n, inputCapsule);
    }

    private void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                this.throttleKey = inputCapsule.readInt("throttleKey", 29);
                this.brakeKey = inputCapsule.readInt("brakeKey", 56);
                this.specialKey = inputCapsule.readInt("specialKey", 57);
                this.throttleMouse = inputCapsule.readInt("throttleMouse", 0);
                this.brakeMouse = inputCapsule.readInt("brakeMouse", 1);
                this.specialMouse = inputCapsule.readInt("specialMouse", 2);
                this.sensitivity = inputCapsule.readFloat("sensitivity", 0.5f);
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.version, "version", 0);
        outputCapsule.write(this.throttleKey, "throttleKey", 29);
        outputCapsule.write(this.brakeKey, "brakeKey", 56);
        outputCapsule.write(this.specialKey, "specialKey", 57);
        outputCapsule.write(this.throttleMouse, "throttleMouse", 0);
        outputCapsule.write(this.brakeMouse, "brakeMouse", 1);
        outputCapsule.write(this.specialMouse, "specialMouse", 2);
        outputCapsule.write(this.sensitivity, "sensitivity", 0.5f);
    }

    public float getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(float f) {
        this.sensitivity = f;
    }

    public int getThrottleMouse() {
        return this.throttleMouse;
    }

    public void setThrottleMouse(int n) {
        this.throttleMouse = n;
        if (n < 0) {
            this.throttleMouse = this.getFirstFreeMouse(0);
        }
    }

    public int getBrakeMouse() {
        return this.brakeMouse;
    }

    public void setBrakeMouse(int n) {
        this.brakeMouse = n;
        if (n < 0) {
            this.brakeMouse = this.getFirstFreeMouse(0);
        }
    }

    public int getSpecialMouse() {
        return this.specialMouse;
    }

    public void setSpecialMouse(int n) {
        this.specialMouse = n;
        if (n < 0) {
            this.specialMouse = this.getFirstFreeMouse(0);
        }
    }

    public void setThrottleKey(int n) {
        this.throttleKey = n;
        if (n < 0) {
            this.throttleKey = this.getFirstFreeKey(29);
        }
    }

    public void setBrakeKey(int n) {
        this.brakeKey = n;
        if (n < 0) {
            this.brakeKey = this.getFirstFreeKey(56);
        }
    }

    public void setSpecialKey(int n) {
        this.specialKey = n;
        if (n < 0) {
            this.specialKey = this.getFirstFreeKey(57);
        }
    }

    private int getFirstFreeKey(int n) {
        int n2 = n;
        if (n2 == this.throttleKey || n2 == this.brakeKey || n2 == this.specialKey) {
            n2 = this.getFirstFreeKey(n + 1);
        }
        return n2;
    }

    private int getFirstFreeMouse(int n) {
        int n2 = n;
        if (n2 == this.throttleMouse || n2 == this.brakeMouse || n2 == this.specialMouse) {
            n2 = this.getFirstFreeMouse(n + 1);
        }
        return n2;
    }
}

