/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.profile;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.util.logging.Logger;
import org.lwjgl.input.Keyboard;

public class KeyboardData
implements Savable,
Cloneable {
    private static final Logger logger = Logger.getLogger(KeyboardData.class.getCanonicalName());
    private int throttle = 200;
    private int brake = 208;
    private int left = 203;
    private int right = 205;
    private int special = 57;
    private boolean configured = false;
    private int version = 1;

    protected Object clone() throws CloneNotSupportedException {
        KeyboardData keyboardData = (KeyboardData)super.clone();
        keyboardData.setBrake(this.brake);
        keyboardData.setThrottle(this.throttle);
        keyboardData.setLeft(this.left);
        keyboardData.setRight(this.right);
        keyboardData.setSpecial(this.special);
        return keyboardData;
    }

    public String toString() {
        String string = "";
        string = string + ":" + Keyboard.getKeyName(this.throttle);
        string = string + ":" + Keyboard.getKeyName(this.brake);
        string = string + ":" + Keyboard.getKeyName(this.left);
        string = string + ":" + Keyboard.getKeyName(this.right);
        string = string + ":" + Keyboard.getKeyName(this.special);
        return string;
    }

    public int getThrottle() {
        return this.throttle;
    }

    public void setThrottle(int n) {
        this.throttle = n;
    }

    public int getBrake() {
        return this.brake;
    }

    public void setBrake(int n) {
        this.brake = n;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int n) {
        this.left = n;
    }

    public int getRight() {
        return this.right;
    }

    public void setRight(int n) {
        this.right = n;
    }

    public int getSpecial() {
        return this.special;
    }

    public void setSpecial(int n) {
        this.special = n;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public void setConfigured(boolean bl) {
        this.configured = bl;
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 0);
        if (n != this.version) {
            logger.warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
        }
        this.read(n, inputCapsule);
    }

    private void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                this.throttle = inputCapsule.readInt("throttle", 200);
                this.brake = inputCapsule.readInt("brake", 208);
                this.left = inputCapsule.readInt("left", 203);
                this.right = inputCapsule.readInt("right", 205);
                this.special = inputCapsule.readInt("special", 57);
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.version, "version", 0);
        outputCapsule.write(this.throttle, "throttle", 200);
        outputCapsule.write(this.brake, "brake", 208);
        outputCapsule.write(this.left, "left", 203);
        outputCapsule.write(this.right, "right", 205);
        outputCapsule.write(this.special, "special", 57);
    }
}

