/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.profile;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.turborilla.msm.profile.JoystickData;
import com.turborilla.msm.profile.KeyboardData;
import com.turborilla.msm.profile.MouseData;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public class InputData
implements Savable {
    private static final Logger logger = Logger.getLogger(InputData.class.getCanonicalName());
    private JoystickData joystickData;
    private KeyboardData keyboardData;
    private MouseData mouseData;
    private Device device = Device.Keyboard;
    private int version = 1;
    private ArrayList<WeakReference<IInputDataChangedListener>> changeListeners;

    public void reset() {
        this.device = Device.Keyboard;
        this.joystickData = null;
        this.keyboardData = null;
        this.mouseData = null;
    }

    public JoystickData getJoystickData() {
        if (this.joystickData == null) {
            this.joystickData = new JoystickData();
        }
        return this.joystickData;
    }

    public void setJoystickData(JoystickData joystickData) {
        try {
            this.joystickData = (JoystickData)joystickData.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    public MouseData getMouseData() {
        if (this.mouseData == null) {
            this.mouseData = new MouseData();
        }
        return this.mouseData;
    }

    public void setMouseData(MouseData mouseData) {
        try {
            this.mouseData = (MouseData)mouseData.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    public KeyboardData getKeyboardData() {
        if (this.keyboardData == null) {
            this.keyboardData = new KeyboardData();
        }
        return this.keyboardData;
    }

    public void setKeyboardData(KeyboardData keyboardData) {
        try {
            this.keyboardData = (KeyboardData)keyboardData.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 0);
        if (n != this.version) {
            logger.warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
        }
        this.read(n, inputCapsule);
    }

    private void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                this.joystickData = (JoystickData)inputCapsule.readSavable("joystickData", null);
                this.keyboardData = (KeyboardData)inputCapsule.readSavable("keyboardData", null);
                this.mouseData = (MouseData)inputCapsule.readSavable("mouseData", null);
                this.device = Device.valueOf(inputCapsule.readString("device", Device.Keyboard.name()));
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.version, "version", 0);
        outputCapsule.write(this.joystickData, "joystickData", null);
        outputCapsule.write(this.keyboardData, "keyboardData", null);
        outputCapsule.write(this.mouseData, "mouseData", null);
        outputCapsule.write(this.device.name(), "device", Device.Keyboard.name());
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public void addChangeListener(IInputDataChangedListener iInputDataChangedListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        this.changeListeners.add(new WeakReference<IInputDataChangedListener>(iInputDataChangedListener));
    }

    public void notifyChangeListeners() {
        if (this.changeListeners != null) {
            Iterator<WeakReference<IInputDataChangedListener>> iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                IInputDataChangedListener iInputDataChangedListener = (IInputDataChangedListener)iterator.next().get();
                if (iInputDataChangedListener == null) {
                    iterator.remove();
                    continue;
                }
                iInputDataChangedListener.inputDataChanged(this);
            }
        }
    }

    public static interface IInputDataChangedListener {
        public void inputDataChanged(InputData var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Device {
        Mouse,
        Keyboard,
        Gamepad;

    }
}

