/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.physics.objects;

import com.jme.renderer.ColorRGBA;
import com.turborilla.msm.physics.ConstraintRiderBender;
import com.turborilla.msm.physics.objects.BikeFrame;
import com.turborilla.physics.particle.ConstraintDamper;
import com.turborilla.physics.particle.ConstraintPullingSpring;
import com.turborilla.physics.particle.ConstraintPushingSpring;
import com.turborilla.physics.particle.ConstraintPushingSpringDamped;
import com.turborilla.physics.particle.ConstraintSpring;
import com.turborilla.physics.particle.ConstraintSpringDamped;
import com.turborilla.physics.particle.ConstraintStick;
import com.turborilla.physics.particle.IConstraint;
import com.turborilla.physics.particle.Particle;
import com.turborilla.physics.particle.ParticleObject;
import com.turborilla.utils.math.Vector3d;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class BikeRider2
extends ParticleObject {
    protected Particle rightHand;
    protected Particle leftHand;
    protected Particle rightElbow;
    protected Particle leftElbow;
    protected Particle shoulder;
    protected Particle ass;
    protected Particle rightKnee;
    protected Particle leftKnee;
    protected Particle rightFoot;
    protected Particle leftFoot;
    protected double[] relativeWeights = new double[]{0.5, 0.5, 1.5, 1.5, 21.0, 10.0, 3.0, 3.0, 1.0, 1.0};
    protected BikeFrame frame;
    protected int numberOfBenders = 6;
    protected ConstraintSpring[] benders = new ConstraintSpring[this.numberOfBenders];
    protected double[] centers = new double[this.numberOfBenders];
    protected ArrayList<IConstraint> deactivateOnCrash;
    protected ArrayList<IConstraint> activateOnCrash;
    private Vector3d centerOfMass;
    private double weight;
    private boolean crashing = false;
    private double[][][] benderKeyFrames = new double[][][]{new double[][]{{1.91f, 1.5, 2.36f, 2.35f, 2.35f, 3.02f}, {1.97f, 1.48f, 2.08f, 2.32f, 2.32f, 2.99f}}, new double[][]{{1.58f, 1.34f, 2.17f, 1.92f, 1.92f, 2.74f}, {1.97f, 1.48f, 2.08f, 2.32f, 2.32f, 2.99f}}, new double[][]{{1.33f, 0.98f, 1.76f, 1.48f, 1.48f, 2.44f}, {1.97f, 1.49f, 1.57f, 2.1f, 2.1f, 3.03f}}, new double[][]{{1.38f, 0.49f, 1.32f, 1.24f, 1.24f, 2.0}, {1.97f, 1.49f, 1.24f, 1.95f, 1.95f, 3.14f}}, new double[][]{{1.48f, 0.81f, 0.71f, 1.03f, 1.03f, 1.98f}, {1.92f, 1.39f, 0.59f, 1.42f, 1.42f, 2.88f}}, new double[][]{{1.96f, 1.11f, 0.36f, 1.56f, 1.56f, 1.62f}, {1.96f, 1.33f, 0.3f, 1.5, 1.5, 2.64f}}};
    private double[][] benderKeyPositions = new double[][]{{-0.5, -0.35f, -0.2f, 0.0, 0.15f, 0.5}, {-0.5, 0.5}};
    private ConstraintStick leftThigh;
    private ConstraintStick leftCalf;
    private ConstraintStick torso;
    private ConstraintStick leftUpperArm;
    private ConstraintStick leftLowerArm;
    private ConstraintStick rightThigh;
    private ConstraintStick rightCalf;
    private ConstraintStick rightUpperArm;
    private ConstraintStick rightLowerArm;
    private int curBender = 0;
    private boolean debug = false;
    private int debugKeyframe = 0;
    private int debugKeyframeAdder = 1;

    public BikeRider2(Vector3d vector3d, double d, BikeFrame bikeFrame, double d2, double d3) {
        super("Rider");
        this.deactivateOnCrash = new ArrayList();
        this.activateOnCrash = new ArrayList();
        this.init(vector3d, d, bikeFrame, d2, d3);
        this.centerOfMass = this.getCenterOfMass(null);
    }

    private void init(Vector3d vector3d, double d, BikeFrame bikeFrame, double d2, double d3) {
        this.weight = d;
        double d4 = 0.0;
        for (double d5 : this.relativeWeights) {
            d4 += d5;
        }
        this.frame = bikeFrame;
        this.rightHand = this.addParticle(bikeFrame.getHandlebar().position.add((double)0.1f * d2, (double)0.1f * d3, 0.0), d * this.relativeWeights[0] / d4);
        this.leftHand = this.addParticle(bikeFrame.getHandlebar().position.add((double)0.1f * d2, (double)0.1f * d3, 0.0), d * this.relativeWeights[1] / d4);
        this.rightElbow = this.addParticle(vector3d.x + 82.0 * d2, vector3d.y + 105.0 * d3, vector3d.z, d * this.relativeWeights[2] / d4);
        this.leftElbow = this.addParticle(vector3d.x + 82.0 * d2, vector3d.y + 105.0 * d3, vector3d.z, d * this.relativeWeights[3] / d4);
        this.shoulder = this.addParticle(vector3d.x + 66.0 * d2, vector3d.y + 125.0 * d3, vector3d.z, d * this.relativeWeights[4] / d4);
        this.ass = this.addParticle(vector3d.x + 37.0 * d2, vector3d.y + 86.0 * d3, vector3d.z, d * this.relativeWeights[5] / d4);
        this.rightKnee = this.addParticle(vector3d.x + 64.0 * d2, vector3d.y + 66.0 * d3, vector3d.z, d * this.relativeWeights[6] / d4);
        this.leftKnee = this.addParticle(vector3d.x + 64.0 * d2, vector3d.y + 66.0 * d3, vector3d.z, d * this.relativeWeights[7] / d4);
        this.rightFoot = this.addParticle(bikeFrame.getFootrest().position.add((double)0.1f * d2, (double)0.1f * d3, 0.0), d * this.relativeWeights[8] / d4);
        this.leftFoot = this.addParticle(bikeFrame.getFootrest().position.add((double)0.1f * d2, (double)0.1f * d3, 0.0), d * this.relativeWeights[9] / d4);
        Callable callable = new Callable(){

            public Object call() {
                BikeRider2.this.crash(BikeRider2.this.getDamp());
                System.out.println("crashed");
                return null;
            }
        };
        ConstraintSpring constraintSpring = new ConstraintSpring(this.rightHand, bikeFrame.getHandlebar());
        this.addConstraint(constraintSpring);
        this.deactivateOnCrash.add(constraintSpring);
        ConstraintSpring constraintSpring2 = new ConstraintSpring(this.rightFoot, bikeFrame.getFootrest());
        this.addConstraint(constraintSpring2);
        this.deactivateOnCrash.add(constraintSpring2);
        ConstraintSpring constraintSpring3 = new ConstraintSpring(this.leftHand, bikeFrame.getHandlebar());
        this.addConstraint(constraintSpring3);
        this.deactivateOnCrash.add(constraintSpring3);
        ConstraintSpring constraintSpring4 = new ConstraintSpring(this.leftFoot, bikeFrame.getFootrest());
        this.addConstraint(constraintSpring4);
        this.deactivateOnCrash.add(constraintSpring4);
        double d6 = 8.75 * d;
        double d7 = 4.0 * d;
        ConstraintStick constraintStick = new ConstraintStick(this.rightHand, this.rightElbow);
        this.addConstraint(constraintStick);
        this.rightLowerArm = constraintStick;
        ConstraintStick constraintStick2 = new ConstraintStick(this.rightElbow, this.shoulder);
        this.addConstraint(constraintStick2);
        this.rightUpperArm = constraintStick2;
        ConstraintStick constraintStick3 = new ConstraintStick(this.leftHand, this.leftElbow);
        this.addConstraint(constraintStick3);
        this.leftLowerArm = constraintStick3;
        ConstraintStick constraintStick4 = new ConstraintStick(this.leftElbow, this.shoulder);
        this.addConstraint(constraintStick4);
        this.leftUpperArm = constraintStick4;
        ConstraintStick constraintStick5 = new ConstraintStick(this.shoulder, this.ass);
        this.addConstraint(constraintStick5);
        this.torso = constraintStick5;
        ConstraintStick constraintStick6 = new ConstraintStick(this.ass, this.rightKnee);
        this.addConstraint(constraintStick6);
        this.rightThigh = constraintStick6;
        ConstraintStick constraintStick7 = new ConstraintStick(this.rightKnee, this.rightFoot);
        this.addConstraint(constraintStick7);
        this.rightCalf = constraintStick7;
        ConstraintStick constraintStick8 = new ConstraintStick(this.ass, this.leftKnee);
        this.addConstraint(constraintStick8);
        this.leftThigh = constraintStick8;
        ConstraintStick constraintStick9 = new ConstraintStick(this.leftKnee, this.leftFoot);
        this.addConstraint(constraintStick9);
        this.leftCalf = constraintStick9;
        d6 = 8.75 * d;
        ConstraintPushingSpring constraintPushingSpring = new ConstraintPushingSpring(this.ass, bikeFrame.getRearAxle());
        constraintPushingSpring.setRestLength(51.0 * d2 * (double)0.6f);
        constraintPushingSpring.setStiffness(10.0 * d);
        this.addConstraint(constraintPushingSpring);
        this.deactivateOnCrash.add(constraintPushingSpring);
        constraintPushingSpring.setDebugColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f));
        constraintPushingSpring = new ConstraintPushingSpring(this.leftElbow, bikeFrame.getFork());
        constraintPushingSpring.setRestLength(48.333335876464844 * d2);
        constraintPushingSpring.setStiffness(10.0 * d);
        this.addConstraint(constraintPushingSpring);
        this.deactivateOnCrash.add(constraintPushingSpring);
        constraintPushingSpring = new ConstraintPushingSpring(this.rightElbow, bikeFrame.getFork());
        constraintPushingSpring.setRestLength(48.333335876464844 * d2);
        constraintPushingSpring.setStiffness(10.0 * d);
        this.addConstraint(constraintPushingSpring);
        this.deactivateOnCrash.add(constraintPushingSpring);
        constraintPushingSpring = new ConstraintPushingSpring(this.ass, bikeFrame.getFork());
        constraintPushingSpring.setRestLength(56.66666793823242 * d2);
        constraintPushingSpring.setStiffness(10.0 * d);
        this.addConstraint(constraintPushingSpring);
        this.deactivateOnCrash.add(constraintPushingSpring);
        constraintPushingSpring.setDebugColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f));
        ConstraintPullingSpring constraintPullingSpring = new ConstraintPullingSpring(this.leftHand, this.shoulder);
        constraintPullingSpring.setRestLength((this.leftHand.position.subtract(this.leftElbow.position).length() + this.leftElbow.position.subtract(this.shoulder.position).length()) * (double)0.97f);
        constraintPullingSpring.setStiffness(20.0 * d);
        this.addConstraint(constraintPullingSpring);
        this.deactivateOnCrash.add(constraintPullingSpring);
        constraintPullingSpring = new ConstraintPullingSpring(this.rightHand, this.shoulder);
        constraintPullingSpring.setRestLength((this.rightHand.position.subtract(this.rightElbow.position).length() + this.rightElbow.position.subtract(this.shoulder.position).length()) * (double)0.97f);
        constraintPullingSpring.setStiffness(20.0 * d);
        this.addConstraint(constraintPullingSpring);
        this.deactivateOnCrash.add(constraintPullingSpring);
        ConstraintStick constraintStick10 = new ConstraintStick(this.leftElbow, this.rightElbow);
        this.addConstraint(constraintStick10);
        d6 = 0.375 * d;
        ConstraintSpringDamped constraintSpringDamped = new ConstraintRiderBender(this.rightFoot, this.ass, d7);
        constraintSpringDamped.setStiffness(d6);
        this.addConstraint(constraintSpringDamped);
        this.benders[0] = constraintSpringDamped;
        this.deactivateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped.setDebugColor(new ColorRGBA(0.0f, 0.0f, 1.0f, 1.0f));
        constraintSpringDamped = new ConstraintRiderBender(this.rightHand, this.shoulder, d7);
        constraintSpringDamped.setStiffness(d6);
        this.addConstraint(constraintSpringDamped);
        this.benders[1] = constraintSpringDamped;
        this.deactivateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped.setDebugColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        constraintSpringDamped = new ConstraintRiderBender(this.rightHand, this.ass, d7);
        constraintSpringDamped.setStiffness(d6);
        this.addConstraint(constraintSpringDamped);
        this.benders[2] = constraintSpringDamped;
        this.deactivateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped.setDebugColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        constraintSpringDamped = new ConstraintRiderBender(this.rightKnee, bikeFrame.getFork(), d7);
        constraintSpringDamped.setStiffness(d6 * (double)0.1f);
        this.addConstraint(constraintSpringDamped);
        this.benders[3] = constraintSpringDamped;
        this.deactivateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped.setDebugColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        constraintSpringDamped = new ConstraintRiderBender(this.leftKnee, bikeFrame.getFork(), d7);
        constraintSpringDamped.setStiffness(d6 * (double)0.1f);
        this.addConstraint(constraintSpringDamped);
        this.benders[4] = constraintSpringDamped;
        this.deactivateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped.setDebugColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        constraintSpringDamped = new ConstraintRiderBender(this.shoulder, bikeFrame.getFork(), d7);
        constraintSpringDamped.setStiffness(d6);
        this.addConstraint(constraintSpringDamped);
        this.benders[5] = constraintSpringDamped;
        this.deactivateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped.setDebugColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        int n = 0;
        for (ConstraintSpring constraintSpring5 : this.benders) {
            this.centers[n] = constraintSpring5 != null ? constraintSpring5.getRestLength() : -1.0;
            ++n;
        }
        for (ConstraintSpring constraintSpring5 : (Object)this.benderKeyFrames) {
            for (int i = 0; i < ((ConstraintSpring)constraintSpring5).length; ++i) {
                int n2 = 0;
                while (n2 < ((ConstraintSpring)constraintSpring5[i]).length) {
                    ConstraintSpring constraintSpring6 = constraintSpring5[i];
                    int n3 = n2++;
                    constraintSpring6[n3] = constraintSpring6[n3] * (d2 / (double)0.03f);
                }
            }
        }
        d6 = (double)0.00125f * d;
        d7 = 2.0 * d;
        constraintSpringDamped = new ConstraintSpringDamped(this.shoulder, this.rightKnee, d7);
        constraintSpringDamped.setStiffness(d6);
        constraintSpringDamped.setRestLength(constraintSpringDamped.getRestLength() * 4.0);
        this.addConstraint(constraintSpringDamped);
        constraintSpringDamped.setActive(false);
        this.activateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped = new ConstraintSpringDamped(this.ass, this.rightFoot, d7);
        constraintSpringDamped.setStiffness(d6);
        constraintSpringDamped.setRestLength(constraintSpringDamped.getRestLength() * (double)2.2f);
        this.addConstraint(constraintSpringDamped);
        constraintSpringDamped.setActive(false);
        this.activateOnCrash.add(constraintSpringDamped);
        ConstraintPushingSpringDamped constraintPushingSpringDamped = new ConstraintPushingSpringDamped(this.shoulder, this.rightHand, d7 * 1.0);
        constraintPushingSpringDamped.setStiffness(d6 * 5.0);
        constraintPushingSpringDamped.setRestLength(this.rightLowerArm.getRestLength() * 2.0);
        this.addConstraint(constraintPushingSpringDamped);
        constraintPushingSpringDamped.setActive(false);
        this.activateOnCrash.add(constraintPushingSpringDamped);
        Object object = new ConstraintDamper(this.ass, this.rightElbow);
        ((ConstraintDamper)object).setStiffness((double)0.09f * d);
        this.addConstraint((IConstraint)object);
        ((ConstraintDamper)object).setActive(false);
        this.activateOnCrash.add((IConstraint)object);
        object = new ConstraintDamper(this.shoulder, this.rightHand);
        ((ConstraintDamper)object).setStiffness((double)0.09f * d);
        this.addConstraint((IConstraint)object);
        ((ConstraintDamper)object).setActive(false);
        this.activateOnCrash.add((IConstraint)object);
        constraintSpringDamped = new ConstraintSpringDamped(this.shoulder, this.leftKnee, d7);
        constraintSpringDamped.setStiffness(d6);
        constraintSpringDamped.setRestLength(constraintSpringDamped.getRestLength() * (double)3.8f);
        this.addConstraint(constraintSpringDamped);
        constraintSpringDamped.setActive(false);
        this.activateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped = new ConstraintSpringDamped(this.ass, this.leftFoot, d7);
        constraintSpringDamped.setStiffness(d6);
        constraintSpringDamped.setRestLength(constraintSpringDamped.getRestLength() * (double)2.6f);
        this.addConstraint(constraintSpringDamped);
        constraintSpringDamped.setActive(false);
        this.activateOnCrash.add(constraintSpringDamped);
        constraintPushingSpringDamped = new ConstraintPushingSpringDamped(this.shoulder, this.leftHand, d7 * 1.0);
        constraintPushingSpringDamped.setStiffness(d6);
        constraintPushingSpringDamped.setRestLength(this.leftLowerArm.getRestLength() * 1.0);
        this.addConstraint(constraintPushingSpringDamped);
        constraintPushingSpringDamped.setActive(false);
        this.activateOnCrash.add(constraintPushingSpringDamped);
        object = new ConstraintDamper(this.ass, this.leftElbow);
        ((ConstraintDamper)object).setStiffness((double)0.09f * d);
        this.addConstraint((IConstraint)object);
        ((ConstraintDamper)object).setActive(false);
        this.activateOnCrash.add((IConstraint)object);
        object = new ConstraintDamper(this.shoulder, this.leftHand);
        ((ConstraintDamper)object).setStiffness((double)0.09f * d);
        this.addConstraint((IConstraint)object);
        ((ConstraintDamper)object).setActive(false);
        this.activateOnCrash.add((IConstraint)object);
    }

    public void debugPrintBenders() {
        for (int i = 0; i < this.benders.length; ++i) {
            if (this.benders[i] == null) continue;
            System.out.println("" + i + ": " + this.benders[i].getCurrentLength());
        }
        System.out.println("-------------------");
    }

    public void changeBender() {
        if (this.benders[this.curBender] != null) {
            this.benders[this.curBender].getDebugColor().set(1.0f, 0.0f, 0.0f, 1.0f);
        }
        ++this.curBender;
        if (this.curBender >= this.numberOfBenders) {
            this.curBender = 0;
        }
        if (this.benders[this.curBender] != null) {
            this.benders[this.curBender].getDebugColor().set(0.0f, 0.0f, 1.0f, 1.0f);
        }
        System.out.println("curBender: " + this.curBender);
    }

    public void addBenderLength(double d) {
        ConstraintSpring constraintSpring = this.benders[this.curBender];
        if (constraintSpring != null) {
            constraintSpring.setRestLength(constraintSpring.getRestLength() + d);
        }
    }

    public void toggleDebug() {
        this.debug = !this.debug;
        System.out.println("debug is " + (this.debug ? "on" : "off"));
    }

    public void switchKeyframe() {
        if (!this.debug) {
            return;
        }
        this.debugKeyframe += this.debugKeyframeAdder;
        if (this.debugKeyframe >= this.numberOfBenders - 1 || this.debugKeyframe <= 0) {
            this.debugKeyframeAdder = -this.debugKeyframeAdder;
        }
        this.debug = false;
        this.lean(this.benderKeyPositions[0][this.debugKeyframe]);
        this.debug = true;
        System.out.println("debugKeyframe: " + this.debugKeyframe);
    }

    public void crash(double d) {
        this.crashing = true;
        for (IConstraint iConstraint : this.deactivateOnCrash) {
            iConstraint.setActive(false);
        }
        for (IConstraint iConstraint : this.activateOnCrash) {
            iConstraint.setActive(true);
        }
        this.setDamp(d);
    }

    public void lean(double[] dArray) {
        if (this.debug) {
            return;
        }
        int[] nArray = new int[dArray.length];
        double[] dArray2 = new double[dArray.length];
        double[] dArray3 = new double[dArray.length];
        double[] dArray4 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = 0;
            for (double d : this.benderKeyPositions[i]) {
                if (dArray[i] < d) break;
                int n = i;
                nArray[n] = nArray[n] + 1;
            }
            int n = i;
            nArray[n] = nArray[n] - 1;
            if (nArray[i] > this.benderKeyPositions[i].length - 2) {
                nArray[i] = this.benderKeyPositions[i].length - 2;
            }
            dArray2[i] = this.benderKeyPositions[i][nArray[i]];
            dArray3[i] = this.benderKeyPositions[i][nArray[i] + 1];
            dArray4[i] = (dArray[i] - dArray2[i]) / (dArray3[i] - dArray2[i]);
        }
        double[][] dArray5 = new double[dArray.length][this.numberOfBenders];
        double[][] dArray6 = new double[dArray.length][this.numberOfBenders];
        dArray5[0] = this.benderKeyFrames[nArray[0]][nArray[1]];
        dArray5[1] = this.benderKeyFrames[nArray[0]][nArray[1] + 1];
        dArray6[0] = this.benderKeyFrames[nArray[0] + 1][nArray[1]];
        dArray6[1] = this.benderKeyFrames[nArray[0] + 1][nArray[1] + 1];
        for (int i = 0; i < this.numberOfBenders; ++i) {
            ConstraintSpring constraintSpring = this.benders[i];
            double d = dArray5[0][i] + (dArray6[0][i] - dArray5[0][i]) * dArray4[0];
            double d2 = dArray5[1][i] + (dArray6[1][i] - dArray5[1][i]) * dArray4[0];
            double d3 = d + (d2 - d) * dArray4[1];
            constraintSpring.setRestLength(d3);
        }
    }

    public double lerp(double d, double d2, double d3) {
        return d + (d2 - d) * d3;
    }

    public double cosLerp(double d, double d2, double d3) {
        double d4 = (1.0 - Math.cos(d3 * Math.PI)) * 0.5;
        return d * (1.0 - d4) + d2 * d4;
    }

    public void lean(double d) {
        if (this.debug) {
            return;
        }
        int n = 0;
        for (double d2 : this.benderKeyPositions[0]) {
            if (d < d2) break;
            ++n;
        }
        if (--n > this.benderKeyPositions[0].length - 2) {
            n = this.benderKeyPositions[0].length - 2;
        }
        double d3 = this.benderKeyPositions[0][n];
        double d4 = this.benderKeyPositions[0][n + 1];
        double d5 = (d - d3) / (d4 - d3);
        int n2 = 0;
        double[] dArray = this.benderKeyFrames[n][0];
        double[] dArray2 = this.benderKeyFrames[n + 1][0];
        for (ConstraintSpring constraintSpring : this.benders) {
            constraintSpring.setRestLength(dArray[n2] + (dArray2[n2] - dArray[n2]) * d5);
            ++n2;
        }
    }

    public void lean(double d, int n) {
        if (this.benders[n] == null) {
            return;
        }
        this.benders[n].setRestLength(this.centers[n] + d);
        int n2 = 0;
        System.out.println();
        for (ConstraintSpring constraintSpring : this.benders) {
            System.out.println("bender[" + n2 + "] = " + (constraintSpring == null ? "null" : Double.valueOf(constraintSpring.getCurrentLength())));
            ++n2;
        }
    }

    public Vector3d getLocalTranslation() {
        return this.getCenterOfMass(this.centerOfMass);
    }

    public Vector3d getWorldTranslation() {
        return this.getLocalTranslation();
    }

    public Particle getAss() {
        return this.ass;
    }

    public void setAss(Particle particle) {
        this.ass = particle;
    }

    public Particle getRightElbow() {
        return this.rightElbow;
    }

    public void setRightElbow(Particle particle) {
        this.rightElbow = particle;
    }

    public Particle getRightFoot() {
        return this.rightFoot;
    }

    public void setRightFoot(Particle particle) {
        this.rightFoot = particle;
    }

    public Particle getRightHand() {
        return this.rightHand;
    }

    public void setRightHand(Particle particle) {
        this.rightHand = particle;
    }

    public Particle getRightKnee() {
        return this.rightKnee;
    }

    public void setRightKnee(Particle particle) {
        this.rightKnee = particle;
    }

    public Particle getShoulder() {
        return this.shoulder;
    }

    public void setShoulder(Particle particle) {
        this.shoulder = particle;
    }

    public ConstraintStick getLeftCalf() {
        return this.leftCalf;
    }

    public ConstraintStick getLeftThigh() {
        return this.leftThigh;
    }

    public ConstraintStick getLeftLowerArm() {
        return this.leftLowerArm;
    }

    public ConstraintStick getTorso() {
        return this.torso;
    }

    public ConstraintStick getLeftUpperArm() {
        return this.leftUpperArm;
    }

    public ConstraintStick getRightCalf() {
        return this.rightCalf;
    }

    public ConstraintStick getRightLowerArm() {
        return this.rightLowerArm;
    }

    public ConstraintStick getRightThigh() {
        return this.rightThigh;
    }

    public ConstraintStick getRightUpperArm() {
        return this.rightUpperArm;
    }

    public Particle getLeftElbow() {
        return this.leftElbow;
    }

    public Particle getLeftFoot() {
        return this.leftFoot;
    }

    public Particle getLeftHand() {
        return this.leftHand;
    }

    public Particle getLeftKnee() {
        return this.leftKnee;
    }
}

