/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.physics.objects;

import com.turborilla.physics.particle.ConstraintDamper;
import com.turborilla.physics.particle.ConstraintDummyStick;
import com.turborilla.physics.particle.ConstraintPullingSpringDamped;
import com.turborilla.physics.particle.ConstraintPullingStick;
import com.turborilla.physics.particle.ConstraintPushingSpringDamped;
import com.turborilla.physics.particle.ConstraintSpringDamped;
import com.turborilla.physics.particle.ConstraintStick;
import com.turborilla.physics.particle.IConstraint;
import com.turborilla.physics.particle.Particle;
import com.turborilla.physics.particle.ParticleObject;
import com.turborilla.utils.math.Matrix4d;
import com.turborilla.utils.math.Vector3d;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BikeFrame
extends ParticleObject {
    Particle footrest;
    Particle handlebar;
    Particle fork;
    Particle forkHelper;
    Particle rearDamperAttachment;
    Particle rearDamperAnchor;
    Particle rearAxle;
    Particle frontAxle;
    double[] relativeWeights = new double[]{1.5, 0.5, 1.5, 1.5, 1.25, 1.25};
    double mass = 0.0;
    ConstraintStick rearSuspensionArm;
    private ArrayList<ConstraintStick> bottomOutSoundSticks;
    private ArrayList<ConstraintStick> soundSticks;
    private ArrayList<IConstraint> rearSuspensionSticks;
    private ArrayList<IConstraint> frontSuspensionSticks;
    private double initialDamp;
    private Vector3d tempAngularVelocity = new Vector3d();
    private Vector3d yAxis = new Vector3d();
    private Vector3d yAxisPrev = new Vector3d();
    private Vector3d dir = new Vector3d();
    private double angularVelocity;

    public BikeFrame(Vector3d vector3d, Particle particle, Particle particle2, double d, double d2, double d3) {
        super("Frame");
        this.mass = d3;
        this.initialDamp = this.getDamp();
        this.soundSticks = new ArrayList();
        this.bottomOutSoundSticks = new ArrayList();
        this.rearSuspensionSticks = new ArrayList();
        this.frontSuspensionSticks = new ArrayList();
        double d4 = 0.0;
        for (double d5 : this.relativeWeights) {
            d4 += d5;
        }
        this.footrest = this.addParticle(vector3d.x + 66.0 * d, vector3d.y + 48.0 * d2, vector3d.z, d3 * this.relativeWeights[0] / d4);
        this.handlebar = this.addParticle(vector3d.x + 105.0 * d, vector3d.y + 95.0 * d2, vector3d.z, d3 * this.relativeWeights[1] / d4);
        this.fork = this.addParticle(vector3d.x + 129.0 * d, vector3d.y + 50.0 * d2, vector3d.z, d3 * this.relativeWeights[2] / d4);
        this.forkHelper = this.addParticle(vector3d.x + 92.0 * d, vector3d.y + 12.0 * d2, vector3d.z, d3 * this.relativeWeights[3] / d4);
        this.rearDamperAttachment = this.addParticle(vector3d.x + 67.0 * d, vector3d.y + 48.0 * d2, vector3d.z, d3 * this.relativeWeights[4] / d4);
        this.rearDamperAnchor = this.addParticle(particle.position.x - 5.0 * d, vector3d.y + 85.0 * d2, vector3d.z, d3 * this.relativeWeights[5] / d4);
        this.rearAxle = particle;
        this.frontAxle = particle2;
        Object object = new ConstraintStick(this.rearDamperAttachment, this.rearAxle);
        this.addConstraint((IConstraint)object);
        ((ConstraintStick)object).setName("RearSuspensionArm");
        this.rearSuspensionArm = object;
        object = new ConstraintStick(this.footrest, this.rearDamperAnchor);
        this.addConstraint((IConstraint)object);
        object = new ConstraintStick(this.rearDamperAnchor, this.handlebar);
        this.addConstraint((IConstraint)object);
        double d6 = (double)2.7f * d3 * 1.7692307233810425;
        double d7 = 0.09565217792987823 * d3 * 1.7692307233810425;
        ConstraintSpringDamped constraintSpringDamped = new ConstraintSpringDamped(this.rearAxle, this.rearDamperAnchor, d6);
        this.rearSuspensionSticks.add(constraintSpringDamped);
        constraintSpringDamped.setStiffness(d7);
        this.addConstraint(constraintSpringDamped);
        this.soundSticks.add(constraintSpringDamped);
        ConstraintSpringDamped constraintSpringDamped2 = constraintSpringDamped;
        object = new ConstraintStick(this.footrest, this.fork);
        this.addConstraint((IConstraint)object);
        object = new ConstraintStick(this.fork, this.handlebar);
        this.addConstraint((IConstraint)object);
        object = new ConstraintStick(this.footrest, this.handlebar);
        this.addConstraint((IConstraint)object);
        object = new ConstraintStick(this.rearDamperAttachment, this.handlebar);
        this.addConstraint((IConstraint)object);
        object = new ConstraintStick(this.rearDamperAttachment, this.fork);
        this.addConstraint((IConstraint)object);
        object = new ConstraintStick(this.rearDamperAttachment, this.footrest);
        this.addConstraint((IConstraint)object);
        object = new ConstraintStick(this.rearDamperAttachment, this.rearDamperAnchor);
        this.addConstraint((IConstraint)object);
        object = new ConstraintStick(this.footrest, this.forkHelper);
        this.addConstraint((IConstraint)object);
        object = new ConstraintStick(this.forkHelper, this.fork);
        this.addConstraint((IConstraint)object);
        object = new ConstraintStick(this.forkHelper, this.frontAxle);
        this.addConstraint((IConstraint)object);
        Object object2 = object;
        this.frontSuspensionSticks.add((IConstraint)object);
        d7 = 13.0 * d3 * 1.7692307233810425;
        ConstraintDamper constraintDamper = new ConstraintDamper(this.forkHelper, this.frontAxle);
        constraintDamper.setStiffness(d7);
        this.addConstraint(constraintDamper);
        this.frontSuspensionSticks.add(constraintDamper);
        d7 = 152.5 * d3 * 1.7692307233810425;
        d6 = 11.5 * d3 * 1.7692307233810425;
        ConstraintPushingSpringDamped constraintPushingSpringDamped = new ConstraintPushingSpringDamped(this.frontAxle, this.fork);
        constraintPushingSpringDamped.setRestLength(constraintPushingSpringDamped.getRestLength() * (double)0.3f);
        constraintPushingSpringDamped.setStiffness(d7);
        constraintPushingSpringDamped.setDamping(d6);
        this.addConstraint(constraintPushingSpringDamped);
        this.bottomOutSoundSticks.add(constraintPushingSpringDamped);
        object = new ConstraintPullingStick(this.frontAxle, this.fork);
        ((ConstraintStick)object).setRestLength(((ConstraintStick)object).getRestLength() * (double)1.2f);
        this.addConstraint((IConstraint)object);
        d6 = 4.0 * d3 * 1.7692307233810425;
        d7 = 0.239130437374115 * d3 * 1.7692307233810425;
        constraintSpringDamped = new ConstraintSpringDamped(this.frontAxle, this.fork, d6);
        constraintSpringDamped.setStiffness(d7);
        this.addConstraint(constraintSpringDamped);
        this.soundSticks.add(constraintSpringDamped);
        this.frontSuspensionSticks.add(constraintSpringDamped);
        object = new ConstraintDummyStick(this.frontAxle, this.handlebar);
        ((ConstraintStick)object).setName("Fork");
        this.addConstraint((IConstraint)object);
        d7 = 8.5 * d3 * 1.7692307233810425;
        d6 = 8.5 * d3 * 1.7692307233810425;
        ConstraintPullingSpringDamped constraintPullingSpringDamped = new ConstraintPullingSpringDamped(this.rearAxle, this.rearDamperAnchor);
        this.rearSuspensionSticks.add(constraintPullingSpringDamped);
        constraintPullingSpringDamped.setRestLength(constraintPullingSpringDamped.getRestLength() * (double)1.05f);
        constraintPullingSpringDamped.setStiffness(d7);
        constraintPullingSpringDamped.setDamping(d6);
        this.addConstraint(constraintPullingSpringDamped);
        d7 = 1.0 * d3 * 1.7692307233810425;
        d6 = 2.5 * d3 * 1.7692307233810425;
        constraintPushingSpringDamped = new ConstraintPushingSpringDamped(this.rearAxle, this.rearDamperAnchor);
        this.rearSuspensionSticks.add(constraintPushingSpringDamped);
        constraintPushingSpringDamped.setRestLength(constraintPushingSpringDamped.getRestLength() * 0.5);
        constraintPushingSpringDamped.setStiffness(d7);
        constraintPushingSpringDamped.setDamping(d6);
        this.addConstraint(constraintPushingSpringDamped);
        this.bottomOutSoundSticks.add(constraintPushingSpringDamped);
        ConstraintPushingSpringDamped constraintPushingSpringDamped2 = constraintPushingSpringDamped;
        this.frameParticles[0] = this.fork;
        this.frameParticles[1] = this.rearDamperAttachment;
        this.frameParticles[2] = this.rearDamperAnchor;
        this.originParticle = this.rearDamperAttachment;
    }

    public boolean isRearSuspensionBroken() {
        Vector3d vector3d = this.yAxis;
        Vector3d vector3d2 = this.yAxisPrev;
        vector3d.set(this.rearAxle.getPosition()).subtractLocal(this.rearDamperAttachment.getPosition());
        vector3d2.set(this.rearDamperAnchor.getPosition()).subtractLocal(this.rearDamperAttachment.getPosition());
        vector3d.cross(vector3d2, this.dir);
        return this.dir.z > 0.0;
    }

    public boolean isFrontSuspensionBroken() {
        Vector3d vector3d = this.yAxis;
        Vector3d vector3d2 = this.yAxisPrev;
        vector3d.set(this.frontAxle.getPosition()).subtractLocal(this.forkHelper.getPosition());
        vector3d2.set(this.fork.getPosition()).subtractLocal(this.forkHelper.getPosition());
        vector3d.cross(vector3d2, this.dir);
        return this.dir.z < 0.0;
    }

    @Override
    public Matrix4d updateCoordinateFrame() {
        Matrix4d matrix4d = super.updateCoordinateFrame();
        this.angularVelocity = this.updateAngularVelocity();
        return matrix4d;
    }

    public double updateAngularVelocity() {
        this.yAxis.set(this.frame.m10, this.frame.m11, 0.0);
        this.yAxisPrev.set(this.previousFrame.m10, this.previousFrame.m11, 0.0);
        this.yAxis.subtract(this.yAxisPrev, this.tempAngularVelocity);
        this.yAxis.cross(this.yAxisPrev, this.dir);
        return Math.signum(this.dir.z) * this.tempAngularVelocity.length();
    }

    public void crash(double d) {
        this.setDamp(d);
    }

    public void reset() {
        int n;
        this.setDamp(this.initialDamp);
        for (n = 0; n < this.rearSuspensionSticks.size(); ++n) {
            this.rearSuspensionSticks.get(n).setActive(true);
        }
        for (n = 0; n < this.frontSuspensionSticks.size(); ++n) {
            this.frontSuspensionSticks.get(n).setActive(true);
        }
    }

    public void loseRearWheel() {
        for (int i = 0; i < this.rearSuspensionSticks.size(); ++i) {
            this.rearSuspensionSticks.get(i).setActive(false);
        }
    }

    public void loseFrontWheel() {
        for (int i = 0; i < this.frontSuspensionSticks.size(); ++i) {
            this.frontSuspensionSticks.get(i).setActive(false);
        }
    }

    public Particle getFootrest() {
        return this.footrest;
    }

    public Particle getFork() {
        return this.fork;
    }

    public Particle getForkHelper() {
        return this.forkHelper;
    }

    public Particle getFrontAxle() {
        return this.frontAxle;
    }

    public Particle getHandlebar() {
        return this.handlebar;
    }

    public Particle getRearAxle() {
        return this.rearAxle;
    }

    public Particle getRearDamperAnchor() {
        return this.rearDamperAnchor;
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    public ArrayList<ConstraintStick> getBottomOutSoundSticks() {
        return this.bottomOutSoundSticks;
    }

    public ArrayList<ConstraintStick> getSoundSticks() {
        return this.soundSticks;
    }

    public ConstraintStick getRearSuspensionArm() {
        return this.rearSuspensionArm;
    }

    public Particle getRearDamperAttachment() {
        return this.rearDamperAttachment;
    }

    public double getAngularVelocity() {
        return this.angularVelocity;
    }
}

