/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.physics.objects;

import com.jme.image.Texture;
import com.jme.scene.TriMesh;
import com.turborilla.event.typesafe.Event;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.gameobject.GameObject;
import com.turborilla.msm.gameobjects.BikeGameObject;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.physics.collision.ConstraintCollisionBikeWheel;
import com.turborilla.msm.physics.collision.ConstraintCollisionObject;
import com.turborilla.msm.physics.collision.ConstraintCollisionParticles;
import com.turborilla.msm.physics.collision.ParticleObjectEffectCollisionSpray;
import com.turborilla.msm.physics.objects.BikeFrame;
import com.turborilla.msm.physics.objects.BikeRider;
import com.turborilla.msm.physics.objects.BikeWheel;
import com.turborilla.physics.collision.CollisionStructure;
import com.turborilla.physics.collision.IntersectionResult;
import com.turborilla.physics.particle.Force;
import com.turborilla.physics.particle.Particle;
import com.turborilla.physics.particle.ParticleEffectsSystem;
import com.turborilla.physics.particle.ParticleSystem;
import com.turborilla.sound.CompositeSFX;
import com.turborilla.utils.math.Vector3d;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

public class Bike
extends ParticleSystem {
    private static final double THROW_RIDER_AT_MAX_ANGULAR_VELOCITY = 0.16;
    private static final double THROW_RIDER_AT_MIN_ANGULAR_VELOCITY = -0.12;
    Properties props;
    BikeWheel frontWheel;
    BikeWheel rearWheel;
    BikeRider rider;
    BikeFrame frame;
    TriMesh collisionMesh;
    double zPosition = 0.0;
    CollisionStructure grid;
    Force[] boostForces;
    Force[] jumpForces;
    Force[] jetpackForces;
    Particle[] boostDirectionParticles;
    Particle[] jetpackParticles;
    boolean airborne = true;
    boolean airbornePreviousFrame = true;
    boolean frontWheelInAir = true;
    boolean frontWheelInAirPreviousFrame = true;
    boolean rearWheelInAir = true;
    boolean rearWheelInAirPreviousFrame = true;
    EventManager eventManager;
    float timeSinceLastReset = 0.0f;
    double axleDistance = 0.0;
    protected ConstraintCollisionParticles riderCollision;
    protected ConstraintCollisionObject frontWheelCollision;
    protected ConstraintCollisionObject rearWheelCollision;
    protected ConstraintCollisionObject frameCollision;
    protected Callable callCrashOnCollisionWithRider;
    protected Callable playSoundOnCollisionWithRider;
    protected CompositeSFX sfx;
    protected GameObject gameObject;
    private boolean thrownRiderOff = false;
    private boolean crashing = false;
    private float riderBeenCrashingForTime = 0.0f;
    private float riderBeenLayingStillForTime = 0.0f;
    private float riderBeenThrownOffForTime = 0.0f;
    private static float maxCrashTimeBeforeReset = 20.0f;
    private static float maxThrownOffTimeBeforeCrash = 0.7f;
    private static float timeToLieStillBeforeReset = 1.7f;
    private Event crashedEvent = new Event("Crashed", new String[][]{{"gameObject"}, {""}});
    private Event backOnBikeEvent = new Event("BackOnBike", new String[][]{{"gameObject"}, {""}});
    private static final String requestResetEvent = "ResetAfterCrashRequested";
    private Vector3d lastCenterOfMass = new Vector3d();
    private Vector3d curCenterOfMass = new Vector3d();
    private float airborneForTime = 0.0f;
    private float frontWheelInAirForTime = 0.0f;
    private float rearWheelInAirForTime = 0.0f;
    private float loseWheelsAfterTime = 1.0f;
    private float rearSuspensionBeenBrokenFor = 0.0f;
    private float frontSuspensionBeenBrokenFor = 0.0f;
    private boolean wheelLost = false;
    private float wheelLostForTime = 0.0f;
    private float wheelLostTimeBeforeCrash = 2.0f;
    private double[] prevAngVel = new double[40];
    private int prevAngVelIndex = 0;
    private double angVelMean = 0.0;
    private Vector3d centerOfMass = new Vector3d();
    private Vector3d boostDirection = new Vector3d();
    private Vector3d perpBoostDirection = new Vector3d();
    private Vector3d boost0DistanceVec = new Vector3d();
    private Vector3d boost1DistanceVec = new Vector3d();
    private double boostMagnitude = 0.0;
    private double jumpMagnitude = 0.0;
    private double jetpackMagnitude = 0.0;
    private boolean gliding;
    private Vector3d jetpackDirection0 = new Vector3d();
    private Vector3d jetpackDirection1 = new Vector3d();
    private float airborneAndGlidingForTime = 0.0f;
    private Vector3d tempVec = new Vector3d();
    private IntersectionResult dummyResult = new IntersectionResult();
    private Vector3d horizontalVec = new Vector3d();
    private Vector3d upVec = new Vector3d();
    private Vector3d horizontalVelocity = new Vector3d();

    public Bike(Vector3d vector3d, TriMesh triMesh, int n) {
    }

    public Bike(Properties properties, Vector3d vector3d, double d, double d2, double d3, CollisionStructure collisionStructure, int n, ParticleEffectsSystem particleEffectsSystem, BikeGameObject bikeGameObject) {
        this.gameObject = bikeGameObject;
        if (bikeGameObject != null) {
            this.eventManager = bikeGameObject.getEventManager();
        }
        this.props = properties;
        this.grid = collisionStructure;
        this.rearWheel = new BikeWheel("RearWheel");
        this.rearWheel.init(new Vector3d(vector3d.x + 30.0 * d, vector3d.y + 25.0 * d2, vector3d.z), true, 1.5, 51.0 * d3 * 0.5);
        this.rearWheel.setLockedZ(true);
        this.frontWheel = new BikeWheel("FrontWheel");
        this.frontWheel.init(new Vector3d(vector3d.x + 142.0 * d, vector3d.y + 26.0 * d2, vector3d.z), true, 1.5, 51.0 * d3 * 0.5);
        this.frontWheel.setLockedZ(true);
        Vector3d vector3d2 = this.rearWheel.getCenterOfMass(new Vector3d());
        Vector3d vector3d3 = this.frontWheel.getCenterOfMass(new Vector3d());
        this.axleDistance = vector3d3.subtractLocal(vector3d2).length();
        this.frame = new BikeFrame(vector3d, this.rearWheel.getWheelCenter(), this.frontWheel.getWheelCenter(), d, d2, 6.5);
        this.frame.setLockedZ(true);
        this.setLockedZ(true);
        this.rearWheel.setThrottleParticle(this.frame.getRearDamperAttachment());
        this.frontWheel.setThrottleParticle(this.frame.getForkHelper());
        this.boostForces = new Force[2];
        this.boostForces[0] = new Force(this.frame.getForkHelper(), new Vector3d(1.0, 0.0, 0.0), 0.0);
        this.boostForces[1] = new Force(this.frame.getHandlebar(), new Vector3d(1.0, 0.0, 0.0), 0.0);
        this.frame.addForce(this.boostForces[0]);
        this.frame.addForce(this.boostForces[1]);
        this.boostDirectionParticles = new Particle[2];
        this.boostDirectionParticles[0] = this.frame.getRearAxle();
        this.boostDirectionParticles[1] = this.frame.getFrontAxle();
        this.jumpForces = new Force[2];
        this.jumpForces[0] = new Force(this.frame.getHandlebar(), new Vector3d(1.0, 0.0, 0.0), 0.0);
        this.jumpForces[1] = new Force(this.frame.getRearDamperAttachment(), new Vector3d(1.0, 0.0, 0.0), 0.0);
        this.frame.addForce(this.jumpForces[0]);
        this.frame.addForce(this.jumpForces[1]);
        this.rider = new BikeRider(vector3d, 8.0, this.frame, d, d2);
        this.rider.setLockedZ(true);
        this.jetpackForces = new Force[2];
        this.jetpackForces[0] = new Force(this.rider.getLeftFoot(), new Vector3d(1.0, 0.0, 0.0), 0.0);
        this.jetpackForces[1] = new Force(this.rider.getRightFoot(), new Vector3d(1.0, 0.0, 0.0), 0.0);
        this.rider.addForce(this.jetpackForces[0]);
        this.rider.addForce(this.jetpackForces[1]);
        this.jetpackParticles = new Particle[4];
        this.jetpackParticles[0] = this.rider.getLeftFoot();
        this.jetpackParticles[1] = this.rider.getLeftKnee();
        this.jetpackParticles[2] = this.rider.getRightFoot();
        this.jetpackParticles[3] = this.rider.getRightKnee();
        this.addParticleObject(this.rearWheel);
        this.addParticleObject(this.frontWheel);
        this.addParticleObject(this.frame);
        this.addParticleObject(this.rider);
        this.saveInitialState();
        this.setZPosition(vector3d.z);
        if (collisionStructure != null) {
            this.rearWheelCollision = new ConstraintCollisionBikeWheel(this.rearWheel, collisionStructure);
            this.rearWheelCollision.setElasticity(0.8);
            if (bikeGameObject.isTurbo()) {
                this.rearWheelCollision.setFriction(450.0);
            } else {
                this.rearWheelCollision.setFriction(45.0);
            }
            this.frontWheelCollision = new ConstraintCollisionBikeWheel(this.frontWheel, collisionStructure);
            this.frontWheelCollision.setElasticity(0.8);
            if (bikeGameObject.isTurbo()) {
                this.frontWheelCollision.setFriction(25.0);
            } else {
                this.frontWheelCollision.setFriction(45.0);
            }
            this.callCrashOnCollisionWithRider = new Callable(){

                public Object call() {
                    Bike.this.crash(0.99999);
                    Bike.this.riderCollision.setCallOnCollision(null);
                    return null;
                }
            };
            this.riderCollision = new ConstraintCollisionParticles(this.rider.getParticles(), collisionStructure, this.callCrashOnCollisionWithRider);
            this.riderCollision.removeParticle(this.rider.getRightFoot());
            this.riderCollision.removeParticle(this.rider.getLeftFoot());
            this.riderCollision.setElasticity(0.5);
            this.riderCollision.setFriction(0.2);
            this.frameCollision = new ConstraintCollisionObject(this.frame, collisionStructure, null);
            this.frameCollision.setActive(false);
            this.frame.addConstraint(this.riderCollision);
            this.frame.addConstraint(this.frameCollision);
            this.frame.addConstraint(this.rearWheelCollision);
            this.frame.addConstraint(this.frontWheelCollision);
            Texture texture = null;
            try {
                texture = (Texture)ResourceManager.getInstance().load("texture", "dirtparticle_tiki", null);
            }
            catch (IOException iOException) {
                Logger.getLogger(Bike.class.getName()).severe("Could not load texture for dirt particles");
            }
            if (texture != null) {
                ParticleObjectEffectCollisionSpray particleObjectEffectCollisionSpray = new ParticleObjectEffectCollisionSpray(1000, texture);
                particleObjectEffectCollisionSpray.setEmitInterval(0.0014285714285714286);
                particleObjectEffectCollisionSpray.setLifeTime(0.6);
                particleObjectEffectCollisionSpray.setGravity(new Vector3d(0.0, -60.0, 0.0));
                particleEffectsSystem.addParticleObject(particleObjectEffectCollisionSpray);
                this.rearWheelCollision.setCollisionSpray(particleObjectEffectCollisionSpray);
                ConstraintCollisionObject constraintCollisionObject = new ConstraintCollisionObject(particleObjectEffectCollisionSpray, collisionStructure, null);
                constraintCollisionObject.setElasticity(0.6);
                particleObjectEffectCollisionSpray.addConstraint(constraintCollisionObject);
                this.frontWheelCollision.setCollisionSpray(particleObjectEffectCollisionSpray);
                this.frameCollision.setCollisionSpray(particleObjectEffectCollisionSpray);
                this.riderCollision.setCollisionSpray(particleObjectEffectCollisionSpray);
                this.riderCollision.setSpraySensitivity(1.0E-8);
            }
        }
    }

    private void throwRider() {
        if (!this.thrownRiderOff && !this.crashing) {
            this.thrownRiderOff = true;
            this.riderBeenThrownOffForTime = 0.0f;
            this.getRider().onViolentSpinning();
            this.riderCollision.addParticle(this.rider.getRightFoot());
            this.riderCollision.addParticle(this.rider.getLeftFoot());
            this.frameCollision.setActive(true);
        }
    }

    public void crash(double d) {
        if (!this.crashing) {
            this.crashedEvent.setArgument("gameObject", this.gameObject.getName());
            this.eventManager.fireEvent(this.crashedEvent);
            this.crashing = true;
            this.thrownRiderOff = false;
            this.riderBeenCrashingForTime = 0.0f;
            this.riderBeenLayingStillForTime = 0.0f;
            this.riderCollision.addParticle(this.rider.getRightFoot());
            this.riderCollision.addParticle(this.rider.getLeftFoot());
            this.frameCollision.setActive(true);
            this.rider.crash(d);
            this.frontWheel.crash(d - 1.0E-4);
            this.rearWheel.crash(d - 1.0E-4);
            this.frame.crash(d - 1.0E-4);
        }
    }

    public void reset(Vector3d vector3d) {
        this.reset(vector3d, false);
    }

    public void reset(Vector3d vector3d, boolean bl) {
        if (this.gameObject != null) {
            this.backOnBikeEvent.setArgument("gameObject", this.gameObject.getName());
            this.eventManager.fireEvent(this.backOnBikeEvent);
        }
        this.crashing = false;
        this.thrownRiderOff = false;
        this.riderBeenCrashingForTime = 0.0f;
        this.riderBeenLayingStillForTime = 0.0f;
        this.rearSuspensionBeenBrokenFor = 0.0f;
        this.frontSuspensionBeenBrokenFor = 0.0f;
        this.wheelLostForTime = 0.0f;
        this.wheelLost = false;
        if (this.riderCollision != null) {
            this.riderCollision.removeParticle(this.rider.getRightFoot());
            this.riderCollision.removeParticle(this.rider.getLeftFoot());
            this.riderCollision.setCallOnCollision(this.callCrashOnCollisionWithRider);
        }
        if (this.frameCollision != null) {
            this.frameCollision.setActive(false);
        }
        if (this.frontWheelCollision != null) {
            this.frontWheelCollision.setCallOnCollision(null);
        }
        if (this.rearWheelCollision != null) {
            this.rearWheelCollision.setCallOnCollision(null);
        }
        if (bl) {
            vector3d.z = this.curCenterOfMass.z;
        }
        this.resetToInitialState(vector3d);
        this.rider.reset();
        this.frontWheel.reset();
        this.rearWheel.reset();
        this.frame.reset();
        this.timeSinceLastReset = 0.0f;
    }

    private void loseRearWheel() {
        this.frame.loseRearWheel();
        this.wheelLost = true;
    }

    private void loseFrontWheel() {
        this.frame.loseFrontWheel();
        this.wheelLost = true;
    }

    public void releaseFeet() {
        this.rider.releaseFeet();
    }

    private void requestReset() {
        this.eventManager.fireEvent(requestResetEvent, new String[][]{{"gameObject"}, {this.gameObject.getName()}});
    }

    public void updateParticleSystemOnly(float f) {
        super.update(f);
    }

    public void update(float f) {
        this.timeSinceLastReset += f;
        this.getCenterOfMass(this.centerOfMass);
        this.doBoost();
        this.doJump();
        this.doJetpack();
        this.doGlide(f);
        super.update(f);
        if (this.frame.isRearSuspensionBroken()) {
            this.rearSuspensionBeenBrokenFor += f;
            if (this.rearSuspensionBeenBrokenFor > this.loseWheelsAfterTime) {
                this.loseRearWheel();
            }
        }
        if (this.frame.isFrontSuspensionBroken()) {
            this.frontSuspensionBeenBrokenFor += f;
            if (this.frontSuspensionBeenBrokenFor > this.loseWheelsAfterTime) {
                this.loseFrontWheel();
            }
        }
        if (this.wheelLost) {
            this.wheelLostForTime += f;
            if (this.wheelLostForTime > this.wheelLostTimeBeforeCrash) {
                Callable<Object> callable = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Bike.this.crash();
                        return null;
                    }
                };
                if (this.frontSuspensionBeenBrokenFor > 0.001f) {
                    this.frontWheelCollision.setCallOnCollision(callable);
                }
                if (this.rearSuspensionBeenBrokenFor > 0.001f) {
                    this.rearWheelCollision.setCallOnCollision(callable);
                }
            }
        }
        if (this.crashing) {
            this.lastCenterOfMass.set(this.curCenterOfMass);
            this.getRider().getCenterOfMass(this.curCenterOfMass);
            this.riderBeenCrashingForTime += f;
            if (this.riderBeenCrashingForTime > maxCrashTimeBeforeReset) {
                this.requestReset();
            } else if (this.curCenterOfMass.subtract(this.lastCenterOfMass).lengthSquared() < 5.0E-4) {
                this.riderBeenLayingStillForTime += f;
                if (this.riderBeenLayingStillForTime > timeToLieStillBeforeReset) {
                    this.requestReset();
                }
            } else {
                this.riderBeenLayingStillForTime = 0.0f;
            }
        }
        this.airborneForTime = !(this.riderCollision.isInContact() || this.frameCollision.isInContact() || this.frontWheelCollision.isInContact() || this.rearWheelCollision.isInContact()) ? (this.airborneForTime += f) : 0.0f;
        this.frontWheelInAirForTime = !this.frontWheelCollision.isInContact() && !this.particleNearGround(this.getFrontWheel().getWheelCenter(), this.getFrontWheel().getRadius() * 1.1) ? (this.frontWheelInAirForTime += f) : 0.0f;
        this.rearWheelInAirForTime = !this.rearWheelCollision.isInContact() && !this.particleNearGround(this.getRearWheel().getWheelCenter(), this.getRearWheel().getRadius() * 1.1) ? (this.rearWheelInAirForTime += f) : 0.0f;
        this.airbornePreviousFrame = this.airborne;
        this.airborne = this.airborneForTime > 0.2f;
        this.frontWheelInAirPreviousFrame = this.frontWheelInAir;
        this.frontWheelInAir = this.frontWheelInAirForTime > 0.2f;
        this.rearWheelInAirPreviousFrame = this.rearWheelInAir;
        boolean bl = this.rearWheelInAir = this.rearWheelInAirForTime > 0.2f;
        if (this.thrownRiderOff) {
            this.riderBeenThrownOffForTime += f;
            if (this.riderBeenThrownOffForTime > maxThrownOffTimeBeforeCrash) {
                this.crash();
            }
        }
        if (this.timeSinceLastReset > 1.0f && !this.thrownRiderOff) {
            double d;
            this.prevAngVel[this.prevAngVelIndex] = d = Math.abs(this.getFrame().getAngularVelocity());
            ++this.prevAngVelIndex;
            if (this.prevAngVelIndex >= this.prevAngVel.length) {
                this.prevAngVelIndex = 0;
            }
            this.angVelMean = this.angVelMean - this.prevAngVel[this.prevAngVelIndex] + d;
            double d2 = 0.16 * (double)this.prevAngVel.length;
            double d3 = -0.12 * (double)this.prevAngVel.length;
            if (this.angVelMean > d2 || this.angVelMean < d3) {
                this.throwRider();
            }
        }
    }

    private void crash() {
        this.crash(0.99999f);
    }

    private void doBoost() {
        if (this.boostMagnitude < (double)1.4E-45f) {
            this.boostMagnitude = 0.0;
            this.boostForces[0].setMagnitude(0.0);
            this.boostForces[1].setMagnitude(0.0);
            return;
        }
        this.boost0DistanceVec.set(this.boostForces[0].getTarget().position).subtractLocal(this.centerOfMass);
        this.boost1DistanceVec.set(this.boostForces[1].getTarget().position).subtractLocal(this.centerOfMass);
        this.boostDirection.set(this.boostDirectionParticles[1].position).subtractLocal(this.boostDirectionParticles[0].position);
        this.perpBoostDirection.set(this.boostDirection).crossLocal(Vector3d.UNIT_Z);
        double d = Math.abs(this.boost0DistanceVec.dot(this.perpBoostDirection));
        double d2 = Math.abs(this.boost1DistanceVec.dot(this.perpBoostDirection));
        double d3 = d + d2;
        this.boostForces[0].setDirection(this.boostDirection);
        this.boostForces[1].setDirection(this.boostDirection);
        this.boostForces[0].setMagnitude(this.boostMagnitude * (d2 / d3));
        this.boostForces[1].setMagnitude(this.boostMagnitude * (d / d3));
        this.boostMagnitude = 0.0;
    }

    private void doJetpack() {
        if (this.jetpackMagnitude < (double)1.4E-45f) {
            this.jetpackMagnitude = 0.0;
            this.jetpackForces[0].setMagnitude(0.0);
            this.jetpackForces[1].setMagnitude(0.0);
            return;
        }
        this.jetpackDirection0.set(this.jetpackParticles[1].position).subtractLocal(this.jetpackParticles[0].position);
        this.jetpackDirection1.set(this.jetpackParticles[3].position).subtractLocal(this.jetpackParticles[2].position);
        this.jetpackForces[0].setDirection(this.jetpackDirection0);
        this.jetpackForces[0].setMagnitude(this.jetpackMagnitude * 0.5);
        this.jetpackForces[1].setDirection(this.jetpackDirection1);
        this.jetpackForces[1].setMagnitude(this.jetpackMagnitude * 0.5);
        this.jetpackMagnitude = 0.0;
    }

    private void doJump() {
        if (this.jumpMagnitude < (double)1.4E-45f) {
            this.jumpMagnitude = 0.0;
            this.jumpForces[0].setMagnitude(0.0);
            this.jumpForces[1].setMagnitude(0.0);
            return;
        }
        this.boost0DistanceVec.set(this.jumpForces[0].getTarget().position).subtractLocal(this.centerOfMass);
        this.boost1DistanceVec.set(this.jumpForces[1].getTarget().position).subtractLocal(this.centerOfMass);
        this.boostDirection.set(this.boostDirectionParticles[1].position).subtractLocal(this.boostDirectionParticles[0].position);
        this.boostDirection.crossLocal(Vector3d.UNIT_Z).multLocal(-1.0);
        this.perpBoostDirection.set(this.boostDirection).crossLocal(Vector3d.UNIT_Z);
        double d = Math.abs(this.boost0DistanceVec.dot(this.perpBoostDirection));
        double d2 = Math.abs(this.boost1DistanceVec.dot(this.perpBoostDirection));
        double d3 = d + d2;
        this.jumpForces[0].setDirection(this.boostDirection);
        this.jumpForces[1].setDirection(this.boostDirection);
        this.jumpForces[0].setMagnitude(this.jumpMagnitude * (d2 / d3));
        this.jumpForces[1].setMagnitude(this.jumpMagnitude * (d / d3));
        this.jumpMagnitude = 0.0;
    }

    private void doGlide(float f) {
        double d;
        double d2;
        if (!this.gliding) {
            return;
        }
        this.airborneAndGlidingForTime = this.isAirborne() ? (this.airborneAndGlidingForTime += f) : 0.0f;
        this.gliding = false;
        this.horizontalVec.set(this.frame.getFork().position).subtractLocal(this.frame.getRearDamperAnchor().position).normalizeLocal();
        this.upVec.set(Vector3d.UNIT_Z).crossLocal(this.horizontalVec);
        double d3 = 0.5;
        double d4 = this.horizontalVelocity.set(this.horizontalVec).dot(this.frame.getVelocity());
        if (this.airborneAndGlidingForTime < 2.0f) {
            d2 = d4 * d4 * (double)0.4f * d3;
            d = this.frame.getVelocity().lengthSquared() * (double)0.1f * d3;
        } else {
            d2 = d4 * d4 * (double)0.4f * d3;
            d = this.frame.getVelocity().lengthSquared() * (double)0.15f * d3;
        }
        if (this.frame.getFork().position.y > 30.0) {
            d2 *= 1.0 - (double)0.07f * (this.frame.getFork().position.y - 30.0);
        }
        this.boost0DistanceVec.set(this.jumpForces[0].getTarget().position).subtractLocal(this.centerOfMass);
        this.boost1DistanceVec.set(this.jumpForces[1].getTarget().position).subtractLocal(this.centerOfMass);
        this.boostDirection.set(this.upVec);
        this.perpBoostDirection.set(this.boostDirection).crossLocal(Vector3d.UNIT_Z);
        double d5 = Math.abs(this.boost0DistanceVec.dot(this.perpBoostDirection));
        double d6 = Math.abs(this.boost1DistanceVec.dot(this.perpBoostDirection));
        double d7 = d5 + d6;
        this.jumpForces[0].setDirection(this.upVec);
        this.jumpForces[1].setDirection(this.upVec);
        this.jumpForces[0].setMagnitude(this.jumpForces[0].getMagnitude() + d2 * (d6 / d7));
        this.jumpForces[1].setMagnitude(this.jumpForces[1].getMagnitude() + d2 * (d5 / d7));
        this.boost0DistanceVec.set(this.boostForces[0].getTarget().position).subtractLocal(this.centerOfMass);
        this.boost1DistanceVec.set(this.boostForces[1].getTarget().position).subtractLocal(this.centerOfMass);
        this.boostDirection.set(this.frame.getVelocity());
        this.boostDirection.multLocal(-1.0);
        this.perpBoostDirection.set(this.boostDirection).crossLocal(Vector3d.UNIT_Z);
        d5 = Math.abs(this.boost0DistanceVec.dot(this.perpBoostDirection));
        d6 = Math.abs(this.boost1DistanceVec.dot(this.perpBoostDirection));
        d7 = d5 + d6;
        this.boostForces[0].setDirection(this.boostDirection);
        this.boostForces[1].setDirection(this.boostDirection);
        this.boostForces[0].setMagnitude(d * (d6 / d7));
        this.boostForces[1].setMagnitude(d * (d5 / d7));
    }

    private boolean particleNearGround(Particle particle, double d) {
        this.tempVec.set(particle.position);
        this.tempVec.y -= d;
        return this.grid.intersectSegment(particle.position, this.tempVec, this.dummyResult);
    }

    public void setBoostMagnitude(double d) {
        if (d > this.boostMagnitude) {
            this.boostMagnitude = d;
        }
    }

    public void setJumpMagnitude(double d) {
        if (d > this.jumpMagnitude) {
            this.jumpMagnitude = d;
        }
    }

    public BikeFrame getFrame() {
        return this.frame;
    }

    public void setFrame(BikeFrame bikeFrame) {
        this.frame = bikeFrame;
    }

    public BikeWheel getFrontWheel() {
        return this.frontWheel;
    }

    public void setFrontWheel(BikeWheel bikeWheel) {
        this.frontWheel = bikeWheel;
    }

    public BikeWheel getRearWheel() {
        return this.rearWheel;
    }

    public void setRearWheel(BikeWheel bikeWheel) {
        this.rearWheel = bikeWheel;
    }

    public TriMesh getCollisionMesh() {
        return this.collisionMesh;
    }

    public void setCollisionMesh(TriMesh triMesh) {
        this.collisionMesh = triMesh;
    }

    public double getZPosition() {
        return this.zPosition;
    }

    public void setZPosition(double d) {
        this.zPosition = d;
        this.rearWheel.setLockedZvalue(this.zPosition);
        this.frontWheel.setLockedZvalue(this.zPosition);
        this.frame.setLockedZvalue(this.zPosition);
    }

    public BikeRider getRider() {
        return this.rider;
    }

    public void setRider(BikeRider bikeRider) {
        this.rider = bikeRider;
    }

    public boolean isAirborne() {
        return this.airborne;
    }

    public ConstraintCollisionParticles getRiderCollision() {
        return this.riderCollision;
    }

    public boolean isCrashing() {
        return this.crashing;
    }

    public float getAirborneForTime() {
        return this.airborneForTime;
    }

    public float getRiderBeenCrashingForTime() {
        return this.riderBeenCrashingForTime;
    }

    public float getRiderBeenLayingStillForTime() {
        return this.riderBeenLayingStillForTime;
    }

    public float getTimeSinceLastReset() {
        return this.timeSinceLastReset;
    }

    public boolean isThrownRiderOff() {
        return this.thrownRiderOff;
    }

    public float getRiderBeenThrownOffForTime() {
        return this.riderBeenThrownOffForTime;
    }

    public boolean wasAirbornePreviousFrame() {
        return this.airbornePreviousFrame;
    }

    public boolean isFrontWheelInAir() {
        return this.frontWheelInAir;
    }

    public boolean wasFrontWheelInAirPreviousFrame() {
        return this.frontWheelInAirPreviousFrame;
    }

    public boolean isRearWheelInAir() {
        return this.rearWheelInAir;
    }

    public boolean wasRearWheelInAirPreviousFrame() {
        return this.rearWheelInAirPreviousFrame;
    }

    public double getAxleDistance() {
        return this.axleDistance;
    }

    public void setGliding(boolean bl) {
        this.gliding = bl;
    }

    public double getJetpackMagnitude() {
        return this.jetpackMagnitude;
    }

    public void setJetpackMagnitude(double d) {
        this.jetpackMagnitude = d;
    }

    public ConstraintCollisionObject getRearWheelCollision() {
        return this.rearWheelCollision;
    }

    public ConstraintCollisionObject getFrontWheelCollision() {
        return this.frontWheelCollision;
    }
}

