/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.physics.collision;

import com.turborilla.msm.physics.collision.ConstraintCollisionObject;
import com.turborilla.physics.collision.CollisionStructure;
import com.turborilla.physics.particle.Particle;
import java.util.ArrayList;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintCollisionParticles
extends ConstraintCollisionObject {
    private ArrayList<Particle> particles;

    public ConstraintCollisionParticles(CollisionStructure collisionStructure, Callable callable) {
        super(collisionStructure, callable);
    }

    public ConstraintCollisionParticles(ArrayList<Particle> arrayList, CollisionStructure collisionStructure, Callable callable) {
        this(collisionStructure, callable);
        this.particles = new ArrayList<Particle>(arrayList);
    }

    public void addParticle(Particle particle) {
        if (this.particles == null) {
            this.particles = new ArrayList();
        }
        this.particles.add(particle);
    }

    public boolean removeParticle(Particle particle) {
        if (this.particles == null) {
            return false;
        }
        return this.particles.remove(particle);
    }

    public ArrayList<Particle> getParticles() {
        return this.particles;
    }

    @Override
    protected boolean checkCollisionsAndRespond(double d) {
        boolean bl = false;
        if (this.particles != null) {
            for (int i = 0; i < this.particles.size(); ++i) {
                Particle particle = this.particles.get(i);
                if (!particle.alive || !this.grid.intersectSegment(particle.oldPosition, particle.position, this.result)) continue;
                bl = true;
                this.respond(particle, this.result, d);
            }
        }
        return bl;
    }
}

