/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.physics.collision;

import com.turborilla.msm.physics.collision.ParticleObjectEffectCollisionSpray;
import com.turborilla.physics.collision.CollisionStructure;
import com.turborilla.physics.collision.IntersectionResult;
import com.turborilla.physics.collision.Plane;
import com.turborilla.physics.particle.IConstraint;
import com.turborilla.physics.particle.Particle;
import com.turborilla.physics.particle.ParticleObject;
import com.turborilla.physics.particle.ParticleObjectEffect;
import com.turborilla.utils.math.Vector3d;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class ConstraintCollisionObject
implements IConstraint {
    protected ParticleObject po;
    protected CollisionStructure grid;
    protected IntersectionResult result;
    protected Callable callOnCollision;
    protected boolean inContact = false;
    protected ParticleObjectEffectCollisionSpray collisionSpray = null;
    protected double spraySensitivity = 3.0E-6;
    protected Vector3d normal;
    protected Vector3d normalSegmentQ;
    protected Vector3d collisionPoint = new Vector3d();
    protected Vector3d vel = new Vector3d();
    protected Vector3d nvel = new Vector3d();
    protected Vector3d tvel = new Vector3d();
    protected Vector3d newnvel = new Vector3d();
    protected Vector3d newtvel = new Vector3d();
    protected Vector3d gravity = new Vector3d(0.0, -9.82, 0.0);
    protected Vector3d sprayBase = new Vector3d();
    protected Vector3d sprayTowards = new Vector3d();
    protected double elasticity = 1.0;
    protected double friction = 1.0;
    private boolean active = true;

    public ConstraintCollisionObject(ParticleObject particleObject, CollisionStructure collisionStructure) {
        this.po = particleObject;
        this.grid = collisionStructure;
        this.normal = new Vector3d();
        this.normalSegmentQ = new Vector3d();
        this.result = new IntersectionResult();
        this.callOnCollision = null;
    }

    public ConstraintCollisionObject(ParticleObject particleObject, CollisionStructure collisionStructure, double d, double d2) {
        this(particleObject, collisionStructure);
        this.elasticity = d;
        this.friction = d2;
    }

    protected ConstraintCollisionObject(CollisionStructure collisionStructure) {
        this(null, collisionStructure);
    }

    protected ConstraintCollisionObject(CollisionStructure collisionStructure, Callable callable) {
        this(null, collisionStructure, callable);
    }

    public ConstraintCollisionObject(ParticleObject particleObject, CollisionStructure collisionStructure, Callable callable) {
        this(particleObject, collisionStructure);
        this.callOnCollision = callable;
    }

    public void satisfy(double d) {
        if (!this.active) {
            return;
        }
        this.inContact = this.checkCollisionsAndRespond(d);
        if (this.inContact && this.callOnCollision != null) {
            try {
                this.callOnCollision.call();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected boolean checkCollisionsAndRespond(double d) {
        boolean bl = false;
        if (this.po != null) {
            ArrayList<Particle> arrayList = this.po.getParticles();
            for (int i = 0; i < arrayList.size(); ++i) {
                Particle particle = arrayList.get(i);
                if (!particle.alive || !this.grid.intersectSegment(particle.oldPosition, particle.position, this.result)) continue;
                bl = true;
                this.respond(particle, this.result, d);
            }
        }
        return bl;
    }

    protected void respond(Particle particle, IntersectionResult intersectionResult, double d) {
        this.vel.set(particle.position).subtractLocal(particle.oldPosition);
        double d2 = this.friction;
        boolean bl = false;
        this.normal.set(intersectionResult.normal);
        this.normal.z = 0.0;
        this.normal.normalizeLocal();
        this.nvel.set(this.normal).multLocal(this.vel.dot(this.normal));
        this.tvel.set(this.vel).subtractLocal(this.nvel);
        if (this.tvel.lengthSquared() < 5.0 * d * d) {
            d2 = this.friction * 1.5;
        }
        this.newnvel.set(this.nvel).multLocal(-this.elasticity);
        double d3 = this.nvel.length();
        double d4 = (d3 * particle.getWeight() - particle.getWeight() * this.gravity.dot(this.normal) * 0.3) * d2 * 0.001;
        double d5 = this.tvel.length();
        if (d4 > 0.0) {
            if (d5 > d4) {
                this.newtvel.set(this.tvel).multLocal((d5 - d4) / d5);
            } else {
                bl = true;
            }
        } else {
            this.newtvel.set(this.tvel);
        }
        boolean bl2 = true;
        this.normalSegmentQ.set(particle.position).addLocal(this.normal);
        if (!intersectionResult.collisionPrimitive.intersectSegment(this.normalSegmentQ, particle.position, intersectionResult)) {
            bl2 = false;
        }
        if (bl2) {
            particle.position.addLocal(this.normal.multLocal(1.001 - intersectionResult.t));
        } else {
            particle.position.set(particle.oldPosition);
            particle.position.addLocal(this.newnvel);
        }
        if (!bl) {
            particle.oldPosition.set(particle.position).subtractLocal(this.newnvel).subtractLocal(this.newtvel);
        } else {
            particle.oldPosition.set(particle.position).subtractLocal(this.newnvel);
        }
        if (this.collisionSpray != null && this.tvel.lengthSquared() > this.spraySensitivity) {
            this.collisionSpray.collided(this.sprayBase.set(particle.oldPosition), this.sprayTowards.set(particle.position).subtractLocal(this.nvel).subtractLocal(this.nvel), d5 * 9.0);
        }
    }

    protected Vector3d closestPointOnPlane(Vector3d vector3d, Plane plane) {
        double d = (plane.normal.dot(vector3d) - plane.d) / plane.normal.dot(plane.normal);
        return vector3d.subtract(plane.normal.mult(d));
    }

    public void setElasticity(double d) {
        this.elasticity = d;
    }

    public double getElasticity() {
        return this.elasticity;
    }

    public void setActive(boolean bl) {
        this.active = bl;
        if (!bl) {
            this.inContact = false;
        }
    }

    public boolean getActive() {
        return this.active;
    }

    public double getFriction() {
        return this.friction;
    }

    public void setFriction(double d) {
        this.friction = d;
    }

    public boolean isInContact() {
        return this.inContact;
    }

    public Callable getCallOnCollision() {
        return this.callOnCollision;
    }

    public void setCallOnCollision(Callable callable) {
        this.callOnCollision = callable;
    }

    public ParticleObjectEffect getCollisionSpray() {
        return this.collisionSpray;
    }

    public void setCollisionSpray(ParticleObjectEffectCollisionSpray particleObjectEffectCollisionSpray) {
        this.collisionSpray = particleObjectEffectCollisionSpray;
    }

    public double getSpraySensitivity() {
        return this.spraySensitivity;
    }

    public void setSpraySensitivity(double d) {
        this.spraySensitivity = d;
    }
}

