/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.physics.collision;

import com.turborilla.msm.physics.collision.ConstraintCollisionObject;
import com.turborilla.msm.physics.objects.BikeWheel;
import com.turborilla.physics.collision.CollisionStructure;
import com.turborilla.physics.particle.Particle;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class ConstraintCollisionBikeWheel
extends ConstraintCollisionObject {
    Particle wheelCenter;

    public ConstraintCollisionBikeWheel(BikeWheel bikeWheel, CollisionStructure collisionStructure) {
        super(bikeWheel, collisionStructure);
        this.wheelCenter = bikeWheel.getWheelCenter();
    }

    public ConstraintCollisionBikeWheel(BikeWheel bikeWheel, CollisionStructure collisionStructure, double d, double d2) {
        super(bikeWheel, collisionStructure);
        this.wheelCenter = bikeWheel.getWheelCenter();
        this.elasticity = d;
        this.friction = d2;
    }

    public ConstraintCollisionBikeWheel(BikeWheel bikeWheel, CollisionStructure collisionStructure, Callable callable) {
        super(bikeWheel, collisionStructure, callable);
        this.wheelCenter = bikeWheel.getWheelCenter();
    }

    protected boolean checkCollisionsAndRespond(double d) {
        boolean bl = false;
        if (this.po != null) {
            ArrayList<Particle> arrayList = this.po.getParticles();
            for (int i = 0; i < arrayList.size(); ++i) {
                Particle particle = arrayList.get(i);
                if (particle == this.wheelCenter || !this.grid.intersectSegment(this.wheelCenter.position, particle.position, this.result)) continue;
                bl = true;
                this.respond(particle, this.result, d);
            }
        }
        return bl;
    }
}

