/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.physics.collision;

import com.jme.math.Vector3f;
import com.jme.scene.TriMesh;
import com.jme.util.geom.BufferUtils;
import com.turborilla.SpatialTransformationProvider;
import com.turborilla.physics.collision.AbstractCollisionStructure;
import com.turborilla.physics.collision.IntersectionResult;
import com.turborilla.physics.collision.Plane;
import com.turborilla.physics.collision.Triangle;
import com.turborilla.utils.math.BoundingBox;
import com.turborilla.utils.math.Vector3d;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollisionGrid
extends AbstractCollisionStructure {
    protected TriMesh mesh;
    protected Triangle[] triangles;
    private Cell[][] cells;
    private int cellRows = 0;
    private int cellCols = 0;
    private double cellRowSize;
    private double cellColSize;
    private double invCellRowSize;
    private double invCellColSize;
    private double meshMaxY;
    private double meshMinY;
    private double meshMaxX;
    private double meshMinX;
    private double meshMaxZ;
    private double meshMinZ;
    private Vector3d boxMin;
    private Vector3d boxMax;
    BoundingBox AABB;
    int a00 = 0;
    int a01 = 0;
    int a02 = 0;
    int a10 = 0;
    int a11 = 0;
    int a12 = 0;
    int a20 = 0;
    int a21 = 0;
    int a22 = 0;
    int fn1 = 0;
    int fn2 = 0;
    int fn3 = 0;
    int tn = 0;
    Vector3d v0;
    Vector3d v1;
    Vector3d v2;
    Vector3d f0;
    Vector3d f1;
    Vector3d f2;
    Vector3d boxCenter;

    public CollisionGrid() {
    }

    public CollisionGrid(TriMesh triMesh, int n, int n2) {
        this.init(triMesh, n, n2);
    }

    public void init(TriMesh triMesh, int n, int n2) {
        Object object;
        Object object2;
        this.mesh = triMesh;
        this.setTransformationProvider(new SpatialTransformationProvider(triMesh));
        triMesh.updateGeometricState(0.0f, true);
        this.AABB = new BoundingBox();
        this.v0 = new Vector3d();
        this.v1 = new Vector3d();
        this.v2 = new Vector3d();
        this.f0 = new Vector3d();
        this.f1 = new Vector3d();
        this.f2 = new Vector3d();
        this.boxMin = new Vector3d();
        this.boxMax = new Vector3d();
        this.cellRows = n;
        this.cellCols = n2;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < triMesh.getBatchCount(); ++i) {
            n3 += triMesh.getBatch(i).getTriangleCount();
            n4 += triMesh.getBatch(i).getVertexCount();
        }
        this.triangles = new Triangle[n3];
        FloatBuffer floatBuffer = BufferUtils.createVector3Buffer(n4);
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n3 * 3);
        floatBuffer.rewind();
        intBuffer.rewind();
        for (int i = 0; i < triMesh.getBatchCount(); ++i) {
            object2 = triMesh.getBatch(i).getVertexBuffer();
            object = triMesh.getBatch(i).getIndexBuffer();
            ((FloatBuffer)object2).rewind();
            ((IntBuffer)object).rewind();
            int n5 = floatBuffer.position() / 3;
            for (int j = 0; j < ((Buffer)object).limit(); ++j) {
                intBuffer.put(((IntBuffer)object).get() + n5);
            }
            floatBuffer.put((FloatBuffer)object2);
        }
        floatBuffer.rewind();
        intBuffer.rewind();
        float[] fArray = new float[3];
        floatBuffer.get(fArray);
        this.meshMaxX = this.meshMinX = (double)fArray[0];
        this.meshMaxY = this.meshMinY = (double)fArray[1];
        this.meshMaxZ = this.meshMinZ = (double)fArray[2];
        while (floatBuffer.remaining() >= 3) {
            floatBuffer.get(fArray);
            if ((double)fArray[0] > this.meshMaxX) {
                this.meshMaxX = fArray[0];
            }
            if ((double)fArray[0] < this.meshMinX) {
                this.meshMinX = fArray[0];
            }
            if ((double)fArray[1] > this.meshMaxY) {
                this.meshMaxY = fArray[1];
            }
            if ((double)fArray[1] < this.meshMinY) {
                this.meshMinY = fArray[1];
            }
            if ((double)fArray[2] > this.meshMaxZ) {
                this.meshMaxZ = fArray[2];
            }
            if (!((double)fArray[2] < this.meshMinZ)) continue;
            this.meshMinZ = fArray[2];
        }
        floatBuffer.rewind();
        this.cellRowSize = (this.meshMaxZ - this.meshMinZ) / (double)(this.cellRows - 1);
        this.cellColSize = (this.meshMaxX - this.meshMinX) / (double)(this.cellCols - 1);
        this.invCellRowSize = 1.0 / this.cellRowSize;
        this.invCellColSize = 1.0 / this.cellColSize;
        this.cells = new Cell[this.cellRows][this.cellCols];
        object2 = new Vector3d();
        object = new Vector3d();
        Vector3d vector3d = new Vector3d();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        int[] nArray = new int[3];
        int n6 = -1;
        int n7 = 10000000;
        int n8 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(9);
        for (int i = 0; i < this.triangles.length; ++i) {
            int n9;
            intBuffer.get(nArray);
            BufferUtils.populateFromBuffer(vector3f, floatBuffer, nArray[0]);
            BufferUtils.populateFromBuffer(vector3f2, floatBuffer, nArray[1]);
            BufferUtils.populateFromBuffer(vector3f3, floatBuffer, nArray[2]);
            this.triangles[i] = new Triangle(((Vector3d)object2).set(vector3f), ((Vector3d)object).set(vector3f2), vector3d.set(vector3f3));
            arrayList.clear();
            int n10 = (int)(((Vector3d)object2).z * this.invCellRowSize);
            int n11 = (int)(((Vector3d)object2).x * this.invCellColSize);
            if (n10 >= this.cellRows) {
                n10 = this.cellRows - 1;
            }
            if (n11 >= this.cellCols) {
                n11 = this.cellCols - 1;
            }
            if ((n9 = this.testTriangleAndAddToCell((Vector3d)object2, (Vector3d)object, vector3d, this.triangles[i], n10, n11, arrayList)) == 0) {
                ++n8;
            }
            if (n9 > n6) {
                n6 = n9;
            }
            if (n9 >= n7) continue;
            n7 = n9;
        }
    }

    private int testTriangleAndAddToCell(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Triangle triangle, int n, int n2, ArrayList<Integer> arrayList) {
        BoundingBox boundingBox;
        int n3 = n * this.cellCols + n2;
        if (n < 0 || n2 < 0 || n >= this.cellRows || n2 >= this.cellCols) {
            return 0;
        }
        if (arrayList.contains(n3)) {
            return 0;
        }
        arrayList.add(n3);
        this.boxMin.set((double)n2 * this.cellColSize, this.meshMinY, (double)n * this.cellRowSize);
        this.boxMax.set(this.boxMin.x + this.cellColSize, this.meshMaxY, this.boxMin.z + this.cellRowSize);
        if (this.cells[n][n2] == null) {
            boundingBox = new BoundingBox();
            boundingBox.setCenter(this.boxMin.add(this.boxMax).multLocal(0.5));
            boundingBox.xExtent = (this.boxMax.x - this.boxMin.x) * 0.5;
            boundingBox.yExtent = (this.boxMax.y - this.boxMin.y) * 0.5;
            boundingBox.zExtent = (this.boxMax.z - this.boxMin.z) * 0.5;
        } else {
            boundingBox = this.cells[n][n2].AABB;
        }
        if (this.testTriangleAABB(vector3d, vector3d2, vector3d3, boundingBox)) {
            int n4 = 1;
            if (this.cells[n][n2] == null) {
                this.cells[n][n2] = new Cell(boundingBox);
            }
            this.cells[n][n2].addTriangle(triangle);
            n4 += this.testTriangleAndAddToCell(vector3d, vector3d2, vector3d3, triangle, n - 1, n2 - 1, arrayList);
            n4 += this.testTriangleAndAddToCell(vector3d, vector3d2, vector3d3, triangle, n - 1, n2, arrayList);
            n4 += this.testTriangleAndAddToCell(vector3d, vector3d2, vector3d3, triangle, n - 1, n2 + 1, arrayList);
            n4 += this.testTriangleAndAddToCell(vector3d, vector3d2, vector3d3, triangle, n, n2 - 1, arrayList);
            n4 += this.testTriangleAndAddToCell(vector3d, vector3d2, vector3d3, triangle, n, n2 + 1, arrayList);
            n4 += this.testTriangleAndAddToCell(vector3d, vector3d2, vector3d3, triangle, n + 1, n2 - 1, arrayList);
            n4 += this.testTriangleAndAddToCell(vector3d, vector3d2, vector3d3, triangle, n + 1, n2, arrayList);
            return n4 += this.testTriangleAndAddToCell(vector3d, vector3d2, vector3d3, triangle, n + 1, n2 + 1, arrayList);
        }
        return 0;
    }

    @Override
    public boolean intersectSegmentLocal(Vector3d vector3d, Vector3d vector3d2, IntersectionResult intersectionResult) {
        int n = (int)(vector3d2.z * this.invCellRowSize);
        int n2 = (int)(vector3d2.x * this.invCellColSize);
        Cell cell = null;
        if (n < this.cellRows && n >= 0) {
            if (n2 < this.cellCols && n2 >= 0) {
                cell = this.cells[n][n2];
            }
            if (cell != null && cell.intersectSegment(vector3d, vector3d2, intersectionResult)) {
                return true;
            }
            int n3 = (int)(vector3d.x * this.invCellColSize);
            if (n3 != n2 && n3 < this.cellCols && n3 >= 0 && (cell = this.cells[n][n3]) != null && cell.intersectSegment(vector3d, vector3d2, intersectionResult)) {
                return true;
            }
        }
        return false;
    }

    public boolean intersectSegmentLongRay(Vector3d vector3d, Vector3d vector3d2, IntersectionResult intersectionResult) {
        Object var7_4 = null;
        for (Triangle triangle : this.triangles) {
            if (!triangle.intersectSegment(vector3d, vector3d2, intersectionResult)) continue;
            intersectionResult.collisionPrimitive = triangle;
            return true;
        }
        return false;
    }

    private boolean testTriangleAABB(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4, Vector3d vector3d5) {
        this.AABB.setCenter(vector3d4.add(vector3d5).multLocal(0.5));
        this.AABB.xExtent = (vector3d5.x - vector3d4.x) * 0.5;
        this.AABB.yExtent = (vector3d5.y - vector3d4.y) * 0.5;
        this.AABB.zExtent = (vector3d5.z - vector3d4.z) * 0.5;
        return this.testTriangleAABB(vector3d, vector3d2, vector3d3, this.AABB);
    }

    private boolean testTriangleAABB(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, BoundingBox boundingBox) {
        this.boxCenter = new Vector3d(boundingBox.getCenter());
        this.v0.set(vector3d).subtractLocal(this.boxCenter);
        this.v1.set(vector3d2).subtractLocal(this.boxCenter);
        this.v2.set(vector3d3).subtractLocal(this.boxCenter);
        double d = boundingBox.xExtent;
        double d2 = boundingBox.yExtent;
        double d3 = boundingBox.zExtent;
        this.f0.set(this.v1).subtractLocal(this.v0);
        this.f1.set(this.v2).subtractLocal(this.v1);
        this.f2.set(this.v0).subtractLocal(this.v2);
        double d4 = this.v0.z * this.v1.y - this.v0.y * this.v1.z;
        double d5 = this.v2.z * (this.v1.y - this.v0.y) - this.v2.y * (this.v1.z - this.v0.z);
        double d6 = d2 * Math.abs(this.f0.z) + d3 * Math.abs(this.f0.y);
        if (Math.max(-Math.max(d4, d5), Math.min(d4, d5)) > d6) {
            ++this.a00;
            return false;
        }
        double d7 = this.v1.z * this.v2.y - this.v1.y * this.v2.z;
        d4 = this.v0.z * (this.v2.y - this.v1.y) - this.v0.y * (this.v2.z - this.v1.z);
        d6 = d2 * Math.abs(this.f1.z) + d3 * Math.abs(this.f1.y);
        if (Math.max(-Math.max(d4, d7), Math.min(d4, d7)) > d6) {
            ++this.a01;
            return false;
        }
        d4 = this.v0.y * this.v2.z - this.v0.z * this.v2.y;
        d7 = this.v1.z * (this.v0.y - this.v2.y) - this.v1.y * (this.v0.z - this.v2.z);
        d6 = d2 * Math.abs(this.f2.z) + d3 * Math.abs(this.f2.y);
        if (Math.max(-Math.max(d4, d7), Math.min(d4, d7)) > d6) {
            ++this.a02;
            return false;
        }
        d4 = this.v0.x * this.v1.z - this.v0.z * this.v1.x;
        d5 = this.v2.x * (this.v1.z - this.v0.z) - this.v2.z * (this.v1.x - this.v0.x);
        d6 = d * Math.abs(this.f0.z) + d3 * Math.abs(this.f0.x);
        if (Math.max(-Math.max(d4, d5), Math.min(d4, d5)) > d6) {
            ++this.a10;
            return false;
        }
        d7 = this.v1.x * this.v2.z - this.v1.z * this.v2.x;
        d4 = this.v0.x * (this.v2.z - this.v1.z) - this.v0.z * (this.v2.x - this.v1.x);
        d6 = d * Math.abs(this.f1.z) + d3 * Math.abs(this.f1.x);
        if (Math.max(-Math.max(d4, d7), Math.min(d4, d7)) > d6) {
            ++this.a11;
            return false;
        }
        d4 = this.v0.z * this.v2.x - this.v0.x * this.v2.z;
        d7 = this.v1.x * (this.v0.z - this.v2.z) - this.v1.z * (this.v0.x - this.v2.x);
        d6 = d * Math.abs(this.f2.z) + d3 * Math.abs(this.f2.x);
        if (Math.max(-Math.max(d4, d7), Math.min(d4, d7)) > d6) {
            ++this.a12;
            return false;
        }
        d4 = this.v0.y * this.v1.x - this.v0.x * this.v1.y;
        d5 = this.v2.y * (this.v1.x - this.v0.x) - this.v2.x * (this.v1.y - this.v0.y);
        d6 = d * Math.abs(this.f0.y) + d2 * Math.abs(this.f0.x);
        if (Math.max(-Math.max(d4, d5), Math.min(d4, d5)) > d6) {
            ++this.a20;
            return false;
        }
        d7 = this.v1.y * this.v2.x - this.v1.x * this.v2.y;
        d4 = this.v0.y * (this.v2.x - this.v1.x) - this.v0.x * (this.v2.y - this.v1.y);
        d6 = d * Math.abs(this.f1.y) + d2 * Math.abs(this.f1.x);
        if (Math.max(-Math.max(d4, d7), Math.min(d4, d7)) > d6) {
            ++this.a21;
            return false;
        }
        d4 = this.v0.x * this.v2.y - this.v0.y * this.v2.x;
        d7 = this.v1.y * (this.v0.x - this.v2.x) - this.v1.x * (this.v0.y - this.v2.y);
        d6 = d * Math.abs(this.f2.y) + d2 * Math.abs(this.f2.x);
        if (Math.max(-Math.max(d4, d7), Math.min(d4, d7)) > d6) {
            ++this.a22;
            return false;
        }
        if (Math.max(Math.max(this.v0.x, this.v1.x), this.v2.x) < -d || Math.min(Math.min(this.v0.x, this.v1.x), this.v2.x) > d) {
            ++this.fn1;
            return false;
        }
        if (Math.max(Math.max(this.v0.y, this.v1.y), this.v2.y) < -d2 || Math.min(Math.min(this.v0.y, this.v1.y), this.v2.y) > d2) {
            ++this.fn2;
            return false;
        }
        if (Math.max(Math.max(this.v0.z, this.v1.z), this.v2.z) < -d3 || Math.min(Math.min(this.v0.z, this.v1.z), this.v2.z) > d3) {
            ++this.fn3;
            return false;
        }
        Plane plane = new Plane(this.f0.crossLocal(this.f1), vector3d);
        if (plane.intersectAABB(boundingBox)) {
            return true;
        }
        ++this.tn;
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Cell {
        private ArrayList<Triangle> triangles = new ArrayList();
        private BoundingBox AABB;

        public Cell() {
            this(null);
        }

        public Cell(BoundingBox boundingBox) {
            this.AABB = boundingBox;
        }

        public void addTriangle(Triangle triangle) {
            this.triangles.add(triangle);
        }

        public Collection<Triangle> getTriangles() {
            return this.triangles;
        }

        public boolean intersectSegment(Vector3d vector3d, Vector3d vector3d2, IntersectionResult intersectionResult) {
            for (int i = 0; i < this.triangles.size(); ++i) {
                Triangle triangle = this.triangles.get(i);
                if (!triangle.intersectSegment(vector3d, vector3d2, intersectionResult)) continue;
                intersectionResult.collisionPrimitive = triangle;
                return true;
            }
            return false;
        }
    }
}

