/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.physics.collision;

import com.jme.math.Vector3f;
import com.turborilla.physics.collision.AbstractCollisionStructure;
import com.turborilla.physics.collision.CollisionPrimitive;
import com.turborilla.physics.collision.IntersectionResult;
import com.turborilla.physics.collision.Plane;
import com.turborilla.terrain.ImageHeightMap;
import com.turborilla.utils.math.Vector3d;

public class Collision1DHeightMap
extends AbstractCollisionStructure {
    protected ImageHeightMap hmap;
    protected Vector3d stepScale;
    protected double invxscale;
    protected CollisionPrimitive[] planes;
    protected int noOfPlanes;

    public Collision1DHeightMap(ImageHeightMap imageHeightMap) {
        this.hmap = imageHeightMap;
        this.stepScale = new Vector3d(imageHeightMap.getStepScale());
        this.init();
    }

    public void init() {
        this.noOfPlanes = this.hmap.getXsize() - 1;
        this.planes = new CollisionPrimitive[this.noOfPlanes];
        int[] nArray = this.hmap.getHeightMap();
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        for (int i = 0; i < this.noOfPlanes; ++i) {
            double d = (double)i * this.stepScale.x;
            double d2 = (double)(i + 1) * this.stepScale.x;
            double d3 = (double)nArray[i] * this.stepScale.y;
            double d4 = (double)nArray[i + 1] * this.stepScale.y;
            vector3d.set(d, d3, 0.0);
            vector3d2.set(d2, d4, 0.0);
            vector3d3.set(d2, d4, -1.0);
            this.planes[i] = new Plane(vector3d, vector3d2, vector3d3);
        }
        this.invxscale = 1.0 / this.stepScale.x;
    }

    public boolean intersectSegmentLocal(Vector3d vector3d, Vector3d vector3d2, IntersectionResult intersectionResult) {
        CollisionPrimitive collisionPrimitive;
        int n = (int)(vector3d2.x * this.invxscale);
        if (n >= 0 && n < this.noOfPlanes && (collisionPrimitive = this.planes[n]).intersectSegment(vector3d, vector3d2, intersectionResult)) {
            intersectionResult.collisionPrimitive = collisionPrimitive;
            return true;
        }
        return false;
    }

    public void setStepScale(Vector3f vector3f) {
        this.stepScale = new Vector3d(vector3f);
    }

    public int getNoOfPlanes() {
        return this.noOfPlanes;
    }

    public void setHmap(ImageHeightMap imageHeightMap) {
        this.hmap = imageHeightMap;
    }
}

