/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.physics;

import com.turborilla.msm.physics.EngineTorqueFunction;

public class TurboEngineTorqueFunction
extends EngineTorqueFunction {
    private double turboChargeVelocity;
    private double turboChargeTorque;
    private double ascendSlope1;
    private double ascendSlope2;
    private double descendSlope;

    public TurboEngineTorqueFunction() {
        this.turboChargeVelocity = 30.0;
        this.turboChargeTorque = 70.0;
    }

    public TurboEngineTorqueFunction(double d, double d2, double d3, double d4, double d5, double d6) {
        super(d, d2, d3, d4);
        this.turboChargeTorque = d6;
        this.turboChargeVelocity = d5;
    }

    protected void calcSlopes() {
        super.calcSlopes();
        this.ascendSlope1 = (this.getTurboChargeTorque() - this.getMinTorque()) / (this.getTurboChargeVelocity() - 0.0);
        this.ascendSlope2 = (this.getPeakTorque() - this.getTurboChargeTorque()) / (this.getPeakVelocity() - this.getTurboChargeVelocity());
        this.descendSlope = (this.getMinTorque() - this.getPeakTorque()) / (this.getMaxVelocity() - this.getPeakVelocity());
    }

    public double getTorque(double d) {
        double d2 = 0.0;
        if (d <= this.getTurboChargeVelocity()) {
            d2 = d < 0.0 ? this.getMinTorque() : this.getMinTorque() + d * this.ascendSlope1;
        } else if (d > this.getTurboChargeVelocity() && d <= this.getPeakVelocity()) {
            d2 = this.getTurboChargeTorque() + (d - this.getTurboChargeVelocity()) * this.ascendSlope2;
        } else if (d > this.getPeakVelocity()) {
            d2 = d > this.getMaxVelocity() ? this.getMinTorque() : this.getPeakTorque() + (d - this.getPeakVelocity()) * this.descendSlope;
        }
        return d2;
    }

    public double getTurboChargeVelocity() {
        return this.turboChargeVelocity;
    }

    public void setTurboChargeVelocity(double d) {
        this.turboChargeVelocity = d;
        this.calcSlopes();
    }

    public double getTurboChargeTorque() {
        return this.turboChargeTorque;
    }

    public void setTurboChargeTorque(double d) {
        this.turboChargeTorque = d;
        this.calcSlopes();
    }
}

