/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.physics;

public class EngineTorqueFunction {
    private double peakVelocity = 70.0;
    private double maxVelocity = 100.0;
    private double minTorque = 50.0;
    private double peakTorque = 100.0;
    private double ascendSlope;
    private double descendSlope;

    public EngineTorqueFunction() {
        this.calcSlopes();
    }

    public EngineTorqueFunction(double d, double d2, double d3, double d4) {
        this.peakVelocity = d;
        this.maxVelocity = d2;
        this.minTorque = d3;
        this.peakTorque = d4;
        this.calcSlopes();
    }

    protected void calcSlopes() {
        this.ascendSlope = (this.getPeakTorque() - this.getMinTorque()) / (this.getPeakVelocity() - 0.0);
        this.descendSlope = (this.getMinTorque() - this.getPeakTorque()) / (this.getMaxVelocity() - this.getPeakVelocity());
    }

    public double getTorque(double d) {
        double d2 = 0.0;
        d2 = d <= this.getPeakVelocity() ? (d < 0.0 ? this.getMinTorque() : this.getMinTorque() + d * this.ascendSlope) : (d > this.getMaxVelocity() ? this.getMinTorque() : this.getPeakTorque() + (d - this.getPeakVelocity()) * this.descendSlope);
        return d2;
    }

    public double getMaxVelocity() {
        return this.maxVelocity;
    }

    public void setMaxVelocity(double d) {
        this.maxVelocity = d;
        this.calcSlopes();
    }

    public double getMinTorque() {
        return this.minTorque;
    }

    public void setMinTorque(double d) {
        this.minTorque = d;
        this.calcSlopes();
    }

    public double getPeakTorque() {
        return this.peakTorque;
    }

    public void setPeakTorque(double d) {
        this.peakTorque = d;
        this.calcSlopes();
    }

    public double getPeakVelocity() {
        return this.peakVelocity;
    }

    public void setPeakVelocity(double d) {
        this.peakVelocity = d;
        this.calcSlopes();
    }
}

