/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.physics;

import com.turborilla.physics.particle.ConstraintSpringDamped;
import com.turborilla.physics.particle.Particle;

public class ConstraintRiderBender
extends ConstraintSpringDamped {
    private double invWeight0;
    private double invWeight1;

    public ConstraintRiderBender() {
    }

    public ConstraintRiderBender(Particle particle, Particle particle2, double d) {
        super(particle, particle2, d);
        this.invWeight0 = particle.getInvWeight();
        this.invWeight1 = particle2.getInvWeight();
    }

    public ConstraintRiderBender(Particle particle, Particle particle2) {
        super(particle, particle2);
        this.invWeight0 = particle.getInvWeight();
        this.invWeight1 = particle2.getInvWeight();
    }

    public void satisfy(double d) {
        if (this.active) {
            scratch.set(this.particles[1].position).subtractLocal(this.particles[0].position);
            this.currentLength = scratch.length();
            if (this.currentLength == 0.0) {
                return;
            }
            double d2 = (this.currentLength - this.restLength) / (this.currentLength * (this.invWeight0 + this.invWeight1));
            d2 = d2 * this.stiffness * d;
            this.particles[0].position.addLocal(scratch.mult(this.invWeight0 * d2));
            this.particles[1].position.addLocal(scratch.mult(-this.invWeight1 * d2));
            v0.set(this.particles[0].position).subtractLocal(this.particles[0].oldPosition);
            v1.set(this.particles[1].position).subtractLocal(this.particles[1].oldPosition);
            dampAxis.set(this.particles[1].position).subtractLocal(this.particles[0].position);
            dampAxis.normalizeLocal();
            relVel.set(v1).subtractLocal(v0);
            double d3 = dampAxis.multLocal(relVel.dot(dampAxis)).length();
            if (dampAxis.lengthSquared() != 0.0) {
                dampAxis.normalizeLocal();
                d3 = d3 * this.damping * d;
                this.particles[0].position.addLocal(dampAxis.mult(this.invWeight0 * d3));
                this.particles[1].position.addLocal(dampAxis.mult(-this.invWeight1 * d3));
            }
        }
    }
}

