/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.loaders;

import com.jme.image.Texture;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.SceneElement;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.export.Savable;
import com.turborilla.msm.gameobjects.TrackGameObject;
import com.turborilla.msm.loaders.AbstractLoader;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.track.Track;
import com.turborilla.msm.track.Track1D;
import com.turborilla.terrain.ImageHeightMap;
import com.turborilla.utils.Material;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackLoader
extends AbstractLoader<Track> {
    private static final Logger logger = Logger.getLogger(TrackLoader.class.getName());
    private String[] loads = new String[]{"track"};

    @Override
    public String[] loads() {
        return this.loads;
    }

    @Override
    public Track load(URL uRL, Properties properties) throws IOException {
        Savable savable;
        int n;
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        SceneElement sceneElement = null;
        Material material = null;
        if (!ResourceManager.expect("environment", properties)) {
            Logger.getLogger(TrackGameObject.class.getName()).severe("No material given through the \"environment\" property. Defaulting to \"tiki\"");
        }
        try {
            material = (Material)ResourceManager.getInstance().load("material", properties.getProperty("environment", "tiki"), properties);
        }
        catch (IOException iOException) {
            Logger.getLogger(TrackGameObject.class.getName()).severe("Could not load material \"" + properties.getProperty("environment", "tiki") + "\". Exception: " + iOException);
        }
        Properties properties2 = null;
        if (uRL == null) {
            if (!ResourceManager.expect("track", properties)) {
                return null;
            }
            properties2 = ResourceManager.loadProps("tracks/" + properties.getProperty("track"));
        } else {
            properties2 = ResourceManager.loadProps(uRL);
        }
        if (properties2 == null) {
            return null;
        }
        if (!ResourceManager.expect("datafile", properties2)) {
            return null;
        }
        InputStream inputStream = null;
        for (n = 0; n < ResourceManager.meshFormats.length && inputStream == null; ++n) {
            inputStream = ResourceManager.openStream("tracks/meshes/" + properties2.getProperty("datafile") + ResourceManager.meshFormats[n]);
        }
        if (inputStream != null) {
            --n;
        } else {
            for (n = 0; n < ResourceManager.imageFormats.length && inputStream == null; ++n) {
                inputStream = ResourceManager.openStream("tracks/heightmaps/" + properties2.getProperty("datafile") + ResourceManager.imageFormats[n]);
            }
            if (inputStream != null) {
                savable = new ImageHeightMap();
                if (!((ImageHeightMap)savable).load(inputStream, ResourceManager.imageFormats[--n])) {
                    return null;
                }
                ImageHeightMap imageHeightMap = new ImageHeightMap();
                inputStream = ResourceManager.openStream("tracks/heightmaps/" + properties2.getProperty("datafile") + ResourceManager.imageFormats[n]);
                if (!imageHeightMap.load(inputStream, ResourceManager.imageFormats[n], 1)) {
                    return null;
                }
                Vector3f vector3f = new Vector3f();
                vector3f.x = Float.parseFloat(properties2.getProperty("scaleLength", "1"));
                vector3f.y = Float.parseFloat(properties2.getProperty("scaleHeight", "0.02"));
                vector3f.z = Float.parseFloat(properties2.getProperty("scaleWidth", "1"));
                Vector2f vector2f = new Vector2f();
                vector2f.x = material == null ? 1.0f : material.getScaleU();
                float f = vector2f.y = material == null ? 1.0f : material.getScaleV();
                sceneElement = ((ImageHeightMap)savable).getYsize() == 1 ? new Track1D("track", (ImageHeightMap)savable, imageHeightMap, vector3f, new Vector2f(), 0, vector2f) : new Track("track", (ImageHeightMap)savable, vector3f, new Vector2f(), 0, vector2f);
            } else {
                throw new IOException("Could not find datafile: " + properties2.getProperty("datafile") + " from trackFile: " + properties.getProperty("track"));
            }
        }
        if (sceneElement == null) {
            throw new IOException("Could not load track: tracks/" + properties.getProperty("track"));
        }
        TextureState textureState = displaySystem.getRenderer().createTextureState();
        savable = null;
        if (material != null && material.getTexture() != null) {
            savable = material.getTexture();
            ((Texture)savable).setWrap(3);
            textureState.setTexture((Texture)savable);
        }
        textureState.setEnabled(true);
        sceneElement.setRenderState(textureState);
        return sceneElement;
    }
}

