/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.loaders;

import com.turborilla.msm.loaders.AbstractLoader;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.sound.CompositeSFX;
import com.turborilla.sound.SFX;
import com.turborilla.sound.TurboSoundSystem;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFXLoader
extends AbstractLoader<SFX> {
    private TurboSoundSystem soundSystem;
    String[] loads = new String[]{"SFX", "Sfx", "sfx"};

    public SFXLoader(TurboSoundSystem turboSoundSystem) {
        this.addSuffix("ogg");
        this.addSuffix("wav");
        this.addSuffix("sfx");
        this.soundSystem = turboSoundSystem;
    }

    @Override
    public SFX load(URL uRL, Properties properties) throws IOException {
        String string = properties.getProperty("loadFile");
        String string2 = uRL.getPath().substring(uRL.getPath().lastIndexOf("."));
        if (!string2.endsWith("sfx")) {
            String string3 = string + string2;
            this.soundSystem.loadSound(uRL, string3);
            SFX sFX = new SFX(this.soundSystem, string3);
            return sFX;
        }
        return (CompositeSFX)ResourceManager.getInstance().load("compositeSFX", uRL, properties);
    }

    @Override
    public String[] loads() {
        return this.loads;
    }
}

