/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.loaders;

import com.jme.image.Image;
import com.jme.system.GameSettings;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.export.binary.BinaryImporter;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.IEventListener;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.msm.Game;
import com.turborilla.msm.loaders.ILoader;
import com.turborilla.msm.loaders.LoadedResource;
import com.turborilla.utils.ImageUtils;
import com.turborilla.utils.folders.SystemFolder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManager
implements IEventListener {
    private static final Logger logger = Logger.getLogger(ResourceManager.class.getName());
    private static ResourceManager instance = null;
    private boolean reloadEnabled = true;
    private ArrayList<LoadedResource> loadedResources;
    private static final String reloadEvent = "ReloadAllResources";
    private static EventManager eventManager = null;
    private static GameSettings settings = null;
    static String[] imageFormats;
    static String[] textureFormats;
    static String[] meshFormats;
    private static Map<String, ILoader> loaders;
    private ArrayList<Integer> removeCachedIndices = new ArrayList();

    private ResourceManager() {
        imageFormats = new String[1];
        ResourceManager.imageFormats[0] = ".tga";
        meshFormats = new String[1];
        ResourceManager.meshFormats[0] = ".jme";
        textureFormats = new String[1];
        ResourceManager.textureFormats[0] = ".jpg";
        loaders = new HashMap<String, ILoader>();
        this.loadedResources = this.reloadEnabled ? new ArrayList() : null;
        if (eventManager != null) {
            eventManager.registerListener(reloadEvent, this);
        }
    }

    public static void setSettings(GameSettings gameSettings) {
        settings = gameSettings;
    }

    public static ResourceManager getInstance() {
        if (instance == null) {
            instance = new ResourceManager();
        }
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    public Object load(String string, String string2, Properties properties) throws IOException {
        URL uRL;
        Object object2;
        String[] stringArray;
        String[] stringArray2;
        ILoader iLoader;
        block28: {
            iLoader = this.getLoader(string);
            if (iLoader == null) {
                throw new IOException("Could not find a loader for type: " + string);
            }
            stringArray2 = iLoader.getPaths();
            stringArray = iLoader.getSuffices();
            if (properties == null) {
                properties = new Properties();
            }
            properties.setProperty("loadType", string);
            properties.setProperty("loadFile", string2);
            if ((string.equalsIgnoreCase("image") || string.equalsIgnoreCase("texture")) && properties != null && properties.getProperty("GameHeight") != null) {
                try {
                    boolean bl;
                    BinaryImporter binaryImporter;
                    File file;
                    void var13_26;
                    Object object;
                    Object object3;
                    void var13_24;
                    String string3;
                    URL uRL2;
                    int n;
                    int n2 = Integer.parseInt(properties.getProperty("GameHeight"));
                    object2 = null;
                    object2 = settings != null ? settings.get("ImageHeights", "1024").split(",") : new String[]{"1024"};
                    int[] object4 = new int[((String[])object2).length];
                    for (n = 0; n < ((String[])object2).length; ++n) {
                        object4[n] = Integer.parseInt(object2[n]);
                    }
                    Arrays.sort(object4);
                    n = 0;
                    int n3 = 0;
                    for (n = 0; n < object4.length; ++n) {
                        if (object4[n] < n2) continue;
                        n3 = object4[n];
                        break;
                    }
                    if (n3 == 0) {
                        n3 = object4[object4.length - 1];
                    }
                    if ((uRL2 = ResourceManager.findUrl(string3 = string2 + "_" + n3, stringArray2, stringArray)) == null && properties != null && Boolean.parseBoolean(properties.getProperty("separateChannels", "false"))) {
                        URL uRL3 = ResourceManager.findUrl(string3 + "_RGB", stringArray2, stringArray);
                    }
                    if (var13_24 == null) {
                        void var15_32;
                        object3 = "";
                        if (stringArray2 == null || stringArray2.length == 0) {
                            object3 = "(No paths registered)";
                        } else {
                            for (String string4 : stringArray2) {
                                object3 = (String)object3 + string4 + "\n";
                            }
                        }
                        String string5 = "";
                        object = stringArray;
                        int n4 = ((String[])object).length;
                        for (int i = 0; i < n4; ++i) {
                            String string6 = object[i];
                            String string7 = (String)var15_32 + string6 + " ";
                        }
                        logger.warning("Could not find file \"" + string3 + "\" in any of the paths: \n" + (String)object3 + "for any of the extensions: \n" + (String)var15_32 + ". Loading \"" + string2 + "\" instead.");
                        URL uRL4 = ResourceManager.findUrl(string2, stringArray2, stringArray);
                        string3 = string2;
                        n3 = settings != null ? settings.getInt("DefaultHeight", 1024) : 1024;
                    }
                    if (var13_26 == null) break block28;
                    object3 = null;
                    boolean bl2 = false;
                    if (n3 != n2 && (file = new File((File)(object = new File(SystemFolder.getTempFolder("images"))), string2 + "_" + n2)).exists() && (object3 = (Image)(binaryImporter = BinaryImporter.getInstance()).load(file)) != null) {
                        bl = true;
                    }
                    if (!bl) {
                        logger.info("Loading " + string + " from file \"" + var13_26.getPath() + "\"");
                        properties.setProperty("loadFile", string3);
                        object3 = (Image)this.load(iLoader, (URL)var13_26, properties);
                        if (n3 != n2) {
                            try {
                                ImageUtils.scaleImage((Image)object3, (float)n2 / (float)n3);
                                try {
                                    object = new File(SystemFolder.getTempFolder("images"));
                                    BinaryExporter binaryExporter = BinaryExporter.getInstance();
                                    binaryExporter.save((Savable)object3, new File((File)object, string2 + "_" + n2));
                                }
                                catch (Exception exception) {
                                    logger.warning("Could not save to temp dir due to " + exception);
                                }
                            }
                            catch (RuntimeException runtimeException) {
                                runtimeException.printStackTrace();
                                logger.severe("Could not resize \"" + var13_26 + "\" by \"" + (float)n2 / (float)n3 + "\" percent with software scaleImage(). Exception: " + runtimeException);
                            }
                        }
                    }
                    return object3;
                }
                catch (NumberFormatException numberFormatException) {
                    logger.severe("Property is not an integer. Exception: " + numberFormatException);
                }
            }
        }
        if ((uRL = ResourceManager.findUrl(string2, stringArray2, stringArray)) == null) {
            void var9_15;
            object2 = "";
            if (stringArray2 == null || stringArray2.length == 0) {
                object2 = "(No paths registered)";
            } else {
                for (String string3 : stringArray2) {
                    object2 = (String)object2 + string3 + "\n";
                }
            }
            String string8 = "";
            if (stringArray != null) {
                for (String string9 : stringArray) {
                    String string10 = (String)var9_15 + string9 + " ";
                }
            }
            throw new IOException("Could not find file \"" + string2 + "\" in any of the paths: \n" + (String)object2 + "for any of the extensions: \n" + (String)var9_15);
        }
        logger.info("Loading " + string + " from file \"" + uRL.getPath() + "\"");
        object2 = this.load(iLoader, uRL, properties);
        if (object2 == null) {
            throw new IOException("Could not load resource \"" + string2 + "\" of type \"" + string + "\"");
        }
        return object2;
    }

    public <T> T[] loadAll(String string, Properties properties, T[] objectArray) throws IOException {
        String[] stringArray;
        ILoader iLoader = this.getLoader(string);
        if (iLoader == null) {
            throw new IOException("Could not find a loader for type: " + string);
        }
        String[] stringArray2 = iLoader.getPaths();
        String[] stringArray3 = iLoader.getSuffices();
        if (properties == null) {
            properties = new Properties();
        }
        if ((stringArray = ResourceManager.findAllFiles(stringArray2, stringArray3)) != null && stringArray.length > 0) {
            if (objectArray.length < stringArray.length) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), stringArray.length);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                objectArray[i] = this.load(string, stringArray[i], properties);
            }
            if (objectArray.length > stringArray.length) {
                objectArray[stringArray.length] = null;
            }
        }
        return objectArray;
    }

    public Object load(String string, URL uRL, Properties properties) throws IOException {
        ILoader iLoader = this.getLoader(string);
        if (properties != null) {
            properties.setProperty("loadType", string);
        }
        if (iLoader == null) {
            throw new IOException("Could not find a loader for type: " + string);
        }
        return this.load(iLoader, uRL, properties);
    }

    private Object load(ILoader iLoader, URL uRL, Properties properties) throws IOException {
        Object object;
        if ((properties == null || Boolean.parseBoolean(properties.getProperty("lookInCache", "true"))) && (object = this.lookForResourceInCache(iLoader, uRL, properties)) != null) {
            logger.info("Found the file \"" + uRL.getPath() + "\" in the cache.");
            return object;
        }
        object = iLoader.load(uRL, properties);
        if (this.reloadEnabled && (properties == null || Boolean.parseBoolean(properties.getProperty("putInCache", "true")))) {
            this.loadedResources.add(new LoadedResource(iLoader, uRL, object, properties));
        }
        return object;
    }

    public void reloadAllResources() throws IOException {
        System.out.println("Reloading resources");
        if (this.reloadEnabled && this.loadedResources != null) {
            int n;
            this.removeCachedIndices.clear();
            for (n = 0; n < this.loadedResources.size(); ++n) {
                LoadedResource loadedResource = this.loadedResources.get(n);
                if (!loadedResource.isValid()) {
                    this.removeCachedIndices.add(n);
                    continue;
                }
                if (!loadedResource.getLoader().canReload()) continue;
                loadedResource.getLoader().reload(loadedResource.getResource(), loadedResource.getFile(), loadedResource.getProps());
            }
            for (n = 0; n < this.removeCachedIndices.size(); ++n) {
                this.loadedResources.remove(this.removeCachedIndices.get(n));
            }
        }
    }

    private Object lookForResourceInCache(ILoader iLoader, URL uRL, Properties properties) {
        int n;
        Object object = null;
        this.removeCachedIndices.clear();
        for (n = 0; n < this.loadedResources.size(); ++n) {
            LoadedResource loadedResource = this.loadedResources.get(n);
            if (!loadedResource.isValid()) {
                this.removeCachedIndices.add(n);
                continue;
            }
            if (!uRL.equals(loadedResource.getFile()) || iLoader != loadedResource.getLoader()) continue;
            object = loadedResource.getResource();
            break;
        }
        for (n = 0; n < this.removeCachedIndices.size(); ++n) {
            this.loadedResources.remove(this.removeCachedIndices.get(n));
        }
        return object;
    }

    private void removeResourceFromCache(Object object) {
        LoadedResource loadedResource;
        Iterator<LoadedResource> iterator = this.loadedResources.iterator();
        while (iterator.hasNext() && (loadedResource = iterator.next()) != null) {
            if (loadedResource.isValid() && loadedResource.getResource() != object) continue;
            iterator.remove();
        }
    }

    private void clearCache() {
        if (this.loadedResources != null) {
            this.loadedResources.clear();
        }
    }

    public void registerLoader(ILoader iLoader) {
        if (iLoader != null) {
            String[] stringArray;
            for (String string : stringArray = iLoader.loads()) {
                loaders.put(string, iLoader);
            }
        }
    }

    private ILoader getLoader(String string) {
        return loaders.get(string);
    }

    static InputStream openStream(String string) throws IOException {
        URL uRL = Game.class.getClassLoader().getResource(string);
        if (uRL == null) {
            return null;
        }
        return uRL.openStream();
    }

    static boolean expect(String string, Properties properties) {
        if (properties == null || properties.getProperty(string) == null) {
            logger.warning("Could not find property \"" + string + "\" in props: " + properties);
            return false;
        }
        return true;
    }

    static Properties loadProps(String string) {
        URL uRL = null;
        uRL = Game.class.getClassLoader().getResource(string);
        if (uRL == null) {
            uRL = Game.class.getClassLoader().getResource(string + ".txt");
        }
        if (uRL == null) {
            logger.severe("Could not find properties file: " + string);
            return null;
        }
        return ResourceManager.loadProps(uRL);
    }

    static Properties loadProps(URL uRL) {
        Properties properties = null;
        try {
            properties = new Properties();
            properties.load(uRL.openStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return properties;
    }

    public static URL findUrl(String string) {
        return ResourceManager.findUrl(string, null, null);
    }

    public static URL findUrl(String string, String[] stringArray, String[] stringArray2) {
        URL uRL = null;
        if (stringArray2 == null && stringArray == null) {
            return ResourceManager.class.getClassLoader().getResource(string);
        }
        if (stringArray2 == null && stringArray != null) {
            for (String string2 : stringArray) {
                uRL = ResourceManager.class.getClassLoader().getResource(string2 + "/" + string);
                if (uRL == null) continue;
                return uRL;
            }
        }
        if (stringArray2 != null && stringArray == null) {
            for (String string2 : stringArray2) {
                uRL = ResourceManager.class.getClassLoader().getResource(string + "." + string2);
                if (uRL == null) continue;
                return uRL;
            }
        }
        if (stringArray2 != null && stringArray != null) {
            for (String string2 : stringArray) {
                for (String string3 : stringArray2) {
                    uRL = ResourceManager.class.getClassLoader().getResource(string2 + "/" + string + "." + string3);
                    if (uRL == null) continue;
                    return uRL;
                }
            }
        }
        return uRL;
    }

    public static String[] findAllFiles(String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray2 == null && stringArray == null) {
            return null;
        }
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{""};
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            stringArray2 = new String[]{""};
        }
        for (String string : stringArray) {
            File file = null;
            try {
                file = new File(ResourceManager.class.getClassLoader().getResource(string).toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
            String[] stringArray3 = stringArray2;
            int n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                FilenameFilter filenameFilter;
                String string2;
                final String string3 = string2 = stringArray3[i];
                if (string2.equals("")) {
                    filenameFilter = file.listFiles();
                } else {
                    FilenameFilter filenameFilter2 = new FilenameFilter(){

                        public boolean accept(File file, String string) {
                            return string.endsWith(string3);
                        }
                    };
                    filenameFilter = file.listFiles(filenameFilter2);
                }
                if (filenameFilter == null) continue;
                for (File file2 : filenameFilter) {
                    int n2;
                    String string4 = file2.getName();
                    if (file2.isDirectory() && !string.equals("")) {
                        String[] stringArray4;
                        String string5 = string + File.separatorChar + string4;
                        for (String string6 : stringArray4 = ResourceManager.findAllFiles(new String[]{string5}, stringArray2)) {
                            if (arrayList.contains(string4 + File.separatorChar + string6)) continue;
                            arrayList.add(string4 + File.separatorChar + string6);
                        }
                        continue;
                    }
                    if (string4 != null && (n2 = string4.lastIndexOf(46)) >= 0) {
                        string4 = string4.substring(0, n2);
                    }
                    if (arrayList.contains(string4)) continue;
                    arrayList.add(string4);
                }
            }
        }
        String[] stringArray5 = arrayList.toArray(new String[0]);
        return stringArray5;
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    public void setReloadEnabled(boolean bl) {
        this.reloadEnabled = bl;
        this.loadedResources = bl ? new ArrayList() : null;
    }

    @Override
    public String getName() {
        return "ResourceManager";
    }

    @Override
    public void handleEvent(ReceivedEvent receivedEvent) {
        if (receivedEvent.getName().equals(reloadEvent)) {
            logger.info("Reloading all resources");
            try {
                this.reloadAllResources();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void setEventManager(EventManager eventManager) {
        ResourceManager.eventManager = eventManager;
        if (instance != null) {
            eventManager.registerListener(reloadEvent, instance);
        }
    }

    @Override
    public boolean isRemoveMeFromEventmanager() {
        return false;
    }
}

