/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.loaders;

import com.jme.image.Image;
import com.turborilla.msm.loaders.AbstractLoader;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.utils.Font;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontLoader
extends AbstractLoader<Font> {
    String[] loads = new String[]{"font"};

    public FontLoader() {
        this.addSuffix("fnt");
    }

    @Override
    public Font load(URL uRL, Properties properties) throws IOException {
        String string;
        string = string.substring(((string = uRL.getFile()).lastIndexOf("/") > 0 ? string.lastIndexOf("/") : string.lastIndexOf("\\")) + 1, string.lastIndexOf("."));
        Image image = (Image)ResourceManager.getInstance().load("image", string, properties);
        if (image == null) {
            throw new IOException("Could not find the corresponding image file of the font file: " + uRL.getFile());
        }
        Font font = new Font(uRL, image);
        if (properties != null) {
            float f = Float.parseFloat(properties.getProperty("charSpacingFactor", "1.0"));
            font.multiplyWithCharSpacing(f);
        }
        if (image == null) {
            throw new IOException("Could not load font: " + uRL.getFile());
        }
        return font;
    }

    @Override
    public boolean canReload() {
        return true;
    }

    @Override
    public String[] loads() {
        return this.loads;
    }
}

