/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.input;

import com.jme.input.joystick.Joystick;
import com.jme.input.util.SyntheticAxis;
import com.turborilla.Updatable;

public class JoystickAxis
extends SyntheticAxis
implements Updatable {
    private Joystick joystick;
    private int joystickAxisIndex;
    private float value = 0.0f;
    private boolean paused = false;
    private boolean arcade = false;
    private float factor = 1.0f;
    private boolean inverted = false;
    private float maximum = 1.0f;
    private float minimum = -1.0f;

    public JoystickAxis(String string, Joystick joystick, int n) {
        super(string);
        this.joystick = joystick;
        this.joystickAxisIndex = n;
    }

    public void update(float f) {
        if (this.paused) {
            return;
        }
        if (this.joystick != null && this.maximum - this.minimum != 0.0f) {
            float f2 = this.joystick.getAxisValue(this.joystickAxisIndex);
            f2 -= this.minimum;
            f2 = 2.0f * f2 / (this.maximum - this.minimum);
            f2 += this.minimum;
            float f3 = (f2 *= this.factor) - this.value;
            this.value = f2;
            if (this.arcade) {
                this.trigger(this.value * f, '\u0000', this.value, false, null);
            } else if (Math.abs(f3) > Float.MIN_VALUE) {
                this.trigger(f3 * f, '\u0000', this.value, false, null);
            }
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public boolean isArcade() {
        return this.arcade;
    }

    public void setArcade(boolean bl) {
        this.arcade = bl;
    }

    public float getFactor() {
        return this.factor;
    }

    public void setFactor(float f) {
        this.factor = f;
        if (this.inverted) {
            this.invert();
        }
    }

    private void invert() {
        this.factor = -this.factor;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean bl) {
        if (this.inverted != bl) {
            this.invert();
        }
        this.inverted = bl;
    }

    public float getMaximum() {
        return this.maximum;
    }

    public void setMaximum(float f) {
        this.maximum = f;
    }

    public float getMinimum() {
        return this.minimum;
    }

    public void setMinimum(float f) {
        this.minimum = f;
    }
}

