/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gui.turbogui.slider;

import com.jme.bounding.BoundingBox;
import com.jme.image.Texture;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.utils.IResizableWidget;
import com.turborilla.msm.gui.turbogui.listeners.IValueChangedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.gui.turbogui.slider.KnobLayer;
import com.turborilla.msm.gui.turbogui.slider.MovableAreaLayer;
import com.turborilla.msm.loaders.ResourceManager;
import java.io.IOException;
import java.util.logging.Logger;

public class Slider
extends BaseWidget
implements IResizableWidget {
    String defaultKnobImage = "sliderknobnormal";
    String mouseOverKnobImage = "sliderknobover";
    String defaultLineImage = "sliderline";
    String zeroValueLineImage = "sliderlineoff";
    String iconImage = "soundspeaker";
    private float knobMoveTime = -1.0f;
    static Vector3f mouseDownScale = new Vector3f(0.95f, 0.95f, 1.0f);
    static ColorRGBA darker = new ColorRGBA(0.97f, 0.97f, 0.97f, 1.0f);
    private KnobLayer defaultKnob;
    private KnobLayer mouseOverKnob;
    private MovableAreaLayer defaultLine;
    private MovableAreaLayer offLine;
    private boolean knobMouseOver = false;
    private IValueChangedListener valueChangedListener = null;
    private float value = 0.0f;
    private boolean vertical = false;
    private Vector3f knobPos = new Vector3f();
    private Vector3f tempVec = new Vector3f();
    private Vector3f tempVec2 = new Vector3f();
    private Texture iconTexture;
    private Quad iconQuad;

    public Slider(String string, float f, float f2, String string2, String string3, String string4, String string5, String string6) {
        this(string, f, f2, string2, string3, string4, string5, string6, false);
    }

    public Slider(String string, float f, float f2, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        super(string);
        this.vertical = bl;
        this.defaultKnobImage = string2;
        this.mouseOverKnobImage = string3;
        this.defaultLineImage = string4;
        this.zeroValueLineImage = string5;
        this.iconImage = string6;
        this.init(f, f2);
    }

    public Slider(String string, float f, float f2) {
        this(string, f, f2, false);
    }

    public Slider(String string, float f, float f2, boolean bl) {
        super(string);
        this.vertical = bl;
        this.init(f, f2);
    }

    private void init(float f, float f2) {
        this.setActivatable(true);
        this.setFocusable(true);
        this.iconQuad = null;
        float f3 = 0.0f;
        if (this.iconImage != null) {
            try {
                this.iconTexture = (Texture)ResourceManager.getInstance().load("texture", this.iconImage, this.getLoaderProperties());
                TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
                textureState.setTexture(this.iconTexture);
                f3 = (float)this.iconTexture.getImage().getWidth() * (f2 / (float)this.iconTexture.getImage().getHeight());
                this.iconQuad = new Quad(this.getName() + ":quad", f3, f2);
                this.iconQuad.setRenderState(textureState);
            }
            catch (IOException iOException) {
                Logger.getLogger(Slider.class.getName()).severe("Could not create Slider. Exception: " + iOException);
            }
            this.attachChild(this.iconQuad);
            this.iconQuad.setLocalTranslation(-f * 0.5f + f3 * 0.5f, 0.0f, 0.0f);
        }
        this.defaultLine = new MovableAreaLayer(this, this.defaultLineImage, f2 * 0.7f, f - f3);
        this.addLayer(this.defaultLine);
        if (this.zeroValueLineImage != null) {
            this.offLine = new MovableAreaLayer(this, this.zeroValueLineImage, f2 * 0.7f, f - f3);
            this.addLayer(this.offLine);
        }
        this.defaultKnob = new KnobLayer(this, this.defaultKnobImage, f2);
        this.addLayer(this.defaultKnob);
        this.mouseOverKnob = new KnobLayer(this, this.mouseOverKnobImage, f2);
        this.addLayer(this.mouseOverKnob);
        this.getFader().setColor(MenuButton.fullAlpha);
        this.defaultLine.getMover().setPosition(-f * 0.5f + f3 * 1.1f + this.defaultLine.getWidth() * 0.5f, 0.0f, 0.0f);
        this.defaultLine.getFader().setColor(MenuButton.fullAlpha);
        if (this.offLine != null) {
            this.offLine.getMover().setPosition(-f * 0.5f + f3 * 1.1f + this.offLine.getWidth() * 0.5f, 0.0f, 0.0f);
        }
        if (this.offLine != null) {
            this.offLine.getFader().setColor(MenuButton.noAlpha);
        }
        this.defaultKnob.getFader().setColor(MenuButton.fullAlpha);
        this.mouseOverKnob.getFader().setColor(MenuButton.noAlpha);
        this.defaultKnob.getMover().setDamping(0.1f);
        this.mouseOverKnob.getMover().setDamping(0.1f);
        if (this.vertical) {
            this.setLocalRotation(new Quaternion(new float[]{0.0f, 0.0f, 1.5707964f}));
        }
        this.setValue(this.value, true);
    }

    public void setSize(float f, float f2) {
        float f3;
        float f4;
        if (this.vertical) {
            f4 = f;
            f = f2;
            f2 = f4;
        }
        f4 = 0.0f;
        if (this.iconTexture != null) {
            f4 = (float)this.iconTexture.getImage().getWidth() * (f2 / (float)this.iconTexture.getImage().getHeight());
            this.iconQuad.resize(f4, f2);
            this.iconQuad.setLocalTranslation(-f * 0.5f + f4 * 0.5f, 0.0f, 0.0f);
        }
        this.defaultLine.setSize(f - f4, f2 * 0.7f);
        if (this.offLine != null) {
            this.offLine.setSize(f - f4, f2 * 0.7f);
        }
        float f5 = this.defaultLine.getWidth();
        float f6 = f3 = this.offLine != null ? this.offLine.getWidth() : 0.0f;
        if (this.vertical) {
            f5 = this.defaultLine.getHeight();
            f3 = this.offLine != null ? this.offLine.getHeight() : 0.0f;
        }
        this.defaultLine.getMover().setPosition(-f * 0.5f + f4 * 1.1f + f5 * 0.5f, 0.0f, 0.0f);
        if (this.offLine != null) {
            this.offLine.getMover().setPosition(-f * 0.5f + f4 * 1.1f + f3 * 0.5f, 0.0f, 0.0f);
        }
        this.defaultKnob.setSize(f, f2);
        this.mouseOverKnob.setSize(f, f2);
        this.defaultLine.updateModelBound();
        if (this.offLine != null) {
            this.offLine.updateModelBound();
        }
        if (this.iconQuad != null) {
            this.iconQuad.updateModelBound();
        }
        this.defaultKnob.updateModelBound();
        this.mouseOverKnob.updateModelBound();
        this.updateModelBound();
        this.updateWorldBound();
        this.updateWorldData(0.0f);
        this.setValue(this.getValue());
    }

    public void onLeftMouseDown(Vector3f vector3f) {
        this.setKnobPosition(this.worldToLocal(vector3f, this.tempVec));
    }

    void onMouseOverKnob() {
        this.knobMouseOver = true;
        if (!this.isFocused()) {
            this.takeFocus();
        }
        this.updateLook();
    }

    void onMouseOutKnob() {
        this.knobMouseOver = false;
        this.updateLook();
    }

    public void onMouseMove(Vector3f vector3f, boolean bl) {
        if (this.isActive()) {
            this.setKnobPosition(this.worldToLocal(vector3f, this.tempVec));
        }
    }

    public void onActivate() {
        this.updateLook();
    }

    public void onDeactivate() {
        this.updateLook();
    }

    public void onBlur() {
        this.updateLook();
    }

    public void onFocus() {
        this.updateLook();
    }

    private void updateLook() {
        this.mouseOverKnob.getScaler().scaleTo(defaultScale, MenuButton.clickScaleTime, MenuButton.clickScaleTime);
        this.defaultKnob.getScaler().scaleTo(defaultScale, MenuButton.clickScaleTime, MenuButton.clickScaleTime);
        if (this.value < 1.0E-4f) {
            this.value = 0.0f;
            if (this.offLine != null) {
                this.offLine.getFader().fadeTo(MenuButton.fullAlpha, MenuButton.fadeTime);
            }
        } else if (this.offLine != null) {
            this.offLine.getFader().fadeTo(MenuButton.noAlpha, MenuButton.fadeTime);
        }
        if (this.knobMouseOver || this.isActive() || this.isFocused()) {
            if (this.isActive()) {
                this.mouseOverKnob.getScaler().scaleTo(mouseDownScale, MenuButton.clickScaleTime, MenuButton.clickScaleTime);
                this.defaultKnob.getScaler().scaleTo(mouseDownScale, MenuButton.clickScaleTime, MenuButton.clickScaleTime);
                this.mouseOverKnob.getFader().fadeTo(darker, MenuButton.clickFadeTime);
            } else {
                this.mouseOverKnob.getFader().fadeTo(MenuButton.fullAlpha, MenuButton.fadeTime);
            }
        } else {
            this.mouseOverKnob.getFader().fadeTo(MenuButton.noAlpha, MenuButton.fadeTime);
        }
    }

    void setKnobPosition(Vector3f vector3f) {
        this.setKnobPosition(vector3f, false);
    }

    void setKnobPosition(Vector3f vector3f, boolean bl) {
        float f;
        float f2;
        BoundingBox boundingBox = this.defaultLine.getBoundingBox();
        BoundingBox boundingBox2 = this.defaultKnob.getBoundingBox();
        this.worldToLocal(boundingBox.getCenter(), this.tempVec2);
        if (!this.vertical) {
            f2 = this.tempVec2.x - boundingBox.xExtent + boundingBox2.xExtent;
            f = this.tempVec2.x + boundingBox.xExtent - boundingBox2.xExtent;
        } else {
            f2 = this.tempVec2.x - boundingBox.yExtent + boundingBox2.yExtent;
            f = this.tempVec2.x + boundingBox.yExtent - boundingBox2.yExtent;
        }
        if (vector3f.x < f2) {
            vector3f.x = f2;
        }
        if (vector3f.x > f) {
            vector3f.x = f;
        }
        float f3 = this.value;
        this.value = (vector3f.x - f2) / (f - f2);
        this.knobPos.set(vector3f);
        this.knobPos.y = this.defaultKnob.getLocalTranslation().y;
        this.knobPos.z = this.defaultKnob.getLocalTranslation().z;
        if (!bl && this.knobMoveTime > 0.0f) {
            this.defaultKnob.getMover().translateTo(this.knobPos, this.knobMoveTime, this.knobMoveTime);
            this.mouseOverKnob.getMover().translateTo(this.knobPos, this.knobMoveTime, this.knobMoveTime);
        } else {
            this.defaultKnob.getMover().setPosition(this.knobPos);
            this.mouseOverKnob.getMover().setPosition(this.knobPos);
        }
        this.updateLook();
        if (Math.abs(this.value - f3) > Float.MIN_VALUE) {
            this.fireValueChanged();
        }
    }

    public void setValue(float f) {
        this.setValue(f, false);
    }

    private void setValue(float f, boolean bl) {
        float f2;
        float f3;
        this.updateWorldData(0.0f);
        BoundingBox boundingBox = this.defaultLine.getBoundingBox();
        BoundingBox boundingBox2 = this.defaultKnob.getBoundingBox();
        this.worldToLocal(boundingBox.getCenter(), this.tempVec);
        if (!this.vertical) {
            f3 = this.tempVec.x - boundingBox.xExtent + boundingBox2.xExtent;
            f2 = this.tempVec.x + boundingBox.xExtent - boundingBox2.xExtent;
        } else {
            f3 = this.tempVec.x - boundingBox.yExtent + boundingBox2.yExtent;
            f2 = this.tempVec.x + boundingBox.yExtent - boundingBox2.yExtent;
        }
        this.tempVec.set(this.defaultKnob.getLocalTranslation());
        this.tempVec.x = f3 + f * (f2 - f3);
        this.setKnobPosition(this.tempVec, bl);
    }

    public float getValue() {
        return this.value;
    }

    public boolean onKeyDown(int n, char c) {
        boolean bl = false;
        switch (n) {
            case 78: 
            case 205: {
                this.setValue(this.getValue() + 0.2f);
                bl = true;
                break;
            }
            case 74: 
            case 203: {
                this.setValue(this.getValue() - 0.2f);
                bl = true;
            }
        }
        return bl;
    }

    private void fireValueChanged() {
        if (this.valueChangedListener != null) {
            this.valueChangedListener.onValueChanged(this);
        }
    }

    public void setValueChangedListener(IValueChangedListener iValueChangedListener) {
        this.valueChangedListener = iValueChangedListener;
    }

    public float getKnobMoveTime() {
        return this.knobMoveTime;
    }

    public void setKnobMoveTime(float f) {
        this.knobMoveTime = f;
    }
}

