/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gui.turbogui.scrollbar;

import com.jme.image.Texture;
import com.jme.math.Vector3f;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.utils.IResizableWidget;
import com.turborilla.msm.gui.turbogui.scrollbar.ScrollBar;
import java.nio.FloatBuffer;

public class ScrollBarBar
extends BaseWidget
implements IResizableWidget {
    private Quad topQuad;
    private Quad fillQuad1;
    private Quad middleQuad;
    private Quad bottomQuad;
    private Texture texture;
    private float[] relativeHeights;
    private Quad fillQuad2;
    private float minLocalY = -100.0f;
    private float maxLocalY = 100.0f;
    private ScrollBar scrollBar;
    private Vector3f grabPoint = new Vector3f();
    private Vector3f movePoint = new Vector3f();
    private float topHeight;
    private float bottomHeight;
    private float middleHeight;
    private Runnable positionChangedListener;

    public ScrollBarBar(String string, ScrollBar scrollBar, Texture texture, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        super(string);
        this.setFocusable(true);
        this.setActivatable(true);
        this.texture = texture;
        this.scrollBar = scrollBar;
        float f = 1.0f;
        this.topQuad = this.makeQuad(texture, fArray, f, "top");
        this.fillQuad1 = this.makeQuad(texture, fArray2, f, "fill1");
        this.fillQuad2 = this.makeQuad(texture, fArray2, f, "fill2");
        this.middleQuad = this.makeQuad(texture, fArray3, f, "middle");
        this.bottomQuad = this.makeQuad(texture, fArray4, f, "bottom");
        float f2 = fArray[1] - fArray[3];
        float f3 = fArray2[1] - fArray2[3];
        float f4 = fArray3[1] - fArray3[3];
        float f5 = fArray4[1] - fArray4[3];
        float f6 = fArray[4] - fArray[2];
        this.relativeHeights = new float[4];
        this.relativeHeights[0] = f2 / f6;
        this.relativeHeights[1] = 1.0f;
        this.relativeHeights[2] = f4 / f6;
        this.relativeHeights[3] = f5 / f6;
        this.getFader().setColor(ScrollBar.normal);
        this.updateRenderState();
    }

    void setBounds(float f, float f2) {
        this.minLocalY = f;
        this.maxLocalY = f2;
        this.ensureInsideBounds();
    }

    private Quad makeQuad(Texture texture, float[] fArray, float f, String string) {
        float[] fArray2 = fArray;
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        textureState.setTexture(texture);
        float f2 = (float)texture.getImage().getWidth() * (f / (float)texture.getImage().getHeight());
        Quad quad = new Quad(this.getName() + ":" + string + "quad", f2, f);
        quad.setRenderState(textureState);
        FloatBuffer floatBuffer = quad.getTextureBuffer(0, 0);
        floatBuffer.clear();
        floatBuffer.put(fArray2);
        floatBuffer.flip();
        this.attachChild(quad);
        return quad;
    }

    public void setSize(float f, float f2) {
        this.topHeight = this.relativeHeights[0] * f;
        this.middleHeight = this.relativeHeights[2] * f;
        this.bottomHeight = this.relativeHeights[3] * f;
        float f3 = f2 - (this.topHeight + this.middleHeight + this.bottomHeight);
        this.topQuad.resize(f, this.topHeight);
        this.middleQuad.resize(f, this.middleHeight);
        this.bottomQuad.resize(f, this.bottomHeight);
        this.fillQuad1.resize(f, f3 /= 2.0f);
        this.fillQuad2.resize(f, f3);
        this.topQuad.getLocalTranslation().y = this.middleHeight / 2.0f + f3 + this.topHeight / 2.0f;
        this.fillQuad1.getLocalTranslation().y = this.middleHeight / 2.0f + f3 / 2.0f;
        this.middleQuad.getLocalTranslation().y = 0.0f;
        this.fillQuad2.getLocalTranslation().y = -this.middleHeight / 2.0f - f3 / 2.0f;
        this.bottomQuad.getLocalTranslation().y = -this.middleHeight / 2.0f - f3 - this.bottomHeight / 2.0f;
        this.ensureInsideBounds();
        this.updateLook();
    }

    private void ensureInsideBounds() {
        float f = this.minLocalY - (this.getLocalTranslation().y + this.bottomQuad.getLocalTranslation().y - this.bottomHeight / 2.0f);
        if (f > 0.0f) {
            this.getLocalTranslation().y += f;
        }
        if ((f = this.maxLocalY - (this.getLocalTranslation().y + this.topQuad.getLocalTranslation().y + this.topHeight / 2.0f)) < 0.0f) {
            this.getLocalTranslation().y += f;
        }
        this.snapToWholePixels();
    }

    private void snapToWholePixels() {
        this.getLocalTranslation().y = Math.round(this.getLocalTranslation().y);
    }

    void updateLook() {
        if (this.isEnabled()) {
            if (this.isActive()) {
                this.fader.fadeTo(ScrollBar.active, 0.2f);
            } else if (this.isMouseOver()) {
                this.fader.fadeTo(ScrollBar.over, 0.2f);
            } else {
                this.fader.fadeTo(ScrollBar.normal, 0.2f);
            }
        } else {
            this.fader.fadeTo(noAlpha, 0.2f);
        }
    }

    private void grab(Vector3f vector3f) {
        this.worldToLocal(vector3f, this.grabPoint);
    }

    private void setBarPosition(Vector3f vector3f) {
        this.getLocalTranslation().y = vector3f.y - this.grabPoint.y;
        this.ensureInsideBounds();
    }

    public void setBarPosition(float f) {
        float f2 = this.minLocalY - this.bottomQuad.getLocalTranslation().y + this.bottomHeight / 2.0f;
        float f3 = this.maxLocalY - this.topQuad.getLocalTranslation().y - this.topHeight / 2.0f;
        f = f3 - (f3 - f2) * f;
        this.setBarPosition(this.movePoint.set(this.getLocalTranslation().x, f + this.grabPoint.y, this.getLocalTranslation().z));
    }

    public float getBarPosition() {
        return this.getLocalTranslation().y;
    }

    public float getRelativeBarPosition() {
        float f = this.minLocalY - this.bottomQuad.getLocalTranslation().y + this.bottomHeight / 2.0f;
        float f2 = this.maxLocalY - this.topQuad.getLocalTranslation().y - this.topHeight / 2.0f;
        float f3 = this.getBarPosition();
        f3 = (f2 - f3) / (f2 - f);
        return f3;
    }

    public void onMouseMove(Vector3f vector3f, boolean bl) {
        if (this.isActive()) {
            this.setBarPosition(this.scrollBar.worldToLocal(vector3f, this.movePoint));
            this.notifyPositionChangedListener();
        }
    }

    public void onLeftMouseDown(Vector3f vector3f) {
        super.onLeftMouseDown(vector3f);
        this.grab(vector3f);
    }

    public void onActivate() {
        super.onActivate();
        this.updateLook();
    }

    public void onDeactivate() {
        super.onDeactivate();
        this.updateLook();
    }

    public void onMouseOut() {
        super.onMouseOut();
        this.updateLook();
    }

    public void onMouseOver(boolean bl) {
        super.onMouseOver(bl);
        this.updateLook();
    }

    public Runnable getPositionChangedListener() {
        return this.positionChangedListener;
    }

    public void setPositionChangedListener(Runnable runnable) {
        this.positionChangedListener = runnable;
    }

    private void notifyPositionChangedListener() {
        if (this.getPositionChangedListener() != null) {
            this.getPositionChangedListener().run();
        }
    }

    public void onDisable() {
        super.onDisable();
        this.updateLook();
    }

    public void onEnable() {
        super.onEnable();
        this.updateLook();
    }
}

