/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gui.turbogui.panel;

import com.jme.math.Vector2f;
import com.jme.system.DisplaySystem;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.widget.utils.BaseLayout;
import com.turborilla.gui.widget.utils.RowLayout;
import com.turborilla.gui.widget.utils.VariableRowLayout;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.gui.turbogui.listeners.IListSelectionChangedListener;
import com.turborilla.msm.gui.turbogui.listeners.ITextChangedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.gui.turbogui.panel.BorderPanel;
import com.turborilla.msm.gui.turbogui.panel.ScrollableLabelList;
import com.turborilla.msm.gui.turbogui.textfield.TextField;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePanel
extends BorderPanel {
    private File directory;
    private ScrollableLabelList<FilePanelFile> fileList;
    private MenuButton loadButton;
    private MenuButton saveButton;
    private MenuButton cancelButton;
    private Vector2f loadButtonPosition = new Vector2f(0.75f, 0.5f);
    private Vector2f saveButtonPosition = new Vector2f(0.75f, 0.5f);
    private Vector2f cancelButtonPosition = new Vector2f(0.75f, 0.3f);
    private TextField filenameTextField;
    private Vector2f textFieldPosition = new Vector2f(0.75f, 0.73f);
    private boolean load = true;
    private boolean save = false;
    private FilenameFilter filter = null;
    private String suffix = null;
    private IButtonClickedListener cancelListener = null;
    private IButtonClickedListener loadListener = null;
    private IButtonClickedListener saveListener = null;
    private String validFileNameChars = " _-.!()[]{}$";
    private ArrayList<String> forbiddenFilenames;
    private String fontFile = "normal_small_black";
    private float charSpacing = 1.0f;
    private Label fileTipLabel;

    public FilePanel(String string, float f, float f2, GuiHandler guiHandler, String string2, String string3, String string4, float f3) {
        super(string, f, f2, guiHandler, string2, string3, string4, f3);
        VariableRowLayout variableRowLayout = new VariableRowLayout();
        this.setLayout(variableRowLayout);
        variableRowLayout.setRows(1.0f, 14.6f, 1.9f);
        variableRowLayout.setPadding(0.0f, 0.03f);
        variableRowLayout.add(null);
        RowLayout rowLayout = new RowLayout();
        rowLayout.setPadding(0.07f, 0.05f);
        variableRowLayout.add(rowLayout);
        this.forbiddenFilenames = new ArrayList();
        this.fileList = new ScrollableLabelList(string + ":FileList", f * 0.4f, f2 * 0.55f, guiHandler, this.fontFile, string2, string3, string4, 0.2f * ((float)DisplaySystem.getDisplaySystem().getHeight() / 1024.0f), (float)DisplaySystem.getDisplaySystem().getHeight() * 0.0225f);
        this.addWidget(this.fileList, new Vector2f(0.25f, 0.5f), true, true);
        BaseLayout baseLayout = new BaseLayout();
        baseLayout.setPadding(0.12f, 0.17f);
        baseLayout.add(this.fileList);
        rowLayout.add(baseLayout);
        VariableRowLayout variableRowLayout2 = new VariableRowLayout();
        rowLayout.add(variableRowLayout2);
        variableRowLayout2.setRows(1.0f, 2.0f, 2.0f, 1.0f);
        variableRowLayout2.setPadding(0.05f, 0.05f);
        variableRowLayout2.add(null);
        this.filenameTextField = new TextField("FilenameTextField", "", f * 0.3f, f * 0.2f * 0.25f, 20, "menufont", "menufontover");
        this.filenameTextField.setValidChars("abcdefghijklmnopqrstuvwxyz\u00c3\u00a5\u00c3\u00a4\u00c3\u00b6ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c3\u2026\u00c3\u201e\u00c3\u20130123456789 _-.!()[]{}$");
        variableRowLayout2.add(this.filenameTextField);
        RowLayout rowLayout2 = new RowLayout();
        variableRowLayout2.add(rowLayout2);
        rowLayout2.setPadding(0.1f, 0.0f);
        BaseLayout baseLayout2 = new BaseLayout();
        this.loadButton = new MenuButton("loadButton", "Load", f * 0.2f, f * 0.2f * 0.3f);
        this.saveButton = new MenuButton("saveButton", "Save", f * 0.2f, f * 0.2f * 0.3f);
        this.cancelButton = new MenuButton("cancelButton", "Cancel", f * 0.2f, f * 0.2f * 0.3f);
        baseLayout2.add(this.loadButton);
        baseLayout2.add(this.saveButton);
        rowLayout2.add(this.cancelButton);
        rowLayout2.add(baseLayout2);
        this.addWidget(this.loadButton, this.loadButtonPosition, true, true);
        this.addWidget(this.cancelButton, this.cancelButtonPosition, true, true);
        this.loadButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.fileTipLabel = new Label(this.getName() + ":ToolTipLabel", "", this.getWidth() * 0.9f, this.getHeight() * 0.05f, "normal_small_black", null);
        this.fileTipLabel.setHorisontalAlignment(HorisontalAlignment.CENTERED);
        this.addWidget(this.fileTipLabel, new Vector2f(0.5f, 0.07f), true, true);
        variableRowLayout.add(this.fileTipLabel);
        this.fileList.setSelectionChangedListener(new IListSelectionChangedListener<FilePanelFile>(){

            @Override
            public void onSelectionChanged(ScrollableLabelList<FilePanelFile> scrollableLabelList, FilePanelFile filePanelFile) {
                if (filePanelFile != null) {
                    FilePanel.this.loadButton.setEnabled(true);
                    FilePanel.this.filenameTextField.setText(filePanelFile.toString());
                } else {
                    FilePanel.this.loadButton.setEnabled(false);
                }
            }
        });
        this.filenameTextField.setTextChangedListener(new ITextChangedListener(){

            public void onTextChanged(TextField textField, String string) {
                if (FilePanel.this.isValidFileName(FilePanel.this.directory, string)) {
                    FilePanel.this.saveButton.setEnabled(true);
                } else {
                    FilePanel.this.saveButton.setEnabled(false);
                }
            }
        });
        this.filenameTextField.setEnterPassedOnToWidget(this.saveButton);
        this.doLayout();
    }

    private boolean isValidFileName(File file, String string) {
        int n;
        if (string.length() <= 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (n = 0; n < cArray.length; ++n) {
            char c = cArray[n];
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || this.validFileNameChars.indexOf(c) >= 0) continue;
            return false;
        }
        for (n = 0; n < this.forbiddenFilenames.size(); ++n) {
            String string2 = this.forbiddenFilenames.get(n);
            if (string2 == null || !string2.equals(string) && !(string2 + this.suffix).equals(string)) continue;
            return false;
        }
        return true;
    }

    public void refresh() {
        this.doLayout();
        this.fileList.clear();
        if (this.directory == null) {
            return;
        }
        FilePanelFile[] filePanelFileArray = this.wrapFileArray(this.directory.listFiles(this.filter));
        for (int i = 0; i < filePanelFileArray.length; ++i) {
            if (this.save && this.forbiddenFilenames.contains(filePanelFileArray[i].toString())) continue;
            this.fileList.addItem(filePanelFileArray[i]);
        }
        this.fileList.positionLabels();
        this.fileList.setOrder(this.getOrder(), true);
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setInLoadingMode() {
        if (!this.load) {
            this.addWidget(this.loadButton, this.loadButtonPosition, true, true);
        }
        if (this.save) {
            this.removeWidget(this.saveButton);
            this.removeWidget(this.filenameTextField);
        }
        this.fileList.setSimulateClickWidgetOnDoubleClick(this.loadButton);
        this.getGuiHandler().focusWidget(this.fileList);
        this.save = false;
        this.load = true;
        this.refresh();
    }

    public void setInSavingMode() {
        if (!this.save) {
            this.addWidget(this.saveButton, this.saveButtonPosition, true, true);
            this.addWidget(this.filenameTextField, this.textFieldPosition, true, true);
        }
        if (this.load) {
            this.removeWidget(this.loadButton);
        }
        this.fileList.setSimulateClickWidgetOnDoubleClick(null);
        this.getGuiHandler().focusWidget(this.filenameTextField);
        this.load = false;
        this.save = true;
        this.refresh();
    }

    public File getSelectedFile() {
        File file = null;
        if (this.load) {
            FilePanelFile filePanelFile = this.fileList.getSelected();
            if (filePanelFile != null) {
                file = filePanelFile.file;
            }
        } else if (this.save) {
            String string = this.filenameTextField.getText();
            if (this.suffix != null && !string.endsWith(this.suffix)) {
                string = string + this.suffix;
            }
            file = new File(this.directory, string);
        }
        return file;
    }

    public void setDirectory(File file) {
        this.directory = file.isDirectory() ? file : null;
        this.refresh();
    }

    public void setDirectory(URL uRL) {
        try {
            File file = new File(uRL.toURI());
            this.directory = file.isDirectory() ? file : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.refresh();
    }

    public FilePanelFile[] wrapFileArray(File[] fileArray) {
        ArrayList<FilePanelFile> arrayList = new ArrayList<FilePanelFile>();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isFile()) continue;
            arrayList.add(new FilePanelFile(fileArray[i]));
        }
        return arrayList.toArray(new FilePanelFile[0]);
    }

    public FilenameFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FilenameFilter filenameFilter) {
        this.filter = filenameFilter;
        this.refresh();
    }

    public ScrollableLabelList<FilePanelFile> getFileList() {
        return this.fileList;
    }

    public void setCancelListener(IButtonClickedListener iButtonClickedListener) {
        this.cancelListener = iButtonClickedListener;
        this.cancelButton.addListener(iButtonClickedListener);
    }

    public void setLoadListener(IButtonClickedListener iButtonClickedListener) {
        this.loadListener = iButtonClickedListener;
        this.loadButton.addListener(iButtonClickedListener);
    }

    public void setSaveListener(IButtonClickedListener iButtonClickedListener) {
        this.saveListener = iButtonClickedListener;
        this.saveButton.addListener(iButtonClickedListener);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String string) {
        this.suffix = string;
        if (string != null) {
            if (this.suffix.charAt(0) != '.') {
                this.suffix = "." + this.suffix;
            }
            final String string2 = this.suffix;
            this.filter = new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(string2);
                }
            };
        } else {
            this.filter = null;
        }
    }

    public MenuButton getCancelButton() {
        return this.cancelButton;
    }

    public MenuButton getLoadButton() {
        return this.loadButton;
    }

    public MenuButton getSaveButton() {
        return this.saveButton;
    }

    public TextField getFilenameTextField() {
        return this.filenameTextField;
    }

    public boolean addForbiddenFilename(String string) {
        return this.forbiddenFilenames.add(string);
    }

    public void clearForbiddenFilenames() {
        this.forbiddenFilenames.clear();
    }

    public boolean removeForbiddenFilename(String string) {
        return this.forbiddenFilenames.remove(string);
    }

    public Label getFileTipLabel() {
        return this.fileTipLabel;
    }

    private class FilePanelFile {
        File file;

        public FilePanelFile(URI uRI) {
            this.file = new File(uRI);
        }

        public FilePanelFile(File file) {
            this.file = file;
        }

        public String toString() {
            String string = this.file.getName();
            if (FilePanel.this.suffix != null && string != null) {
                string = string.substring(0, string.lastIndexOf(FilePanel.this.suffix));
            }
            return string;
        }
    }
}

