/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gui.turbogui.menubutton;

import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.utils.IResizableWidget;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IButtonClickedListener;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.sound.SFX;
import com.turborilla.utils.controllers.AbstractSpatialController;
import com.turborilla.utils.controllers.IControllerListener;
import java.io.IOException;
import java.util.ArrayList;

public class MenuButton
extends BaseWidget
implements IResizableWidget {
    protected static String defaultBackgroundFile = "buttonnormal";
    protected static String mouseOverBackgroundFile = "buttonover";
    protected static String defaultFontFile = "menufont";
    protected static String mouseOverFontFile = "menufontover";
    public static ColorRGBA noAlpha = new ColorRGBA(1.0f, 1.0f, 1.0f, 0.0f);
    public static ColorRGBA fullAlpha = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    public static ColorRGBA darker = new ColorRGBA(0.8f, 0.8f, 0.8f, 1.0f);
    public static Vector3f defaultScale = new Vector3f(1.0f, 1.0f, 1.0f);
    public static Vector3f mouseOverScale1 = new Vector3f(1.15f, 1.15f, 1.0f);
    public static Vector3f mouseOverScale2 = new Vector3f(1.18f, 1.18f, 1.0f);
    public static Vector3f mouseDownScale = new Vector3f(1.1f, 1.1f, 1.0f);
    public ColorRGBA normal = fullAlpha;
    public ColorRGBA disabled = new ColorRGBA(0.3f, 0.3f, 0.3f, 1.0f);
    public static float fadeTime = 0.5f;
    public static float scaleTime = 7.8f;
    public static float scaleCycleMinTime = 55.0f;
    public static float scaleCycleTime = 1.8f;
    public static float clickScaleTime = 0.5f;
    public static float clickFadeTime = 0.05f;
    public static float scaleDamping = 0.1f;
    public static float scaleCycleDamping = 0.3f;
    protected BaseWidget defaultLayer;
    protected BaseWidget mouseOverLayer;
    private Label defaultLayerLabel;
    private Label mouseOverLayerLabel;
    private float xPadding = 0.0f;
    private float yPadding = 0.0f;
    private ArrayList<IButtonClickedListener> clickListeners;
    float width;
    float height;
    String text;
    protected SFX click;

    public MenuButton(String string, String string2, float f, float f2, float f3) {
        this(string, string2, f, f2);
        this.setTextSizeFactor(f3);
    }

    public MenuButton(String string) {
        super(string);
        this.setFocusable(true);
        this.setActivatable(true);
    }

    public MenuButton(String string, String string2, float f, float f2) {
        this(string);
        this.width = f;
        this.height = f2;
        this.text = string2;
        this.defaultLayerLabel = new Label(this.getName() + ":defaultLayer", string2, f, f2, defaultFontFile, defaultBackgroundFile);
        this.defaultLayer = this.defaultLayerLabel;
        this.addLayer(this.defaultLayer);
        this.mouseOverLayerLabel = new Label(this.getName() + ":mouseOverLayer", string2, f, f2, mouseOverFontFile, mouseOverBackgroundFile);
        this.mouseOverLayer = this.mouseOverLayerLabel;
        this.addLayer(this.mouseOverLayer);
        this.getScaler().setDamping(scaleDamping);
        this.defaultLayer.getScaler().setDamping(scaleDamping);
        this.mouseOverLayer.getScaler().setDamping(scaleDamping);
        this.defaultLayer.getFader().setColor(this.normal);
        this.mouseOverLayer.getFader().setColor(noAlpha);
        try {
            this.click = (SFX)ResourceManager.getInstance().load("sfx", "click", null);
            this.click.setVolumeCategory("GameSFXVolume");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setTextSizeFactor(float f) {
        if (this.defaultLayerLabel != null) {
            this.defaultLayerLabel.setTextSizeFactor(f);
        }
        if (this.mouseOverLayerLabel != null) {
            this.mouseOverLayerLabel.setTextSizeFactor(f);
        }
    }

    public void onMouseOver(boolean bl) {
        if (bl) {
            this.takeFocus();
        } else {
            this.updateLook();
        }
    }

    public void onMouseOut() {
        if (this.isActive()) {
            this.forceDeactivate();
        }
        this.releaseFocus();
        this.updateLook();
    }

    public void onBlur() {
        this.updateLook();
    }

    public void onFocus() {
        this.updateLook();
    }

    public void onActivate() {
        this.updateLook();
        if (this.click != null) {
            this.click.play();
        }
    }

    public void onDeactivate() {
        this.updateLook();
    }

    public void onDisable() {
        this.updateLook();
    }

    public void onEnable() {
        this.updateLook();
    }

    public void onMouseMove(Vector3f vector3f, boolean bl) {
        if (!this.isFocused() && bl) {
            this.takeFocus();
        }
    }

    public void onLeftMouseClicked(Vector3f vector3f) {
        if (this.isEnabled() && this.clickListeners != null) {
            for (int i = 0; i < this.clickListeners.size(); ++i) {
                this.clickListeners.get(i).onClick(this, vector3f);
            }
        }
    }

    protected void updateLook() {
        if (this.isEnabled()) {
            if (this.isActive()) {
                this.mouseOverLayer.getFader().fadeTo(darker, clickFadeTime);
                this.getScaler().clearListeners();
                this.getScaler().setRepeatType(0);
                this.getScaler().setDamping(scaleDamping);
                this.getScaler().scaleTo(mouseDownScale, clickScaleTime, clickScaleTime);
            } else if (this.isFocused()) {
                this.defaultLayer.getFader().fadeTo(noAlpha, fadeTime);
                this.mouseOverLayer.getFader().fadeTo(fullAlpha, fadeTime);
                this.getScaler().clearListeners();
                this.getScaler().setRepeatType(0);
                this.getScaler().setDamping(scaleDamping);
                this.getScaler().scaleTo(mouseOverScale1, scaleTime, scaleTime);
                this.getScaler().add(new AddCycleListener());
            } else {
                this.getScaler().clearListeners();
                this.mouseOverLayer.getFader().fadeTo(noAlpha, fadeTime);
                this.defaultLayer.getFader().fadeTo(this.normal, fadeTime);
                this.getScaler().setRepeatType(0);
                this.getScaler().setDamping(scaleCycleDamping);
                this.getScaler().scaleTo(defaultScale, scaleCycleTime, scaleCycleMinTime);
            }
        } else {
            this.defaultLayer.getFader().fadeTo(this.disabled, fadeTime);
            this.mouseOverLayer.getFader().fadeTo(noAlpha, fadeTime);
        }
    }

    public boolean addListener(IButtonClickedListener iButtonClickedListener) {
        if (this.clickListeners == null) {
            this.clickListeners = new ArrayList();
        }
        return this.clickListeners.add(iButtonClickedListener);
    }

    public void clearListeners() {
        if (this.clickListeners == null) {
            this.clickListeners = new ArrayList();
        }
        this.clickListeners.clear();
    }

    public boolean removeListener(IButtonClickedListener iButtonClickedListener) {
        if (this.clickListeners == null) {
            this.clickListeners = new ArrayList();
        }
        return this.clickListeners.remove(iButtonClickedListener);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        if (this.defaultLayerLabel != null) {
            this.defaultLayerLabel.setText(string);
        }
        if (this.mouseOverLayerLabel != null) {
            this.mouseOverLayerLabel.setText(string);
        }
    }

    public void setSize(float f, float f2) {
        this.width = f - f * this.xPadding;
        this.height = f2 - f2 * this.yPadding;
        if (this.defaultLayerLabel != null) {
            this.defaultLayerLabel.setSize(f, f2);
        }
        if (this.mouseOverLayerLabel != null) {
            this.mouseOverLayerLabel.setSize(f, f2);
        }
        this.updateModelBound();
    }

    public void setPadding(float f, float f2) {
        this.xPadding = f;
        this.yPadding = f2;
    }

    public class AddCycleListener
    implements IControllerListener {
        public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
            MenuButton.this.getScaler().setRepeatType(2);
            MenuButton.this.getScaler().scaleTo(mouseOverScale2, scaleTime, scaleCycleTime);
        }
    }
}

