/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gui.turbogui.label;

import com.jme.bounding.BoundingBox;
import com.jme.image.Texture;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.utils.IResizableWidget;
import com.turborilla.msm.gui.turbogui.Border;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.utils.Font;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.logging.Logger;

public class Label
extends BaseWidget
implements IResizableWidget {
    private com.turborilla.gui.Label label;
    private Font font;
    private String text;
    private String textBeforeTrim;
    private float width;
    private float height;
    private HorisontalAlignment horisontalAlignment = HorisontalAlignment.CENTERED;
    private String fontFile = "textfontblack";
    private String backgroundFile = "combobox";
    private boolean trimToWidth = false;
    private BoundingBox boundingBox = new BoundingBox();
    private float textSizeFactor = 0.8f;
    private Border border;
    private Quad quad;

    public Label(String string, float f, float f2) {
        this(string, null, f, f2, null, null);
    }

    public Label(String string, String string2, float f, float f2) {
        this(string, string2, f, f2, null, null);
    }

    public Label(String string, String string2, Font font, float f, float f2) {
        super(string);
        this.text = string2;
        this.width = f;
        this.height = f2;
        if (this.text == null) {
            this.text = "";
        }
        this.font = font;
        this.setText(this.text);
    }

    public Label(String string, String string2, float f, float f2, String string3, String string4, String string5, String string6, float f3) {
        super(string);
        this.text = string2;
        this.width = f;
        this.height = f2;
        if (this.text == null) {
            this.text = "";
        }
        if (string3 != null) {
            this.fontFile = string3;
        }
        this.border = new Border(string4, string5, string6);
        this.border.construct(f * 1.1f, f2 * 1.1f, f3);
        this.attachChild(this.border);
        try {
            Properties properties = new Properties();
            properties.setProperty("textureFlip", "false");
            this.font = (Font)ResourceManager.getInstance().load("font", this.fontFile, properties);
            this.setText(this.text);
        }
        catch (IOException iOException) {
            Logger.getLogger(Label.class.getName()).severe("Could not create Label. Exception: " + iOException);
        }
    }

    public Label(String string, String string2, float f, float f2, String string3, String string4) {
        super(string);
        Serializable serializable;
        this.text = string2;
        this.width = f;
        this.height = f2;
        if (this.text == null) {
            this.text = "";
        }
        if (string3 != null) {
            this.fontFile = string3;
        }
        this.backgroundFile = string4;
        try {
            serializable = new Properties();
            ((Properties)serializable).setProperty("textureFlip", "false");
            this.font = (Font)ResourceManager.getInstance().load("font", this.fontFile, (Properties)serializable);
            this.setText(this.text);
        }
        catch (IOException iOException) {
            Logger.getLogger(Label.class.getName()).severe("Could not create Label. Exception: " + iOException);
        }
        if (this.backgroundFile != null) {
            this.quad = new Quad(this.getName() + ":quad", f, f2);
            serializable = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
            this.quad.setRenderState((RenderState)serializable);
            try {
                Texture texture = (Texture)ResourceManager.getInstance().load("texture", this.backgroundFile, null);
                ((TextureState)serializable).setTexture(texture);
            }
            catch (IOException iOException) {
                Logger.getLogger(Label.class.getName()).severe("Could not create Label. Exception: " + iOException);
            }
            this.attachChild(this.quad);
        }
    }

    public void setText(String string) {
        this.detachChild(this.label);
        if (string == null) {
            string = "";
        }
        this.text = string;
        this.textBeforeTrim = string;
        this.label = new com.turborilla.gui.Label(this.getName() + ":label", this.font, string.length());
        this.label.setLightCombineMode(4);
        this.label.setUpdateInterval(-1.0f);
        if (!this.trimToWidth) {
            this.label.setText(string);
        } else {
            this.doTrimToWidth();
        }
        this.attachChild(this.label);
        float f = this.height * this.textSizeFactor;
        float f2 = this.font.getLineHeight();
        float f3 = f / f2;
        this.label.setLocalScale(f3);
        this.label.setLocalTranslation(0.0f, (float)(-this.font.getBase()) * 0.3f * f3, 0.0f);
        this.align();
    }

    public void setTrimToWidth(boolean bl) {
        this.trimToWidth = bl;
        if (bl) {
            this.doTrimToWidth();
        }
    }

    private void doTrimToWidth() {
        this.text = this.textBeforeTrim;
        float f = this.height * this.textSizeFactor;
        float f2 = this.font.getLineHeight();
        float f3 = f / f2;
        while (this.text.length() > 0 && (float)this.font.getWidth(this.text) * f3 > this.getWantedWidth()) {
            this.text = this.text.substring(0, this.text.length() - 1);
        }
        this.label.setText(this.text);
    }

    private void align() {
        if (this.horisontalAlignment == HorisontalAlignment.CENTERED) {
            this.label.center();
        } else if (this.horisontalAlignment == HorisontalAlignment.LEFT) {
            this.label.leftAlign(this.width);
        } else if (this.horisontalAlignment == HorisontalAlignment.RIGHT) {
            this.label.rightAlign(this.width);
        }
        this.setOrder(this.getOrder(), true);
    }

    public HorisontalAlignment getHorisontalAlignment() {
        return this.horisontalAlignment;
    }

    public void setHorisontalAlignment(HorisontalAlignment horisontalAlignment) {
        this.horisontalAlignment = horisontalAlignment;
        this.align();
    }

    public Font getFont() {
        return this.font;
    }

    public float getWidth(String string) {
        return (float)this.font.getWidth(string) * this.label.getLocalScale().x;
    }

    public String getText() {
        return this.text;
    }

    public BoundingBox getBoundingBox() {
        this.updateWorldData(0.0f);
        BoundingBox boundingBox = super.getBoundingBox();
        if (boundingBox == null) {
            boundingBox = this.boundingBox;
            boundingBox.getCenter().set(this.getLocalTranslation());
            boundingBox.xExtent = this.width * 0.5f;
            boundingBox.yExtent = this.height * 0.5f;
            boundingBox.zExtent = 0.0f;
        }
        return boundingBox;
    }

    public void setSize(float f, float f2) {
        this.width = f;
        this.height = f2;
        if (this.border != null) {
            this.border.construct(f * 1.1f, f2 * 1.1f);
        }
        if (this.quad != null) {
            this.quad.resize(f, f2);
        }
        this.setText(this.getText());
        this.updateModelBound();
    }

    public float getWantedWidth() {
        return this.width;
    }

    public float getWantedHeight() {
        return this.height;
    }

    public float getTextSizeFactor() {
        return this.textSizeFactor;
    }

    public void setTextSizeFactor(float f) {
        this.textSizeFactor = f;
        this.setText(this.getText());
    }
}

