/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gui.turbogui.combobox;

import com.jme.math.Vector3f;
import com.jme.util.Timer;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.utils.IResizableWidget;
import com.turborilla.msm.gui.turbogui.combobox.ComboBoxButton;
import com.turborilla.msm.gui.turbogui.combobox.ComboBoxItem;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBox<E>
extends BaseWidget
implements IResizableWidget {
    static String defaultBackground = "combobox";
    static String selectedBackground = "buttonnormal";
    static String defaultButtonImage = "combobuttonnormal";
    static String mouseOverButtonImage = "combobuttonover";
    static float rollMoveTime = 5.0f;
    static float rollDownFadeTime = 0.8f;
    static float rollUpFadeTime = 0.5f;
    static float selectFadeTime = 0.6f;
    static float rollDamping = 0.14f;
    Label defaultChosen;
    Label focusedChosen;
    ArrayList<ComboBoxItem<E>> items;
    ComboBoxButton defaultButton;
    ComboBoxButton mouseOverButton;
    int chosenIndex = 0;
    float width;
    float height;
    private static Vector3f tempVec = new Vector3f();
    private boolean rolledDown = false;
    private boolean wasRolledDown = false;
    ComboBoxItem<E> itemMouseOver;
    private float timeOfLastKeyPress = 0.0f;
    private float mouseOverLimitSinceLastKeyPress = 0.2f;
    private boolean dragging = false;

    public ComboBox(String string, float f, float f2, String string2, String string3, String string4) {
        super(string);
        this.setFocusable(true);
        this.setActivatable(true);
        this.width = f;
        this.height = f2;
        this.defaultChosen = new Label(string + ":chosen", "", f, f2, string2, "corner", "edge", "combobox", 0.2f);
        this.addLayer(this.defaultChosen);
        this.defaultChosen.getFader().setColor(MenuButton.fullAlpha);
        this.defaultChosen.setHorisontalAlignment(HorisontalAlignment.LEFT);
        this.focusedChosen = new Label(string + ":chosen", "", f, f2, string3, "corner", "edge", "combobox", 0.4f);
        this.addLayer(this.focusedChosen);
        this.focusedChosen.getFader().setColor(MenuButton.noAlpha);
        this.focusedChosen.setHorisontalAlignment(HorisontalAlignment.LEFT);
        this.items = new ArrayList();
        this.defaultButton = new ComboBoxButton(string + ":defaultButton", defaultButtonImage, f2 * 1.1f);
        this.defaultButton.getFader().setColor(MenuButton.fullAlpha);
        this.addLayer(this.defaultButton);
        this.mouseOverButton = new ComboBoxButton(string + ":mouseOverButton", mouseOverButtonImage, f2 * 1.1f);
        this.mouseOverButton.getFader().setColor(MenuButton.noAlpha);
        this.addLayer(this.mouseOverButton);
        tempVec.set(this.defaultChosen.getLocalTranslation());
        ComboBox.tempVec.x += f / 2.0f - this.defaultButton.getWidth() * 0.6f / 2.0f;
        ComboBox.tempVec.y += (this.defaultButton.getHeight() - f2) / 2.0f;
        this.defaultButton.getMover().setPosition(tempVec);
        this.mouseOverButton.getMover().setPosition(tempVec);
        this.setOrder(-100, true);
        this.defaultChosen.updateGeometricState(0.0f, true);
        this.focusedChosen.updateGeometricState(0.0f, true);
    }

    public void addItem(E e, String string) {
        ComboBoxItem comboBoxItem = new ComboBoxItem(this.getName() + ":itemlabel(" + e + ")", "", this.width / 1.15f, this.height / 1.1f, "menufont", "corner_small", "edge_small", "combobox", 0.5f, this);
        comboBoxItem.item = e;
        comboBoxItem.string = string != null ? string : e.toString();
        comboBoxItem.setText(comboBoxItem.string);
        comboBoxItem.getFader().setColor(MenuButton.noAlpha);
        comboBoxItem.setHorisontalAlignment(HorisontalAlignment.LEFT);
        comboBoxItem.getMover().setDamping(rollDamping);
        this.items.add(comboBoxItem);
        this.addLayer(comboBoxItem);
        if (this.items.size() == 1) {
            this.setChosenIndex(0);
        }
    }

    private void rollDown() {
        for (int i = 0; i < this.items.size(); ++i) {
            ComboBoxItem<E> comboBoxItem = this.items.get(i);
            tempVec.set(this.defaultChosen.getLocalTranslation());
            ComboBox.tempVec.y -= (float)(i + 1) * this.height;
            comboBoxItem.getFader().fadeTo(ComboBoxItem.defaultColor, rollDownFadeTime);
            comboBoxItem.getFader().add(comboBoxItem.getFinishedRollingListener());
            comboBoxItem.getMover().translateTo(tempVec, rollMoveTime, rollMoveTime);
            comboBoxItem.setFocusable(true);
            comboBoxItem.setOrder(this.getOrder() + 1);
        }
    }

    private void rollUp() {
        for (int i = 0; i < this.items.size(); ++i) {
            ComboBoxItem<E> comboBoxItem = this.items.get(i);
            tempVec.set(this.defaultChosen.getLocalTranslation());
            comboBoxItem.getFader().fadeTo(MenuButton.noAlpha, rollUpFadeTime);
            comboBoxItem.getFader().add(comboBoxItem.getFinishedRollingListener());
            comboBoxItem.getMover().translateTo(tempVec, rollMoveTime, rollMoveTime);
            comboBoxItem.setFocusable(false);
            comboBoxItem.setOrder(this.getOrder() + 1);
        }
    }

    void updateLook() {
        if (this.rolledDown && !this.wasRolledDown) {
            this.rollDown();
        } else if (!this.rolledDown && this.wasRolledDown) {
            this.rollUp();
        }
        if (this.rolledDown || this.isMouseOver() || this.isFocused() || this.isActive()) {
            this.mouseOverButton.getFader().fadeTo(MenuButton.fullAlpha, MenuButton.fadeTime);
            this.focusedChosen.getFader().fadeTo(MenuButton.fullAlpha, MenuButton.fadeTime);
            this.defaultChosen.getFader().fadeTo(MenuButton.noAlpha, MenuButton.fadeTime);
        } else {
            this.mouseOverButton.getFader().fadeTo(MenuButton.noAlpha, MenuButton.fadeTime);
            this.focusedChosen.getFader().fadeTo(MenuButton.noAlpha, MenuButton.fadeTime);
            this.defaultChosen.getFader().fadeTo(MenuButton.fullAlpha, MenuButton.fadeTime);
        }
        this.wasRolledDown = this.rolledDown;
    }

    void updateItemLook() {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).updateLook();
        }
    }

    void mouseOverItem(ComboBoxItem<E> comboBoxItem) {
        if (Timer.getTimer().getTimeInSeconds() - this.timeOfLastKeyPress > this.mouseOverLimitSinceLastKeyPress) {
            this.itemMouseOver = comboBoxItem;
            this.updateItemLook();
        }
    }

    void mouseOutItem(ComboBoxItem<E> comboBoxItem) {
        if (this.itemMouseOver == comboBoxItem) {
            this.itemMouseOver = null;
        }
        this.updateItemLook();
    }

    boolean isMouseOverItem(ComboBoxItem<E> comboBoxItem) {
        return comboBoxItem == this.itemMouseOver;
    }

    public void setChosenIndex(int n) {
        this.chosenIndex = n;
        this.defaultChosen.setText(this.items.get((int)n).string);
        this.defaultChosen.setOrder(this.getOrder(), true);
        this.focusedChosen.setText(this.items.get((int)n).string);
        this.focusedChosen.setOrder(this.getOrder(), true);
        this.itemMouseOver = null;
        this.updateItemLook();
    }

    @Override
    public void onLeftMouseDown(Vector3f vector3f) {
        if (this.defaultChosen.isInside(vector3f) || this.defaultButton.isInside(vector3f)) {
            if (this.rolledDown) {
                this.rolledDown = false;
                this.dragging = false;
            } else {
                this.rolledDown = true;
                this.dragging = true;
            }
            this.updateLook();
        }
    }

    @Override
    public void onLeftMouseUp(Vector3f vector3f) {
        int n = -1;
        if (!this.defaultChosen.isInside(vector3f) && !this.defaultButton.isInside(vector3f)) {
            n = this.getItemIndexForPosition(vector3f);
        }
        if (n >= 0) {
            this.setChosenIndex(n);
            this.rolledDown = false;
        }
        this.updateLook();
    }

    int getItemIndexForPosition(Vector3f vector3f) {
        for (int i = 0; i < this.items.size(); ++i) {
            ComboBoxItem<E> comboBoxItem = this.items.get(i);
            if (!comboBoxItem.isInside(vector3f)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean onKeyTyped(int n, char c) {
        return n == 28 || n == 156 || n == 57;
    }

    @Override
    public boolean onKeyDown(int n, char c) {
        boolean bl = false;
        int n2 = this.chosenIndex;
        int n3 = this.chosenIndex;
        switch (n) {
            case 205: 
            case 208: {
                if (n == 208 && !this.rolledDown) break;
                if (++n2 >= this.items.size()) {
                    n2 = 0;
                }
                this.setChosenIndex(n2);
                if (this.rolledDown && n3 >= 0 && n3 < this.items.size()) {
                    this.items.get(n3).onMouseOut();
                }
                bl = true;
                break;
            }
            case 200: 
            case 203: {
                if (n == 200 && !this.rolledDown) break;
                if (--n2 < 0) {
                    n2 = this.items.size() - 1;
                }
                this.setChosenIndex(n2);
                if (this.rolledDown && n3 >= 0 && n3 < this.items.size()) {
                    this.items.get(n3).onMouseOut();
                }
                bl = true;
                break;
            }
            case 28: 
            case 57: 
            case 156: {
                if (this.rolledDown) {
                    this.takeFocus();
                    this.rolledDown = false;
                } else {
                    this.rolledDown = true;
                }
                bl = true;
            }
        }
        if (bl) {
            this.itemMouseOver = null;
            this.timeOfLastKeyPress = Timer.getTimer().getTimeInSeconds();
            this.updateLook();
            this.updateItemLook();
        }
        return bl;
    }

    @Override
    public void onBlur() {
        this.rolledDown = false;
        this.updateLook();
    }

    @Override
    public void onFocus() {
        this.updateLook();
    }

    @Override
    public void onMouseOver(boolean bl) {
        this.updateLook();
    }

    @Override
    public void onMouseOut() {
        this.updateLook();
    }

    void focusTheChosen() {
        if (this.rolledDown) {
            this.items.get(this.chosenIndex).onMouseOver(false);
        }
    }

    public boolean isRolledDown() {
        return this.rolledDown;
    }

    void setRolledDown(boolean bl) {
        this.rolledDown = bl;
    }

    boolean isItemChosen(ComboBoxItem<E> comboBoxItem) {
        if (this.chosenIndex < 0 || this.chosenIndex >= this.items.size() || this.itemMouseOver != null) {
            return false;
        }
        return comboBoxItem == this.items.get(this.chosenIndex);
    }

    @Override
    public boolean setActive(boolean bl) {
        if (!bl && this.isMouseOver() && this.rolledDown) {
            return false;
        }
        return super.setActive(bl);
    }

    @Override
    public void setSize(float f, float f2) {
        this.width = f;
        this.height = f2;
        this.defaultChosen.setSize(f, f2);
        this.focusedChosen.setSize(f, f2);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).setSize(f, f2);
        }
        this.defaultButton.setSize(f, f2);
        this.mouseOverButton.setSize(f, f2);
        tempVec.set(this.defaultChosen.getLocalTranslation());
        ComboBox.tempVec.x += f / 2.0f - this.defaultButton.getWidth() * 0.6f / 2.0f;
        ComboBox.tempVec.y += (this.defaultButton.getHeight() - f2) / 2.0f;
        this.defaultButton.getMover().setPosition(tempVec);
        this.mouseOverButton.getMover().setPosition(tempVec);
    }
}

