/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gui.turbogui;

import com.jme.math.Vector2f;
import com.turborilla.gui.widget.utils.BaseLayout;
import com.turborilla.gui.widget.utils.IResizableWidget;
import com.turborilla.msm.gui.turbogui.scrollbar.ScrollBar;

public class ScrollableColumnLayout
extends BaseLayout
implements ScrollBar.IElementPositionChangedListener {
    private int visibleRows = 1;
    private ScrollBar scrollBar = null;
    private Vector2f tempVec = new Vector2f();

    public ScrollableColumnLayout(int n) {
        this.visibleRows = n;
        this.initScrollBar();
    }

    public ScrollableColumnLayout(float f, float f2, int n) {
        super(f, f2);
        this.visibleRows = n;
        this.initScrollBar();
        this.setSize(f, f2);
    }

    public ScrollableColumnLayout(Vector2f vector2f, float f, float f2, float f3, int n) {
        super(vector2f, f, f2, f3);
        this.visibleRows = n;
        this.initScrollBar();
        this.setSize(f, f2);
    }

    private void initScrollBar() {
        this.scrollBar = new ScrollBar("layoutScrollBar");
        this.setScrollBar(this.scrollBar);
    }

    public void setSize(float f, float f2) {
        super.setSize(f, f2);
        if (this.scrollBar != null) {
            this.scrollBar.setSize(14.0f, f2);
            this.scrollBar.setPosition(new Vector2f(this.position.x + f * 0.5f - 7.0f, this.position.y));
        }
    }

    public void doLayout() {
        int n;
        this.scrollBar.setNumberOfElements(this.widgets.size());
        float f = this.height / (float)this.visibleRows;
        float f2 = f - this.height * this.yPadding;
        float f3 = this.width - this.width * this.xPadding - 14.0f;
        float f4 = this.position.x;
        float f5 = this.position.y + this.height * 0.5f;
        int n2 = 0;
        if (this.scrollBar != null) {
            n2 = this.scrollBar.getElementPosition();
        }
        for (n = 0; n < n2; ++n) {
            ((IResizableWidget)this.widgets.get(n)).setVisible(false);
        }
        for (n = n2; n < n2 + this.visibleRows && n < this.widgets.size(); ++n) {
            IResizableWidget iResizableWidget = (IResizableWidget)this.widgets.get(n);
            f5 -= f * 0.5f;
            if (iResizableWidget != null) {
                this.tempVec.set(iResizableWidget.getPosition());
                this.tempVec.x = f4;
                this.tempVec.y = f5;
                iResizableWidget.setPosition(this.tempVec);
                iResizableWidget.setSize(f3, f2);
                iResizableWidget.setVisible(true);
            }
            f5 -= f * 0.5f;
        }
        for (n = n2 + this.visibleRows; n < this.widgets.size(); ++n) {
            ((IResizableWidget)this.widgets.get(n)).setVisible(false);
        }
        if (this.scrollBar != null) {
            this.scrollBar.setSize(14.0f, this.height);
            this.scrollBar.setPosition(new Vector2f(this.position.x + this.width * 0.5f - 7.0f, this.position.y));
        }
    }

    public ScrollBar getScrollBar() {
        return this.scrollBar;
    }

    public void setScrollBar(ScrollBar scrollBar) {
        if (this.scrollBar != null) {
            this.scrollBar.setElementPositionChangedListener(null);
        }
        this.scrollBar = scrollBar;
        if (scrollBar != null) {
            scrollBar.setElementPositionChangedListener(this);
            scrollBar.setNumberOfElements(this.widgets.size());
            scrollBar.setNumberOfVisibleElements(this.visibleRows);
        }
        this.doLayout();
    }

    public void onElementPositionChanged(ScrollBar scrollBar, int n) {
        this.doLayout();
    }
}

