/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gameobjects;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.msm.gameobjects.ParticleFXGameObject;

public class WidgetFXGameObject
extends ParticleFXGameObject {
    private BaseWidget widget;
    private ResizeMode resizeMode = ResizeMode.HeightOfWidget;
    private Vector2f scaleMultiplier;

    public WidgetFXGameObject(String string, BaseWidget baseWidget, ResizeMode resizeMode) {
        super(string);
        this.setWidget(baseWidget);
        this.setResizeMode(resizeMode);
    }

    public void start() {
        if (this.getWidget() == null) {
            return;
        }
        this.setPosition(this.getWidget().getLocalTranslation());
        this.setScale();
        super.start();
    }

    private void setPosition(Vector3f vector3f) {
        for (int i = 0; i < this.getNumberOfSystems(); ++i) {
            Node node = this.getNode(i);
            node.getLocalTranslation().set(vector3f);
        }
    }

    public void setScaleMultiplier(Vector2f vector2f) {
        this.scaleMultiplier = vector2f;
    }

    private void setScale() {
        for (int i = 0; i < this.getNumberOfSystems(); ++i) {
            Node node = this.getNode(i);
            this.resizeMode.getScale(this.getWidget(), node.getLocalScale());
            if (this.scaleMultiplier == null) continue;
            node.getLocalScale().set(node.getLocalScale().x * this.scaleMultiplier.x, node.getLocalScale().y * this.scaleMultiplier.y, node.getLocalScale().z);
        }
    }

    public void setResizeMode(ResizeMode resizeMode) {
        this.resizeMode = resizeMode;
    }

    public ResizeMode getResizeMode() {
        return this.resizeMode;
    }

    public void preInit() {
        super.preInit();
        this.setRenderQueueMode(4);
        ZBufferState zBufferState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(7);
        zBufferState.setWritable(false);
        for (int i = 0; i < this.getNumberOfSystems(); ++i) {
            Node node = this.getNode(i);
            node.setRenderState(zBufferState);
            node.updateRenderState();
        }
    }

    public void setWidget(BaseWidget baseWidget) {
        this.widget = baseWidget;
    }

    public BaseWidget getWidget() {
        return this.widget;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResizeMode {
        WidthOfWidget{

            public Vector3f getScale(BaseWidget baseWidget, Vector3f vector3f) {
                vector3f.x = baseWidget.getWidth();
                vector3f.y = baseWidget.getWidth();
                return vector3f;
            }
        }
        ,
        HeightOfWidget{

            public Vector3f getScale(BaseWidget baseWidget, Vector3f vector3f) {
                vector3f.x = baseWidget.getHeight();
                vector3f.y = baseWidget.getHeight();
                return vector3f;
            }
        }
        ,
        Both{

            public Vector3f getScale(BaseWidget baseWidget, Vector3f vector3f) {
                vector3f.x = baseWidget.getWidth();
                vector3f.y = baseWidget.getHeight();
                return vector3f;
            }
        };


        public abstract Vector3f getScale(BaseWidget var1, Vector3f var2);
    }
}

