/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gameobjects;

import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Box;
import com.jme.util.geom.BufferUtils;
import com.turborilla.SpatialTransformationProvider;
import com.turborilla.event.typesafe.EventErrorException;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.gameobject.GameObject;
import com.turborilla.msm.physics.collision.CollisionGrid;
import com.turborilla.physics.collision.CollisionStructure;
import com.turborilla.physics.collision.IntersectionResult;
import com.turborilla.physics.collision.Triangle;
import com.turborilla.utils.math.Vector3d;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class StartLineGameObject
extends GameObject {
    private Node node;
    private StartCollisionGrid startGrid;
    private CollisionStructure parentGrid;
    private Box box;
    private float startz;
    private float endz;
    private float height;
    private float width;
    private boolean raceStarted = false;
    private boolean startFenceIsDown = false;
    private float angle = -0.3f;
    private float endAngle = -1.5707964f;
    private float angleSpeed = 0.06f;
    private Vector3f rotAxis = new Vector3f(0.0f, 0.0f, 1.0f);

    public StartLineGameObject(CollisionStructure collisionStructure, float f, float f2, float f3, float f4) {
        super("StartLine");
        this.parentGrid = collisionStructure;
        this.startGrid = null;
        this.node = new Node();
        this.startz = f;
        this.endz = f2;
        this.height = f3;
        this.width = f4;
    }

    public void init() {
        this.raceStarted = false;
        this.startFenceIsDown = false;
        this.angle = -0.3f;
        this.endAngle = -1.5707964f;
        this.angleSpeed = 0.06f;
        this.rotAxis = new Vector3f(0.0f, 0.0f, 1.0f);
        this.node.detachAllChildren();
        if (this.startGrid != null) {
            this.parentGrid.removeChild(this.startGrid);
        }
        this.box = new Box(this.getName() + ":box", new Vector3f(-this.width * 0.1f, 0.0f, this.startz), new Vector3f(this.width * 0.9f, this.height, this.endz));
        this.box.getLocalRotation().fromAngleAxis(this.angle, this.rotAxis);
        this.node.attachChild(this.box);
        this.startGrid = new StartCollisionGrid(this.box);
        this.startGrid.reconstruct();
        this.parentGrid.addChild(this.startGrid);
        try {
            this.getEventManager().registerListener("RaceStarted", this);
            this.getEventManager().registerListener("StartCountdown", this);
        }
        catch (EventErrorException eventErrorException) {
            // empty catch block
        }
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        String string = receivedEvent.getName();
        if ("RaceStarted".equals(string)) {
            this.raceStarted = true;
        }
        if ("StartCountdown".equals(string)) {
            this.init();
        }
    }

    public void update(float f) {
        super.update(f);
        if (!this.startFenceIsDown && this.raceStarted && !this.paused) {
            this.angle -= this.angleSpeed;
            if (this.angle < this.endAngle) {
                this.angle = this.endAngle;
                this.startFenceIsDown = true;
                if (this.startGrid != null) {
                    this.parentGrid.removeChild(this.startGrid);
                }
            }
            this.box.getLocalRotation().fromAngleAxis(this.angle, this.rotAxis);
        }
    }

    public Node getNode() {
        return this.node;
    }

    public void onDetach() {
        if (this.startGrid != null && this.parentGrid != null) {
            this.parentGrid.removeChild(this.startGrid);
        }
        super.onDetach();
    }

    public class StartCollisionGrid
    extends CollisionGrid {
        private Vector3f a;
        private Vector3f b;
        private Vector3f c;

        public StartCollisionGrid(TriMesh triMesh) {
            this.mesh = triMesh;
            this.setTransformationProvider(new SpatialTransformationProvider(triMesh));
        }

        public void reconstruct() {
            int n = this.mesh.getBatch(0).getTriangleCount();
            IntBuffer intBuffer = this.mesh.getBatch(0).getIndexBuffer();
            this.triangles = new Triangle[n];
            this.a = new Vector3f();
            this.b = new Vector3f();
            this.c = new Vector3f();
            FloatBuffer floatBuffer = this.mesh.getVertexBuffer(0);
            for (int i = 0; i < n; ++i) {
                BufferUtils.populateFromBuffer(this.a, floatBuffer, intBuffer.get(i * 3 + 0));
                BufferUtils.populateFromBuffer(this.b, floatBuffer, intBuffer.get(i * 3 + 1));
                BufferUtils.populateFromBuffer(this.c, floatBuffer, intBuffer.get(i * 3 + 2));
                this.triangles[i] = new Triangle(this.a, this.b, this.c);
            }
        }

        public boolean intersectSegmentLocal(Vector3d vector3d, Vector3d vector3d2, IntersectionResult intersectionResult) {
            for (Triangle triangle : this.triangles) {
                if (!triangle.intersectSegment(vector3d, vector3d2, intersectionResult)) continue;
                intersectionResult.collisionPrimitive = triangle;
                return true;
            }
            return false;
        }
    }
}

