/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gameobjects;

import com.jme.system.GameSettings;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.gameobject.GameObject;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.utils.Utils;
import java.io.IOException;

public abstract class RaceController
extends GameObject {
    private EventManager globalEventManager;
    private GameSettings settings;
    protected GameState gameState;

    public RaceController(String string, GameSettings gameSettings, GameState gameState) {
        super(string);
        this.settings = gameSettings;
        this.gameState = gameState;
    }

    public abstract void reset();

    public EventManager getGlobalEventManager() {
        return this.globalEventManager;
    }

    public void setGlobalEventManager(EventManager eventManager) {
        this.globalEventManager = eventManager;
        eventManager.registerListener("NextRace", this);
        eventManager.registerListener("RetryRace", this);
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        super.handleEvent(receivedEvent);
        if ("NextRace".equals(receivedEvent.getName())) {
            this.nextRace();
        } else if ("RetryRace".equals(receivedEvent.getName())) {
            this.retryRace();
        }
    }

    protected abstract void nextRace();

    protected void retryRace() {
        try {
            this.gameState.prepareNewRace(Utils.getProperties("controlMode", Profile.getCurrentProfile(this.getSettings()).getDifficulty().getName()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public GameSettings getSettings() {
        return this.settings;
    }

    public void setSettings(GameSettings gameSettings) {
        this.settings = gameSettings;
    }
}

