/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gameobjects;

import com.jme.scene.Node;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.turborilla.jops.jme.JopsNode;
import com.turborilla.msm.gameobjects.FXGameObject;
import java.io.IOException;
import java.net.URL;
import org.softmed.jops.ParticleManager;
import org.softmed.jops.ParticleSystem;
import org.softmed.jops.fileloading.DataFormatException;

public class ParticleFXGameObject
extends FXGameObject {
    private String particleSystemName;
    private ParticleManager particleManager;
    private JopsNode[] jopsNodes;
    private ParticleSystem[] particleSystems;
    private boolean wasRepeat = false;
    private boolean particlesWorldOriented = false;
    private int numberOfSystems;
    private boolean detachWhenDone = false;
    private boolean[] started;

    public ParticleFXGameObject(String string) {
        this(string, 1);
    }

    public ParticleFXGameObject(String string, int n) {
        super(string);
        this.numberOfSystems = n;
        this.particleManager = new ParticleManager();
        this.jopsNodes = new JopsNode[this.getNumberOfSystems()];
        this.particleSystems = new ParticleSystem[this.getNumberOfSystems()];
        this.started = new boolean[this.getNumberOfSystems()];
        for (int i = 0; i < this.getNumberOfSystems(); ++i) {
            this.jopsNodes[i] = new JopsNode("JopsNode" + i);
            this.started[i] = false;
        }
    }

    public void load(String string) throws IOException, DataFormatException {
        URL uRL = ParticleFXGameObject.class.getClassLoader().getResource("particles/" + string + ".ops");
        if (uRL == null) {
            throw new IOException("File does not exist.");
        }
        this.particleSystemName = this.particleManager.load(uRL);
        for (int i = 0; i < this.getNumberOfSystems(); ++i) {
            ParticleSystem particleSystem = this.particleManager.getCopyDetached(this.particleSystemName);
            this.jopsNodes[i].setParticleSystem(particleSystem);
            this.wasRepeat = particleSystem.isRepeat();
            particleSystem.setLimited(true);
            particleSystem.setAlive(false);
            this.jopsNodes[i].attachChild(this.jopsNodes[i].getParticleNode());
            this.jopsNodes[i].setCullMode(2);
            this.jopsNodes[i].updateRenderState();
            this.particleSystems[i] = particleSystem;
        }
        this.preInit();
    }

    public void preInit() {
        for (ParticleSystem particleSystem : this.particleSystems) {
            particleSystem.reset();
            particleSystem.setAlive(true);
            particleSystem.processFrame(1.0E-6f);
            particleSystem.setAlive(false);
        }
    }

    public void setOrtho() {
        for (int i = 0; i < this.getNumberOfSystems(); ++i) {
            JopsNode jopsNode = this.jopsNodes[i];
            jopsNode.setRenderQueueMode(4);
            ZBufferState zBufferState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
            zBufferState.setEnabled(true);
            zBufferState.setFunction(7);
            zBufferState.setWritable(false);
            jopsNode.setRenderState(zBufferState);
            jopsNode.updateRenderState();
            jopsNode.getParticleNode().updateRenderState();
        }
    }

    public void attachToNode(Node node) {
        if (node == null) {
            return;
        }
        for (int i = 0; i < this.getNumberOfSystems(); ++i) {
            this.attachToNode(node, i);
        }
    }

    public void attachToNode(Node node, int n) {
        node.attachChild(this.getNode(n));
        if (this.isParticlesWorldOriented()) {
            node.attachChild(this.getParticleNode(n));
        } else {
            this.getNode(n).attachChild(this.getParticleNode(n));
        }
    }

    public void detachFromParent() {
        super.detachFromParent();
        for (int i = 0; i < this.getNumberOfSystems(); ++i) {
            this.detachFromParent(i);
        }
    }

    public void detachFromParent(int n) {
        if (this.getNode(n).getParent() != null) {
            this.getNode(n).getParent().detachChild(this.getParticleNode(n));
            this.getNode(n).getParent().detachChild(this.getNode(n));
        }
    }

    public Node getNode() {
        return this.getNode(0);
    }

    public Node getNode(int n) {
        return this.jopsNodes[n];
    }

    public Node getParticleNode() {
        return this.getParticleNode(0);
    }

    public Node getParticleNode(int n) {
        return this.jopsNodes[n].getParticleNode();
    }

    public void setRepeat(boolean bl) {
        this.wasRepeat = bl;
    }

    public int startFirstAvailable() {
        for (int i = 0; i < this.numberOfSystems; ++i) {
            if (this.started[i]) continue;
            this.start(i);
            return i;
        }
        return -1;
    }

    public void start() {
        for (int i = 0; i < this.getNumberOfSystems(); ++i) {
            this.start(i);
        }
    }

    public void start(int n) {
        if (this.particleSystems != null && this.particleSystems[n] != null) {
            this.particleSystems[n].reset();
            this.jopsNodes[n].setCullMode(0);
            this.particleSystems[n].setLife(0.0f);
            this.particleSystems[n].setRepeat(this.wasRepeat);
            this.particleSystems[n].setRemove(false);
            this.particleSystems[n].setAlive(true);
            this.jopsNodes[n].updateRenderState();
            this.jopsNodes[n].getParticleNode().updateRenderState();
            this.started[n] = true;
        }
    }

    public boolean isStarted(int n) {
        return this.started[n];
    }

    public void stop() {
        for (int i = 0; i < this.getNumberOfSystems(); ++i) {
            this.stop(i);
        }
    }

    public void stop(int n) {
        if (this.particleSystems[n] != null && this.started[n] && this.particleSystems[n].isRepeat()) {
            this.wasRepeat = true;
            this.particleSystems[n].setRepeat(false);
        }
    }

    public void onDetach() {
        this.detachNode();
        super.onDetach();
    }

    private void detachNode() {
        for (int i = 0; i < this.getNumberOfSystems(); ++i) {
            if (this.getNode(i).getParent() == null) continue;
            this.getNode(i).getParent().detachChild(this.getNode(i));
        }
    }

    public void update(float f) {
        int n;
        super.update(f);
        boolean bl = false;
        for (n = 0; n < this.getNumberOfSystems(); ++n) {
            if (this.particleSystems[n].isAlive()) {
                this.particleSystems[n].processFrame(f);
                if (!this.particleSystems[n].isRemove()) continue;
                this.jopsNodes[n].setCullMode(2);
                this.jopsNodes[n].updateRenderState();
                continue;
            }
            if (!this.started[n]) continue;
            this.started[n] = false;
            bl = true;
        }
        if (bl && this.isDetachWhenDone()) {
            for (n = 0; n < this.started.length; ++n) {
                if (!this.started[n]) continue;
                bl = false;
            }
            if (bl) {
                this.detachThis();
                this.detachFromParent();
                this.detachNode();
            }
        }
    }

    public void setPaused(boolean bl) {
        super.setPaused(bl);
    }

    public ParticleSystem getParticleSystem() {
        return this.getParticleSystem(0);
    }

    public ParticleSystem getParticleSystem(int n) {
        return this.particleSystems[n];
    }

    public boolean isParticlesWorldOriented() {
        return this.particlesWorldOriented;
    }

    public void setParticlesWorldOriented(boolean bl) {
        this.particlesWorldOriented = bl;
    }

    public void setZOrder(int n) {
        for (int i = 0; i < this.jopsNodes.length; ++i) {
            if (this.jopsNodes[i] == null) continue;
            this.jopsNodes[i].setZOrder(n, true);
            if (this.jopsNodes[i].getParticleNode() == null) continue;
            this.jopsNodes[i].getParticleNode().setZOrder(n, true);
        }
    }

    public void setRenderQueueMode(int n) {
        for (int i = 0; i < this.jopsNodes.length; ++i) {
            if (this.jopsNodes[i] == null) continue;
            this.jopsNodes[i].setRenderQueueMode(n);
            this.jopsNodes[i].updateRenderState();
        }
    }

    public int getNumberOfSystems() {
        return this.numberOfSystems;
    }

    public void setDetachWhenDone(boolean bl) {
        this.detachWhenDone = bl;
    }

    public boolean isDetachWhenDone() {
        return this.detachWhenDone;
    }
}

