/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gameobjects;

import com.jme.scene.Node;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.gameobject.GameObject;
import com.turborilla.msm.gameobjects.BikeGameObject;
import com.turborilla.msm.gui.turbogui.InRaceLabel;
import com.turborilla.utils.Font;
import com.turborilla.utils.math.Vector3d;

public class LeadDisplayerGameObject
extends GameObject {
    private static final double metersBetweenTires = 1.5;
    private BikeGameObject opponent;
    private BikeGameObject player;
    private Font font;
    private Node node;
    private InRaceLabel leadLabel;
    private Vector3d tempVec = new Vector3d();
    private double metersPerUnit = 1.0;
    private boolean crashing;
    private static String EVENT_PASSEDLAP = "PassedLapline";
    private static String EVENT_PASSEDHALFTIME = "PassedHalftimeLine";
    private static String EVENT_CLOSETOLAP = "CloseToLapline";
    private static String EVENT_CRASH = "Crashed";
    private static String EVENT_UNCRASH = "BackOnBike";

    public LeadDisplayerGameObject(String string, Font font, BikeGameObject bikeGameObject, BikeGameObject bikeGameObject2) {
        super(string);
        this.font = font;
        this.player = bikeGameObject;
        this.opponent = bikeGameObject2;
        this.node = new Node(this.getName() + ":node");
        this.leadLabel = new InRaceLabel("leadLabel", font, 7, 0.05f, 0.83f, "WWLap 1/2", "racelabel_background");
        this.leadLabel.setUpdateInterval(0.33f);
        this.leadLabel.setAttachToParent(this.node);
        this.node.updateRenderState();
        double d = bikeGameObject.getBikeParticleSystem().getFrontWheel().getCenterOfMass(new Vector3d()).distance(bikeGameObject.getBikeParticleSystem().getRearWheel().getCenterOfMass(new Vector3d()));
        this.metersPerUnit = 1.5 / d;
    }

    public void update(float f) {
        super.update(f);
        double d = this.getDistanceInMeters();
        String string = "+";
        if (d < 0.0) {
            string = "-";
        }
        d = Math.abs(d);
        String string2 = string + (int)Math.round(d) + "m";
        this.leadLabel.setText(string2);
    }

    private double getDistanceInMeters() {
        return this.getDistanceInUnits() * this.metersPerUnit;
    }

    private double getDistanceInUnits() {
        if (this.opponent.getBikeParticleSystem().getRider().getCenterOfMass((Vector3d)this.tempVec).x >= 0.0) {
            return this.player.getBikeParticleSystem().getRider().getCenterOfMass((Vector3d)this.tempVec).x - this.opponent.getBikeParticleSystem().getRider().getCenterOfMass((Vector3d)this.tempVec).x;
        }
        return 0.0;
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (this.player == null) {
            return;
        }
        if (receivedEvent.is(EVENT_PASSEDHALFTIME) && receivedEvent.getArgumentValue("gameObject").equals(this.player.getName())) {
            this.leadLabel.show(3.0f);
        }
        if (receivedEvent.is(EVENT_PASSEDLAP) && receivedEvent.getArgumentValue("gameObject").equals(this.player.getName()) && !this.crashing) {
            this.leadLabel.show(1.0f);
        }
        if (receivedEvent.is(EVENT_CLOSETOLAP) && receivedEvent.getArgumentValue("gameObject").equals(this.player.getName())) {
            this.leadLabel.show(Float.MAX_VALUE);
        }
        if (receivedEvent.is(EVENT_CRASH) && receivedEvent.getArgumentValue("gameObject").equals(this.player.getName())) {
            this.leadLabel.show(Float.MAX_VALUE);
            this.crashing = true;
        }
        if (receivedEvent.is(EVENT_UNCRASH) && receivedEvent.getArgumentValue("gameObject").equals(this.player.getName())) {
            if (this.crashing) {
                this.leadLabel.show(0.5f);
            }
            this.crashing = false;
        }
        if (receivedEvent.is("DisplayModeChanged") || receivedEvent.is("DisplayChangeReverted")) {
            this.leadLabel.newDisplaySize();
        }
    }

    public void registerForEvents(EventManager eventManager) {
        eventManager.registerListener(EVENT_PASSEDLAP, this);
        eventManager.registerListener(EVENT_CLOSETOLAP, this);
        eventManager.registerListener(EVENT_PASSEDHALFTIME, this);
        eventManager.registerListener(EVENT_CRASH, this);
        eventManager.registerListener(EVENT_UNCRASH, this);
        this.getParentGameState().getGlobalEventManager().registerListener("DisplayModeChanged", this);
        this.getParentGameState().getGlobalEventManager().registerListener("DisplayChangeReverted", this);
    }

    public Node getNode() {
        return this.node;
    }

    public void onDetach() {
        if (this.getParentGameState() != null && this.getParentGameState().getGlobalEventManager() != null) {
            this.getParentGameState().getGlobalEventManager().unregisterListener(this);
        }
        if (this.node.getParent() != null) {
            this.node.getParent().detachChild(this.getNode());
        }
        super.onDetach();
    }

    public void setPaused(boolean bl) {
        super.setPaused(bl);
        this.setVisible(!bl);
    }

    public void reset(BikeGameObject bikeGameObject, BikeGameObject bikeGameObject2) {
        this.player = bikeGameObject;
        this.opponent = bikeGameObject2;
        this.crashing = false;
        this.leadLabel.hide();
    }

    private void setVisible(boolean bl) {
        if (bl) {
            double d = this.getDistanceInMeters();
            if (d > 2.0 || d < -7.0) {
                this.leadLabel.show(3.0f);
            }
        } else {
            this.leadLabel.hide();
        }
    }
}

