/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gameobjects;

import com.jme.scene.Node;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.gameobject.GameObject;
import com.turborilla.msm.gui.turbogui.InRaceLabel;
import com.turborilla.utils.Font;

public class LapDisplayerGameObject
extends GameObject {
    private Node node = new Node(this.getName() + ":node");
    private GameObject gameObject;
    private int curLap;
    private int totLaps;
    private static String EVENT_PASSEDLAP = "PassedLapline";
    private static String EVENT_CLOSETOLAP = "CloseToLapline";
    private static String EVENT_CRASH = "Crashed";
    private static String EVENT_UNCRASH = "BackOnBike";
    private InRaceLabel lapLabel;
    private boolean crashing;

    public LapDisplayerGameObject(String string, Font font, GameObject gameObject, int n) {
        super(string);
        this.gameObject = gameObject;
        this.totLaps = n;
        this.curLap = 0;
        this.lapLabel = new InRaceLabel("LapLabel", font, 7, 0.07f, 0.9f, "WWLap 1/2", "racelabel_background");
        this.lapLabel.setUpdateInterval(0.033f);
        this.lapLabel.setAttachToParent(this.node);
        this.node.updateRenderState();
        this.setCurrentLap(1);
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (this.gameObject == null) {
            return;
        }
        if (receivedEvent.is(EVENT_PASSEDLAP) && receivedEvent.getArgumentValue("gameObject").equals(this.gameObject.getName())) {
            this.setCurrentLap(this.getCurrentLap() + 1);
            if (!this.crashing) {
                this.lapLabel.show(1.0f);
            }
        }
        if (receivedEvent.is(EVENT_CLOSETOLAP) && receivedEvent.getArgumentValue("gameObject").equals(this.gameObject.getName())) {
            this.lapLabel.show(Float.MAX_VALUE);
        }
        if (receivedEvent.is(EVENT_CRASH) && receivedEvent.getArgumentValue("gameObject").equals(this.gameObject.getName())) {
            this.lapLabel.show(Float.MAX_VALUE);
            this.crashing = true;
        }
        if (receivedEvent.is(EVENT_UNCRASH) && receivedEvent.getArgumentValue("gameObject").equals(this.gameObject.getName())) {
            if (this.crashing) {
                this.lapLabel.show(0.5f);
            }
            this.crashing = false;
        }
        if (receivedEvent.is("DisplayModeChanged") || receivedEvent.is("DisplayChangeReverted")) {
            this.lapLabel.newDisplaySize();
        }
    }

    public void registerForEvents(EventManager eventManager) {
        eventManager.registerListener(EVENT_PASSEDLAP, this);
        eventManager.registerListener(EVENT_CLOSETOLAP, this);
        this.getParentGameState().getGlobalEventManager().registerListener("DisplayModeChanged", this);
        this.getParentGameState().getGlobalEventManager().registerListener("DisplayChangeReverted", this);
    }

    public Node getNode() {
        return this.node;
    }

    public void setCurrentLap(int n) {
        this.curLap = n;
        this.lapLabel.setText("Lap " + this.curLap + "/" + this.totLaps);
    }

    public int getCurrentLap() {
        return this.curLap;
    }

    public void onDetach() {
        if (this.getParentGameState() != null && this.getParentGameState().getGlobalEventManager() != null) {
            this.getParentGameState().getGlobalEventManager().unregisterListener(this);
        }
        if (this.node.getParent() != null) {
            this.node.getParent().detachChild(this.getNode());
        }
        super.onDetach();
    }

    public void setPaused(boolean bl) {
        super.setPaused(bl);
        this.setVisible(!bl);
    }

    public void reset(GameObject gameObject, int n) {
        this.gameObject = gameObject;
        this.totLaps = n;
        this.crashing = false;
        this.setCurrentLap(1);
        this.lapLabel.hide();
    }

    private void setVisible(boolean bl) {
        if (bl) {
            this.lapLabel.show(3.0f);
        } else {
            this.lapLabel.hide();
        }
    }
}

