/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gameobjects;

import com.jme.image.Texture;
import com.jme.math.Vector3f;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.turborilla.msm.gameobjects.FXGameObject;
import com.turborilla.msm.loaders.ResourceManager;
import java.io.IOException;

public class GlideFXGameObject
extends FXGameObject {
    private Quad quad;
    private float targetYScale = 1.0f;
    private float deltaY = 0.0f;
    private boolean scaling = false;
    private final float width = 2.34f;
    private final float height = 2.34f;
    private float yScaleOffset = 0.3f;
    private Vector3f offset = new Vector3f(0.5f, -0.35f, 0.0f);
    private float previousTargetYScale = 1.0f;

    public GlideFXGameObject() {
        super("GlideFXGameObject");
    }

    public void init() throws IOException {
        Texture texture = (Texture)ResourceManager.getInstance().load("texture", "glider", null);
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        textureState.setTexture(texture);
        AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        this.quad = new Quad("wings", 2.34f, 2.34f);
        this.quad.setLocalScale(new Vector3f(1.0f, 0.0f, 1.0f));
        this.quad.getLocalTranslation().x = this.offset.x;
        this.getNode().attachChild(this.quad);
        this.getNode().setRenderState(textureState);
        this.getNode().setRenderState(alphaState);
        this.getNode().updateRenderState();
    }

    public void scaleYTo(float f, float f2) {
        this.previousTargetYScale = this.targetYScale;
        this.targetYScale = f;
        this.scaling = true;
        float f3 = this.quad.getLocalScale().y;
        float f4 = f - f3;
        this.deltaY = f4 / f2;
    }

    public void update(float f) {
        super.update(f);
        if (this.scaling) {
            this.quad.getLocalScale().y += this.deltaY * f;
            if (this.deltaY < 0.0f && this.quad.getLocalScale().y < this.targetYScale || this.deltaY > 0.0f && this.quad.getLocalScale().y > this.targetYScale) {
                this.scaling = false;
                this.quad.getLocalScale().y = this.targetYScale;
            }
            this.quad.getLocalTranslation().y = this.deltaY > 0.0f ? this.offset.y + (this.targetYScale - this.quad.getLocalScale().y) / this.targetYScale * this.yScaleOffset : this.offset.y + (this.previousTargetYScale - this.quad.getLocalScale().y) / this.previousTargetYScale * this.yScaleOffset;
        }
    }

    public boolean getScaling() {
        return this.scaling;
    }
}

