/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gameobjects;

import com.jme.scene.Node;
import com.turborilla.TransformationProvider;
import com.turborilla.gameobject.GameObject;
import com.turborilla.msm.components.LineComponent;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FinishlineGameObject
extends GameObject {
    private Node node = new Node(this.getName() + ":node");
    private LineComponent lineComponent;
    private float finishLineWidth = 2.0f;
    private float proximityThreshold = 70.0f;
    private LineComponent proximityLine;

    public FinishlineGameObject() {
        this("FinishLineGameObject");
    }

    protected FinishlineGameObject(String string) {
        super(string);
        this.node.setLightCombineMode(0);
    }

    public void init(float f, String string) {
        this.node.detachAllChildren();
        this.lineComponent = new LineComponent("Startline", this.finishLineWidth, f, string);
        this.addComponent(this.lineComponent);
        this.lineComponent.setListener(new LineComponent.IGameObjectPassedLineListener(){

            public void gameObjectPassedLine(GameObject gameObject, LineComponent lineComponent) {
                FinishlineGameObject.this.aGameObjectPassedLine(gameObject);
            }
        });
        this.node.attachChild(this.lineComponent.getSpatial());
        this.proximityLine = new LineComponent("Startline", this.finishLineWidth, f - this.proximityThreshold, null);
        this.addComponent(this.proximityLine);
        this.proximityLine.setListener(new LineComponent.IGameObjectPassedLineListener(){

            public void gameObjectPassedLine(GameObject gameObject, LineComponent lineComponent) {
                FinishlineGameObject.this.aGameObjectCloseToLine(gameObject);
            }
        });
        this.node.attachChild(this.proximityLine.getSpatial());
        this.node.updateRenderState();
        this.node.updateGeometricState(0.0f, true);
    }

    public void reset() {
        this.lineComponent.reset();
        this.proximityLine.reset();
    }

    protected void aGameObjectPassedLine(GameObject gameObject) {
        this.getEventManager().fireEvent("PassedFinishline", new String[][]{{"gameObject"}, {gameObject.getName()}});
    }

    protected void aGameObjectCloseToLine(GameObject gameObject) {
        this.getEventManager().fireEvent("CloseToFinishline", new String[][]{{"gameObject"}, {gameObject.getName()}});
    }

    public void addObjectToCheckAgainstLine(GameObject gameObject, TransformationProvider[] transformationProviderArray, float[] fArray) {
        this.lineComponent.addObjectToCheckAgainstLine(gameObject, transformationProviderArray, fArray);
        this.proximityLine.addObjectToCheckAgainstLine(gameObject, transformationProviderArray, fArray);
    }

    public Node getNode() {
        return this.node;
    }

    public ArrayList<GameObject> getFinishOrder() {
        return this.lineComponent.getPassedLineOrder();
    }
}

