/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gameobjects;

import com.jme.math.Vector2f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.system.DisplaySystem;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.gameobject.GameObject;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.widget.utils.ColumnLayout;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.track.challenges.IChallenge;
import com.turborilla.utils.Font;
import com.turborilla.utils.Scheduling;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayChallengesGameObject
extends GameObject {
    private Font font;
    private Node node;
    private static ColorRGBA hideColor = new ColorRGBA(1.0f, 0.0f, 0.0f, 0.0f);
    private static ColorRGBA showColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private Label[] label;
    private Scheduling taskManager;
    private ColumnLayout layout;
    private Vector2f position = new Vector2f();
    private static final int maxNumber = 5;

    public DisplayChallengesGameObject(String string, Font font) {
        super(string);
        this.font = font;
        this.node = new Node(this.getName() + ":node");
        this.taskManager = new Scheduling();
        this.layout = new ColumnLayout();
        this.label = new Label[5];
        for (int i = 0; i < 5; ++i) {
            this.label[i] = new Label(this.getName() + ":label" + i, "", font, 1.0f, 1.0f);
            this.layout.add(this.label[i]);
            this.label[i].getFader().setColor(hideColor);
            this.label[i].setHorisontalAlignment(HorisontalAlignment.LEFT);
        }
    }

    public void show(Iterator<IChallenge> iterator) {
        int n;
        this.reset();
        if (iterator == null) {
            return;
        }
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        float f = displaySystem.getWidth();
        float f2 = displaySystem.getHeight();
        this.position.set(f * 0.3f, f2 * 0.76f);
        this.layout.set(this.position, f * 0.4f, f2 * 0.2f, 0.0f);
        if (iterator.hasNext()) {
            this.label[0].setText("Challenge:");
            this.node.attachChild(this.label[0]);
            this.label[0].getFader().fadeTo(showColor, 0.15f);
        }
        for (n = 1; iterator.hasNext() && n < 5; ++n) {
            IChallenge iChallenge = iterator.next();
            String string = iChallenge.getDescription();
            this.label[n].setText(string);
            this.node.attachChild(this.label[n]);
            this.label[n].getFader().setColor(showColor);
        }
        float f3 = (float)n - 1.0f;
        while (n < 5) {
            this.node.detachChild(this.label[n]);
            this.label[n].getFader().setColor(hideColor);
            ++n;
        }
        this.layout.doLayout();
        this.taskManager.add(new Runnable(){

            public void run() {
                DisplayChallengesGameObject.this.hide();
            }
        }, 2.0f + f3 * 10.0f);
    }

    public void hide() {
        this.taskManager.clearSchedule();
        for (int i = 0; i < 5; ++i) {
            this.label[i].getFader().fadeTo(hideColor, 0.7f);
        }
        this.taskManager.add(new Runnable(){

            public void run() {
                for (int i = 0; i < 5; ++i) {
                    DisplayChallengesGameObject.this.node.detachChild(DisplayChallengesGameObject.this.label[i]);
                }
            }
        }, 0.9f);
    }

    public void reset() {
        this.taskManager.clearSchedule();
        for (int i = 0; i < 5; ++i) {
            this.label[i].getFader().clearFadeQueue();
            this.label[i].getFader().setColor(hideColor);
            this.node.detachChild(this.label[i]);
        }
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public void onDetach() {
        if (this.node.getParent() != null) {
            this.node.getParent().detachChild(this.getNode());
        }
        super.onDetach();
    }

    @Override
    public void handleEvent(ReceivedEvent receivedEvent) {
        if (receivedEvent.is("PassedStartline")) {
            this.hide();
        }
    }

    @Override
    public void update(float f) {
        super.update(f);
        this.taskManager.update(f);
    }

    @Override
    public void registerForEvents(EventManager eventManager) {
        eventManager.registerListener("PassedStartline", this);
    }
}

